/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.common.calibratorCatalogue.calQueryParameters.types.CalibrationUseType;
import alma.entity.xmlbinding.obsproject.QuerySourceT;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.site.SiteCharacteristics;
import alma.obsprep.bo.obsproject.IQuerySource;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.obsproject.data.QuerySourceData;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.valuetypes.Angle;
import alma.valuetypes.Latitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Velocity;
import alma.valuetypes.data.LatitudeData;
import java.util.Arrays;
import java.util.List;

public class QuerySource
extends QuerySourceData
implements IQuerySource,
TargetWithIntent {
    private TargetParameters keyTargetParameters;

    public QuerySource(QuerySourceT querySourceT) {
        super(querySourceT);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setUse(CalibrationUseType.UNDEFINED.toString());
    }

    public static QuerySource createQuerySource(String string) {
        List<String> list = Arrays.asList(QuerySource.getKnownIntendedUseList());
        if (!list.contains(string)) {
            throw new AssertionError((Object)(string + " is an unknown use for a calibrator"));
        }
        QuerySource querySource = QuerySource.createQuerySource();
        querySource.setIntendedUse(string);
        return querySource;
    }

    @Override
    public ObsType getObsType() {
        return ObsType.getObsType(this);
    }

    @Override
    public Velocity getSourceVelocity() {
        return Velocity.createVelocity();
    }

    @Override
    public SkyCoordinates getSourceCoordinates() {
        return this.getQueryCenter();
    }

    public boolean isMaxElevationNeverVisible() {
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        Angle angle = almaCapabilities.getElLimit();
        double d = angle.getContentInUnits(Angle.UNIT_DEG);
        SiteCharacteristics siteCharacteristics = SiteCharacteristics.getInstance();
        Latitude latitude = siteCharacteristics.getObsLatitude();
        double d2 = 90.0 - d;
        SkyCoordinates skyCoordinates = this.getSourceCoordinates().getICRSSkyCoordinates();
        double d3 = Math.abs(skyCoordinates.getLatitude().getContentInUnits(LatitudeData.UNIT_DEG) - latitude.getContentInUnits(LatitudeData.UNIT_DEG));
        return d3 > d2;
    }

    public void setKeyTargetParameters(TargetParameters targetParameters) {
        this.keyTargetParameters = targetParameters;
    }

    public TargetParameters getKeyTargetParameters() {
        return this.keyTargetParameters;
    }

    public String toString() {
        return "QuerySource [keyTargetParameters=" + this.keyTargetParameters + " type " + this.getObsType() + "]";
    }
}

