/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.ArrayRequested;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.Problem;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.RequiredConfigurations;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.DGCExpert;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.obsparams.UnableToDetermineCalibrationTimeException;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.valuetypes.DataRate;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class P2GAlerter {
    private final ObsProject obsProject;

    public P2GAlerter(@NonNull ObsProject obsProject) {
        if (obsProject == null) {
            throw new NullPointerException("obsProject is marked non-null but is null");
        }
        this.obsProject = obsProject;
    }

    public void determineIfP2GAttentionNeeded(@NonNull ProblemListModel problemListModel) {
        if (problemListModel == null) {
            throw new NullPointerException("problemListModel is marked non-null but is null");
        }
        EnumSet<P2GAttentionReasons> enumSet = EnumSet.noneOf(P2GAttentionReasons.class);
        this.isVLBIUsed(enumSet);
        this.isDataRateHigh(enumSet, this.obsProject.getObsProgram());
        this.isTPUsed(enumSet, this.obsProject.getObsProgram());
        this.isMultipleTuningsUsed(enumSet, this.obsProject.getObsProgram());
        this.isSpectralScanUsed(enumSet);
        this.isFullPolarizationSelected(enumSet);
        this.isExternalEphemerisSelected(enumSet);
        this.isTimeConstrained(enumSet);
        this.isHighFrequency(enumSet);
        this.isNarrowAggregateBW(enumSet, problemListModel);
        this.isLongBaseline(enumSet, this.obsProject.getObsProgram());
        this.isSolar(enumSet);
        this.isResubmission(enumSet);
        this.isUserDefinedCalibrations(enumSet);
        this.isSpecWindowOutsideAntiAliasingFilter(enumSet, problemListModel);
        this.isBasebandTooCloseToBandEdge(enumSet, problemListModel);
        this.isB5Used(enumSet);
        this.isDGCUsed(enumSet);
        try {
            this.isB7SGValidWithLongBaseline(enumSet, this.obsProject);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            Log.logger(P2GAlerter.class).warning("Unable to determine whether the B7 SGs are valid with long baselines");
        }
        if (enumSet.isEmpty()) {
            this.obsProject.setP2gAttention(false);
            this.obsProject.setP2gAttentionReasons("");
        } else {
            this.obsProject.setP2gAttention(true);
            StringBuffer stringBuffer = new StringBuffer();
            enumSet.stream().forEach(p2GAttentionReasons -> stringBuffer.append(p2GAttentionReasons.getReason() + ","));
            this.obsProject.setP2gAttentionReasons(StringUtils.chop((String)stringBuffer.toString()));
        }
        enumSet.stream().forEach(p2GAttentionReasons -> Log.logger(P2GAlerter.class).info("Reason for P2G to be alerted to this " + p2GAttentionReasons.getReason()));
    }

    private void isDGCUsed(@NonNull EnumSet<P2GAttentionReasons> enumSet) {
        if (enumSet == null) {
            throw new NullPointerException("reasons is marked non-null but is null");
        }
        this.getScienceGoalsForCurrentPhase(this.obsProject).stream().forEach(scienceGoal -> {
            if (scienceGoal.getCalibrationSetupParameters().getIsDGCOverride()) {
                enumSet.add(P2GAttentionReasons.DGCREQUIREDOVERRIDDEN);
            } else if (!Sets.intersection(DGCExpert.dgcObservingStrategiesRequired(scienceGoal, true), DGCExpert.allDGCStrategies).isEmpty()) {
                enumSet.add(P2GAttentionReasons.DGCREQUIRED);
            }
        });
    }

    private void isB7SGValidWithLongBaseline(@NonNull EnumSet<P2GAttentionReasons> enumSet, @NonNull ObsProject obsProject) throws InvalidObsProgramParametersException {
        if (enumSet == null) {
            throw new NullPointerException("reasons is marked non-null but is null");
        }
        if (obsProject == null) {
            throw new NullPointerException("obsProject is marked non-null but is null");
        }
        ObsProposal obsProposal = null;
        try {
            obsProposal = obsProject.getObsProposal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(P2GAlerter.class).warning("Unable to determine obsproposal");
        }
        assert (obsProposal != null);
        if (obsProposal.isVLBIorPhasedArray()) {
            return;
        }
        List<ScienceGoal> list = this.getScienceGoalsForCurrentPhase(obsProject);
        for (AbstractScienceGoal abstractScienceGoal : list) {
            Object object;
            ScienceGoal scienceGoal;
            ReceiverBand receiverBand;
            if (!(abstractScienceGoal instanceof ScienceGoal) || (receiverBand = (scienceGoal = (ScienceGoal)((Object)abstractScienceGoal)).getReceiverBand()) == null || receiverBand.getNumber() != 7 || scienceGoal.isStandAloneACA()) continue;
            RequiredConfigurations requiredConfigurations = null;
            try {
                object = scienceGoal.getPerformanceParameters();
                requiredConfigurations = SchedBlockExpert.getRecommended12mConfigurations(scienceGoal, object.getRepresentativeFrequency());
            }
            catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                continue;
            }
            assert (requiredConfigurations != null);
            object = requiredConfigurations.getBest12mExtConfig();
            try {
                boolean bl = SingleFieldScienceGoalModel.isB7WithLongbaselineConfigurationNonStandard(scienceGoal, receiverBand, (Configuration)object);
                if (!bl) continue;
                enumSet.add(P2GAttentionReasons.B7INVALIDWITHLONGBASELINE);
                return;
            }
            catch (SourceNeverVisibleException | InvalidFrequencyException | UnableToDetermineCalibrationTimeException exception) {
            }
        }
    }

    private void isB5Used(@NonNull EnumSet<P2GAttentionReasons> enumSet) {
        if (enumSet == null) {
            throw new NullPointerException("reasons is marked non-null but is null");
        }
        if (this.obsProject == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: obsProgram");
        }
        List<ScienceGoal> list = this.getScienceGoalsForCurrentPhase(this.obsProject);
        if (list == null || list.size() == 0) {
            Log.logger(P2GAlerter.class).warning("Unable to determine if we have a B5 project");
        }
        for (ScienceGoal scienceGoal : list) {
            ReceiverBand receiverBand;
            if (!this.isScienceGoalToBeProcessed(scienceGoal) || (receiverBand = scienceGoal.getSpectralSetupParameters().getReceiverBand()) == null || receiverBand.getNumber() != 5) continue;
            enumSet.add(P2GAttentionReasons.BANDFIVE);
            return;
        }
    }

    private List<ScienceGoal> getScienceGoalsForCurrentPhase(@NonNull ObsProject obsProject) {
        if (obsProject == null) {
            throw new NullPointerException("obsProject is marked non-null but is null");
        }
        ScienceGoal[] scienceGoalArray = null;
        try {
            if (obsProject.getObsProgram() != null) {
                scienceGoalArray = obsProject.getObsProgram().getAbstractScienceGoalScienceGoal();
                if (scienceGoalArray.length == 0 && obsProject.getObsProposal() != null) {
                    scienceGoalArray = obsProject.getObsProposal().getAbstractScienceGoalScienceGoal();
                }
            } else if (obsProject.getObsProposal() != null) {
                scienceGoalArray = obsProject.getObsProposal().getAbstractScienceGoalScienceGoal();
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            scienceGoalArray = obsProject.getObsProgram().getAbstractScienceGoalScienceGoal();
        }
        return Arrays.asList(scienceGoalArray);
    }

    private void isResubmission(@NonNull EnumSet<P2GAttentionReasons> enumSet) {
        if (enumSet == null) {
            throw new NullPointerException("reasons is marked non-null but is null");
        }
        try {
            ObsProposal obsProposal = this.obsProject.getObsProposal();
            if (obsProposal.hasIsResubmission() && obsProposal.getIsResubmission()) {
                enumSet.add(P2GAttentionReasons.RESUBMISSION);
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(P2GAlerter.class).info("Unable to determine if resubmission : " + unknownEntityException.getMessage());
        }
    }

    private void isBasebandTooCloseToBandEdge(@NonNull EnumSet<P2GAttentionReasons> enumSet, @NonNull ProblemListModel problemListModel) {
        if (enumSet == null) {
            throw new NullPointerException("reasons is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("problemListModel is marked non-null but is null");
        }
        for (Problem problem : problemListModel) {
            if (!problem.getSuggestion().equals("Move spws/basebands further away from the edge of the frequency band.") || !this.isProblemToBeProcessed(problem)) continue;
            enumSet.add(P2GAttentionReasons.BANDEDGEDOPPLER);
            break;
        }
    }

    private void isSpecWindowOutsideAntiAliasingFilter(@NonNull EnumSet<P2GAttentionReasons> enumSet, @NonNull ProblemListModel problemListModel) {
        if (enumSet == null) {
            throw new NullPointerException("reasons is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("problemListModel is marked non-null but is null");
        }
        for (Problem problem : problemListModel) {
            if (!problem.getSuggestion().equals("Move the spw away from the baseband edge to avoid this problem.") || !this.isProblemToBeProcessed(problem)) continue;
            enumSet.add(P2GAttentionReasons.WINDOWOUTSIDEANTIALIASINGFILTER);
            break;
        }
        for (Problem problem : problemListModel.getUnpublishedProblems()) {
            if (!problem.getDescription().equals("Spec. window has centre set near or outside anti-aliasing filter") || !this.isProblemToBeProcessed(problem)) continue;
            enumSet.add(P2GAttentionReasons.WINDOWOUTSIDEANTIALIASINGFILTER);
            break;
        }
    }

    private void isUserDefinedCalibrations(@NonNull EnumSet<P2GAttentionReasons> enumSet) {
        if (enumSet == null) {
            throw new NullPointerException("reasons is marked non-null but is null");
        }
        for (ScienceGoal scienceGoal : this.getScienceGoalsForCurrentPhase(this.obsProject)) {
            CalibrationSetupParameters calibrationSetupParameters = scienceGoal.getCalibrationSetupParameters();
            if (!calibrationSetupParameters.isUserDefinedCalibration() || !this.isScienceGoalToBeProcessed(scienceGoal)) continue;
            enumSet.add(P2GAttentionReasons.USERDEFINEDCALIBRATIONS);
            return;
        }
    }

    private void isSolar(@NonNull EnumSet<P2GAttentionReasons> enumSet) {
        if (enumSet == null) {
            throw new NullPointerException("reasons is marked non-null but is null");
        }
        for (ScienceGoal scienceGoal : this.getScienceGoalsForCurrentPhase(this.obsProject)) {
            if (!this.isScienceGoalToBeProcessed(scienceGoal)) continue;
            try {
                if (!scienceGoal.isSolarScienceGoal()) continue;
                enumSet.add(P2GAttentionReasons.SOLAR);
                return;
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(P2GAlerter.class).warning("Unable to determine if a science goal is solar " + unknownEntityException.getMessage());
            }
        }
    }

    private void isLongBaseline(@NonNull EnumSet<P2GAttentionReasons> enumSet, @NonNull ObsProgram obsProgram) {
        if (enumSet == null) {
            throw new NullPointerException("reasons is marked non-null but is null");
        }
        if (obsProgram == null) {
            throw new NullPointerException("obsProgram is marked non-null but is null");
        }
        for (ScienceGoal scienceGoal : obsProgram.getAbstractScienceGoalScienceGoal()) {
            if (!this.isScienceGoalToBeProcessed(scienceGoal)) continue;
            ObsUnitSet obsUnitSet2 = scienceGoal.getObsUnitSet();
            Predicate<ObsUnitSet> predicate = obsUnitSet -> {
                try {
                    for (SchedBlock schedBlock : obsUnitSet.getSchedBlock()) {
                        List<String> list = Arrays.asList(schedBlock.getSchedulingConstraints().getNominalConfiguration());
                        Configuration.getLongBaseLineConfigurations().stream().forEach(configuration -> {
                            if (list.contains(configuration.getName())) {
                                enumSet.add(P2GAttentionReasons.LONGBASELINE);
                            }
                        });
                        if (!enumSet.contains((Object)P2GAttentionReasons.LONGBASELINE)) continue;
                        return true;
                    }
                }
                catch (UnknownEntityException unknownEntityException) {
                    // empty catch block
                }
                return false;
            };
            if (obsUnitSet2 == null || !this.locateConditionInOUSHierachy(enumSet, obsUnitSet2, predicate)) continue;
            return;
        }
    }

    private void isNarrowAggregateBW(@NonNull EnumSet<P2GAttentionReasons> enumSet, @NonNull ProblemListModel problemListModel) {
        if (enumSet == null) {
            throw new NullPointerException("reasons is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("problemListModel is marked non-null but is null");
        }
        for (Problem problem : problemListModel.getUnpublishedProblems()) {
            if (!problem.getSuggestion().equals(SingleFieldScienceGoalModel.NonStandardMode.BANDWIDTH_SWITCHING.getExplanation()) || !this.isProblemToBeProcessed(problem)) continue;
            enumSet.add(P2GAttentionReasons.NARROWAGGREGATEBW);
            break;
        }
    }

    private boolean isProblemToBeProcessed(Problem problem) {
        if (problem.getResource() instanceof ScienceGoal) {
            ScienceGoal scienceGoal = (ScienceGoal)problem.getResource();
            return this.isScienceGoalToBeProcessed(scienceGoal);
        }
        return true;
    }

    private void isHighFrequency(@NonNull EnumSet<P2GAttentionReasons> enumSet) {
        if (enumSet == null) {
            throw new NullPointerException("reasons is marked non-null but is null");
        }
        for (ScienceGoal scienceGoal : this.getScienceGoalsForCurrentPhase(this.obsProject)) {
            ReceiverBand receiverBand;
            if (!this.isScienceGoalToBeProcessed(scienceGoal) || (receiverBand = scienceGoal.getSpectralSetupParameters().getReceiverBand()) == null || !ReceiverBand.isReceiverBandInSet(receiverBand, 8, 9, 10)) continue;
            enumSet.add(P2GAttentionReasons.HIGHFREQUENCY);
            return;
        }
    }

    private void isTimeConstrained(@NonNull EnumSet<P2GAttentionReasons> enumSet) {
        if (enumSet == null) {
            throw new NullPointerException("reasons is marked non-null but is null");
        }
        for (ScienceGoal scienceGoal : this.getScienceGoalsForCurrentPhase(this.obsProject)) {
            if (!scienceGoal.getPerformanceParameters().getIsTimeConstrained() || !this.isScienceGoalToBeProcessed(scienceGoal)) continue;
            enumSet.add(P2GAttentionReasons.TIMECONSTRAINED);
            return;
        }
    }

    private void isExternalEphemerisSelected(@NonNull EnumSet<P2GAttentionReasons> enumSet) {
        if (enumSet == null) {
            throw new NullPointerException("reasons is marked non-null but is null");
        }
        for (ScienceGoal scienceGoal : this.getScienceGoalsForCurrentPhase(this.obsProject)) {
            if (!this.isScienceGoalToBeProcessed(scienceGoal)) continue;
            for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
                if (!targetParameters.getNonSiderealMotion() || !StringUtils.isNotEmpty((CharSequence)targetParameters.getSourceEphemeris())) continue;
                enumSet.add(P2GAttentionReasons.EXTERNALEPHEMERIS);
                return;
            }
        }
    }

    private void isFullPolarizationSelected(@NonNull EnumSet<P2GAttentionReasons> enumSet) {
        if (enumSet == null) {
            throw new NullPointerException("reasons is marked non-null but is null");
        }
        for (ScienceGoal scienceGoal : this.getScienceGoalsForCurrentPhase(this.obsProject)) {
            if (!this.isScienceGoalToBeProcessed(scienceGoal) || !scienceGoal.getSpectralSetupParameters().isFullPolarisation()) continue;
            enumSet.add(P2GAttentionReasons.FULLPOLARISATION);
            return;
        }
    }

    private void isSpectralScanUsed(@NonNull EnumSet<P2GAttentionReasons> enumSet) {
        if (enumSet == null) {
            throw new NullPointerException("reasons is marked non-null but is null");
        }
        for (ScienceGoal scienceGoal : this.getScienceGoalsForCurrentPhase(this.obsProject)) {
            if (!this.isScienceGoalToBeProcessed(scienceGoal) || !scienceGoal.isSpectralScan()) continue;
            enumSet.add(P2GAttentionReasons.SPECTRALSCAN);
            return;
        }
    }

    private void isMultipleTuningsUsed(@NonNull EnumSet<P2GAttentionReasons> enumSet, @NonNull ObsProgram obsProgram) {
        if (enumSet == null) {
            throw new NullPointerException("reasons is marked non-null but is null");
        }
        if (obsProgram == null) {
            throw new NullPointerException("obsProgram is marked non-null but is null");
        }
        for (ScienceGoal scienceGoal : this.obsProject.getObsProgram().getAbstractScienceGoalScienceGoal()) {
            if (!this.isScienceGoalToBeProcessed(scienceGoal)) continue;
            ObsUnitSet obsUnitSet2 = scienceGoal.getObsUnitSet();
            Predicate<ObsUnitSet> predicate = obsUnitSet -> {
                try {
                    for (SchedBlock schedBlock : obsUnitSet.getSchedBlock()) {
                        if (schedBlock.getObservingGroupCount() <= 2) continue;
                        enumSet.add(P2GAttentionReasons.MULTIPLETUNINGS);
                        return true;
                    }
                }
                catch (UnknownEntityException unknownEntityException) {
                    // empty catch block
                }
                return false;
            };
            if (obsUnitSet2 == null || !this.locateConditionInOUSHierachy(enumSet, obsUnitSet2, predicate)) continue;
            return;
        }
    }

    private boolean locateConditionInOUSHierachy(@NonNull EnumSet<P2GAttentionReasons> enumSet, ObsUnitSet obsUnitSet, @NonNull Predicate<ObsUnitSet> predicate) {
        if (enumSet == null) {
            throw new NullPointerException("reasons is marked non-null but is null");
        }
        if (predicate == null) {
            throw new NullPointerException("predicate is marked non-null but is null");
        }
        if (obsUnitSet == null) {
            return false;
        }
        if (predicate.test(obsUnitSet)) {
            return true;
        }
        for (ObsUnitSet obsUnitSet2 : obsUnitSet.getObsUnitSet()) {
            if (!this.locateConditionInOUSHierachy(enumSet, obsUnitSet2, predicate)) continue;
            return true;
        }
        return false;
    }

    private void isVLBIUsed(@NonNull EnumSet<P2GAttentionReasons> enumSet) {
        if (enumSet == null) {
            throw new NullPointerException("reasons is marked non-null but is null");
        }
        try {
            if (this.obsProject.getObsProposal().isVLBIorPhasedArray()) {
                enumSet.add(P2GAttentionReasons.VLBI);
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ObsProject.class).warning("Unable to determine if VLBI " + unknownEntityException.getMessage());
        }
    }

    private void isDataRateHigh(@NonNull EnumSet<P2GAttentionReasons> enumSet, @NonNull ObsProgram obsProgram) {
        if (enumSet == null) {
            throw new NullPointerException("reasons is marked non-null but is null");
        }
        if (obsProgram == null) {
            throw new NullPointerException("obsProgram is marked non-null but is null");
        }
        ScienceGoal[] scienceGoalArray = null;
        try {
            if (this.obsProject.getObsProgram() != null) {
                scienceGoalArray = this.obsProject.getObsProgram().getAbstractScienceGoalScienceGoal();
            } else if (this.obsProject.getObsProposal() != null) {
                scienceGoalArray = this.obsProject.getObsProposal().getAbstractScienceGoalScienceGoal();
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            scienceGoalArray = this.obsProject.getObsProgram().getAbstractScienceGoalScienceGoal();
        }
        if (scienceGoalArray == null || scienceGoalArray.length == 0) {
            return;
        }
        DataRate dataRate = DataRate.createDataRate((double)50.0, (String)DataRate.UNIT_MB_S);
        DataRate dataRate2 = DataRate.createDataRate((double)70.0, (String)DataRate.UNIT_MB_S);
        for (ScienceGoal scienceGoal : scienceGoalArray) {
            if (!this.isScienceGoalToBeProcessed(scienceGoal)) continue;
            ObsUnitSet obsUnitSet = null;
            try {
                obsUnitSet = SchedBlockWorker.generateSBs(scienceGoal);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                enumSet.add(P2GAttentionReasons.SBGENERATIONFAILURE);
                continue;
            }
            if (obsUnitSet == null || scienceGoal.isStandAloneACA()) continue;
            Optional<Object> optional = Optional.empty();
            try {
                optional = obsUnitSet.findSchedBlocks().stream().filter(schedBlock -> schedBlock.is12mExtendedArraySB()).findFirst();
            }
            catch (UnknownEntityException unknownEntityException) {
                continue;
            }
            boolean bl = false;
            boolean bl2 = false;
            if (optional.isPresent()) {
                for (Target target2 : ((SchedBlock)optional.get()).getAllTargets(Optional.of(target -> target.hasScienceParameters()))) {
                    SpectralSpec spectralSpec = target2.getSpectralSpec();
                    AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getCorrelatorConfiguration();
                    abstractCorrelatorConfiguration.getDataRateCalculator().updateDataRateForConfig(abstractCorrelatorConfiguration, RequestedArray.TWELVE_M.getControlBlockArray());
                    DataRate dataRate3 = spectralSpec.getInstantaneousDataRate();
                    if (dataRate3.isGreaterThanOrEqualTo((AbstractDoubleWithUnit)dataRate2)) {
                        bl = true;
                        continue;
                    }
                    if (!dataRate3.isGreaterThan((AbstractDoubleWithUnit)dataRate)) continue;
                    bl2 = true;
                }
            }
            if (bl) {
                enumSet.add(P2GAttentionReasons.ILLEGALHIGHDATARATE);
                continue;
            }
            if (!bl2) continue;
            enumSet.add(P2GAttentionReasons.HIGHDATARATEWARNING);
        }
    }

    private boolean isScienceGoalToBeProcessed(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        return !scienceGoal.getIsDescoped();
    }

    private void isTPUsed(@NonNull EnumSet<P2GAttentionReasons> enumSet, @NonNull ObsProgram obsProgram) {
        if (enumSet == null) {
            throw new NullPointerException("reasons is marked non-null but is null");
        }
        if (obsProgram == null) {
            throw new NullPointerException("obsProgram is marked non-null but is null");
        }
        for (ScienceGoal scienceGoal : this.obsProject.getObsProgram().getAbstractScienceGoalScienceGoal()) {
            if (!this.isScienceGoalToBeProcessed(scienceGoal)) continue;
            ObsUnitSet obsUnitSet2 = scienceGoal.getObsUnitSet();
            Predicate<ObsUnitSet> predicate = obsUnitSet -> {
                if (obsUnitSet.getObsUnitControl().getArrayRequested().equals(ArrayRequested.TP_ARRAY.getName())) {
                    enumSet.add(P2GAttentionReasons.TOTALPOWER);
                    return true;
                }
                return false;
            };
            if (obsUnitSet2 == null) continue;
            this.locateConditionInOUSHierachy(enumSet, scienceGoal.getObsUnitSet(), predicate);
        }
    }

    public static enum P2GAttentionReasons {
        RESUBMISSION("Re-submission"),
        VLBI("VLBI"),
        TOTALPOWER("TP"),
        MULTIPLETUNINGS("Multiple tunings"),
        SPECTRALSCAN("Spectral Scan"),
        FULLPOLARISATION("Full-Polarisation"),
        EXTERNALEPHEMERIS("External ephemeris"),
        TIMECONSTRAINED("Time-constrained"),
        HIGHFREQUENCY("High frequency"),
        NARROWAGGREGATEBW("Narrow bandwidth"),
        LONGBASELINE("Long-baseline"),
        SOLAR("Solar"),
        USERDEFINEDCALIBRATIONS("User-defined calibrations"),
        WINDOWOUTSIDEANTIALIASINGFILTER("Baseband-edge spw(s)"),
        BANDEDGEDOPPLER("Band-edge Doppler"),
        BANDFIVE("Band 5"),
        HIGHDATARATEWARNING("Data rate > 50 MB/s"),
        ILLEGALHIGHDATARATE("Data rate too high (no SBs)"),
        SBGENERATIONFAILURE("SB generation has failed"),
        B7INVALIDWITHLONGBASELINE("No Phase Cal."),
        DGCREQUIRED("DGC"),
        DGCREQUIREDOVERRIDDEN("DGC overridden");

        private String reason;

        private P2GAttentionReasons(String string2) {
            this.reason = string2;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

