/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.ObservatoryGoalTargetParametersT;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.site.SiteCharacteristics;
import alma.obsprep.bo.obsproject.GoalTargetParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.data.ObservatoryGoalTargetParametersData;
import alma.valuetypes.Angle;
import alma.valuetypes.Latitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Velocity;
import alma.valuetypes.data.LatitudeData;
import java.util.Optional;
import lombok.NonNull;

public class ObservatoryGoalTargetParameters
extends ObservatoryGoalTargetParametersData
implements GoalTargetParameters {
    public ObservatoryGoalTargetParameters(ObservatoryGoalTargetParametersT observatoryGoalTargetParametersT) {
        super(observatoryGoalTargetParametersT);
    }

    @Override
    public String getIntendedUse() {
        throw new AssertionError((Object)"Not Implemented");
    }

    @Override
    public void setIntendedUse(String string) {
        throw new AssertionError((Object)"Not Implemented");
    }

    @Override
    public String getSolarSystemObject() {
        throw new AssertionError((Object)"Not Implemented");
    }

    @Override
    public void setSolarSystemObject(String string) {
        throw new AssertionError((Object)"Not Implemented");
    }

    @Override
    public boolean getNonSiderealMotion() {
        throw new AssertionError((Object)"Not Implemented");
    }

    @Override
    public void setNonSiderealMotion(boolean bl) {
        throw new AssertionError((Object)"Not Implemented");
    }

    public boolean isMaxElevationNeverVisible() {
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        Angle angle = almaCapabilities.getElLimit();
        double d = angle.getContentInUnits(Angle.UNIT_DEG);
        SiteCharacteristics siteCharacteristics = SiteCharacteristics.getInstance();
        Latitude latitude = siteCharacteristics.getObsLatitude();
        double d2 = 90.0 - d;
        SkyCoordinates skyCoordinates = this.getSourceCoordinates().getICRSSkyCoordinates();
        double d3 = Math.abs(skyCoordinates.getLatitude().getContentInUnits(LatitudeData.UNIT_DEG) - latitude.getContentInUnits(LatitudeData.UNIT_DEG));
        return d3 > d2;
    }

    public Velocity getSourceVelocityInDefaultReferenceFrame(@NonNull Optional<ScienceGoal> optional) {
        if (optional == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        return this.getSourceVelocity().getVelocityInDefaultReferenceFrame(this.getSourceCoordinates(), optional);
    }
}

