/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.ObsProgramT;
import alma.obsprep.bo.annotations.GUIScienceGoalAcceptor;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.data.ObsProgramData;

public class ObsProgram
extends ObsProgramData
implements GUIScienceGoalAcceptor {
    private static final String OPTICAL_POINTING_OUS_NAME = "Optical Pointing";

    public ObsProgram(ObsProgramT obsProgramT) {
        super(obsProgramT);
    }

    public ObsUnitSet obsUnitSetForOpticalPointing() {
        ObsUnitSet obsUnitSet = this.getObsPlan();
        ObsUnitSet obsUnitSet2 = obsUnitSet.findObsUnitSetByName(OPTICAL_POINTING_OUS_NAME);
        if (obsUnitSet2 == null) {
            obsUnitSet2 = ObsUnitSet.createObsUnitSet();
            obsUnitSet2.setName(OPTICAL_POINTING_OUS_NAME);
            obsUnitSet.addObsUnitSet(obsUnitSet2);
        }
        return obsUnitSet2;
    }

    public String toTreeString(int n, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("Science Plan");
        } else {
            stringBuffer.append("Phase-I Setup");
            if (!bl2) {
                stringBuffer.append(' ');
                stringBuffer.append(this.getObsPlan().briefDescription());
            }
        }
        return stringBuffer.toString();
    }

    public ObsProgram placeToAdd() {
        return this;
    }

    @Override
    public void removeScienceGoal(AbstractScienceGoal abstractScienceGoal) {
        this.removeAbstractScienceGoal(abstractScienceGoal);
    }

    public ObsUnitSet findObsUnitSetById(String string) {
        ObsUnitSet obsUnitSet = this.getObsPlan();
        return obsUnitSet.findObsUnitSetById(string);
    }
}

