/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.MonitoringConstraintT;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.data.MonitoringConstraintData;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class MonitoringConstraint
extends MonitoringConstraintData {
    private static final DateTimeFormatter almaDateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public MonitoringConstraint(MonitoringConstraintT monitoringConstraintT) {
        super(monitoringConstraintT);
    }

    protected void initAsNew() {
        super.initAsNew();
    }

    public static ZonedDateTime convertStringToDate(String string) throws DateTimeParseException {
        return LocalDateTime.parse(string, almaDateFormat).atZone(ZoneOffset.UTC);
    }

    public static ZonedDateTime nowInUTC() {
        return ZonedDateTime.now(ZoneOffset.UTC).withNano(0);
    }

    public static String convertDateToString(ZonedDateTime zonedDateTime) throws DateTimeException {
        return zonedDateTime.format(almaDateFormat);
    }

    public ZonedDateTime gettrueStartTimeInDate() {
        String string = this.gettrueStartTime();
        if (null == string || "" == string) {
            return null;
        }
        try {
            return MonitoringConstraint.convertStringToDate(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            String string2 = "Unexpected start time format : " + dateTimeParseException.getMessage();
            Log.logger((Object)((Object)this)).warning(string2);
            return null;
        }
    }

    public void setStartTimeInDate(ZonedDateTime zonedDateTime) {
        String string = MonitoringConstraint.convertDateToString(zonedDateTime);
        this.setStartTime(string);
    }

    public ZonedDateTime getStartTimeAsDate() {
        ZonedDateTime zonedDateTime = this.gettrueStartTimeInDate();
        if (null == zonedDateTime) {
            this.setStartTimeInDate(MonitoringConstraint.nowInUTC());
        }
        return zonedDateTime;
    }
}

