/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsattachment;

import alma.entity.xmlbinding.obsattachment.DocumentLinkT;
import alma.obsprep.bo.obsattachment.data.DocumentLinkData;
import alma.obsprep.util.FileUtilities;
import alma.obsprep.util.MiscUtils;
import alma.valuetypes.StorageVolume;
import java.io.File;
import java.io.IOException;

public class DocumentLink
extends DocumentLinkData {
    public static final String DOCUMENTCLASS_LARGE_PROGRAM_SCIENCE_CASE = "DOCUMENTCLASS_LARGE_PROGRAM_SCIENCE_CASE";

    public DocumentLink(DocumentLinkT documentLinkT) {
        super(documentLinkT);
    }

    public void setFile(File file) throws IOException {
        this.setFile(file, this.guessFileType(file));
    }

    private String guessFileType(File file) {
        return FILETYPE_APPLICATION_PDF;
    }

    public void setFile(File file, String string) throws IOException {
        super.setFileName(file.getName());
        super.setFileType(string);
        StorageVolume storageVolume = StorageVolume.createStorageVolume((double)file.length(), (String)StorageVolume.UNIT_B);
        super.setFileSize(storageVolume);
        if (!FileUtilities.getTmpDir().getAbsolutePath().equals(file.getParent())) {
            File file2 = this.getCacheFile();
            file2.deleteOnExit();
            MiscUtils.copyFile(file, file2, false);
        }
    }

    public File getCacheFile() throws IOException {
        File file = FileUtilities.getTmpDir();
        File file2 = new File(file.getAbsolutePath(), this.getFileName());
        file2.deleteOnExit();
        return file2;
    }

    public File getTemporaryFileToView() throws IOException {
        File file = this.getCacheFile();
        Object object = FileUtilities.getBasename(file);
        if (((String)object).length() <= 3) {
            object = (String)object + "_tmp";
        }
        String string = "." + FileUtilities.getExtension(file);
        File file2 = File.createTempFile((String)object, string);
        MiscUtils.copyFile(file, file2, false);
        file2.deleteOnExit();
        return file2;
    }
}

