/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.enumerations;

import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import java.math.BigDecimal;
import java.util.ArrayList;

public enum Antenna {
    ANTENNA_12M(12.0, "12m"),
    ANTENNA_7M(7.0, "7m");

    public static final double BEAMSIZE_FACTOR = 1.13;
    public static final String BEAMSIZE_TIP_STRING;
    public static final String SYNBEAMSIZE_TIP_STRING;
    private double diameter;
    private String label;
    private static String[] labels;

    public double getApertureArea() {
        return this.diameter * this.diameter * Math.PI / 4.0;
    }

    public static String[] getLabels() {
        if (labels == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Antenna antenna : Antenna.values()) {
                arrayList.add(antenna.label);
            }
            labels = arrayList.toArray(new String[arrayList.size()]);
        }
        return labels;
    }

    public static Antenna getValue(String string) {
        for (Antenna antenna : Antenna.values()) {
            if (!antenna.label.equals(string)) continue;
            return antenna;
        }
        return null;
    }

    public Angle getBeamSize(Frequency frequency) {
        Angle angle = Angle.createAngle();
        double d = 1.13 * frequency.getWavelengthM() / this.getDiameter();
        angle.setContent(d);
        angle.setUnit(Angle.UNIT_RAD);
        angle.convertToUnit(Angle.UNIT_ARCSEC);
        return angle;
    }

    public Angle getBeamArea(Frequency frequency) {
        double d = this.getBeamSize(frequency).getContentInUnits(Angle.UNIT_ARCSEC);
        return Angle.createAngle((double)(d * d * Math.PI / 4.0), (String)Angle.UNIT_ARCSEC);
    }

    public String formatBeamSize(Frequency frequency) {
        return Antenna.formatBeamSize(this.getBeamSize(frequency));
    }

    public static String formatBeamSize(Angle angle) {
        if (angle == null) {
            return "N/A";
        }
        double d = 0.0;
        if (angle.getContent() > 0.0 && angle.getContent() < Double.POSITIVE_INFINITY) {
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(angle.getContentInUnits(Angle.UNIT_ARCSEC)));
            d = bigDecimal.setScale(3, 4).doubleValue();
        }
        return String.format("%4.3f %s", d, Angle.UNIT_ARCSEC);
    }

    private Antenna(double d, String string2) {
        this.diameter = d;
        this.label = string2;
    }

    public double getDiameter() {
        return this.diameter;
    }

    public String getLabel() {
        return this.label;
    }

    static {
        BEAMSIZE_TIP_STRING = String.format("%.2f * &lambda; / D", 1.13);
        SYNBEAMSIZE_TIP_STRING = String.format("%.2f * &lambda; / L", 1.13);
    }
}

