/*
 * Decompiled with CFR 0.152.
 */
package alma.observatorycharacteristics.site;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.configuration.OTConfiguration;
import alma.observatorycharacteristics.configuration.OTXMLConfigurationReader;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;

public class SiteCharacteristics {
    static String property;
    private final String observatoryName;
    private final Latitude observatoryLatitude;
    private final Longitude observatoryLongitude;
    private static SiteCharacteristics siteCharacteristicsSingleton;
    private static List<ChangeListener> listeners;

    private SiteCharacteristics() throws InvalidObsProgramParametersException {
        OTConfiguration.SiteCharacteristics siteCharacteristics;
        String string = System.getProperty("Telescope", "Cycle8");
        try {
            siteCharacteristics = OTXMLConfigurationReader.getInstance().getOTConfiguration().getSiteCharacteristics();
        }
        catch (OTXMLConfigurationReader.InvalidOTCOnfigurationException | JAXBException throwable) {
            if (throwable instanceof UnmarshalException) {
                UnmarshalException unmarshalException = (UnmarshalException)throwable;
                Log.logger(AlmaPolicies.class).warning("Unable to unmarshall XML file " + unmarshalException.getLinkedException());
            }
            throw new RuntimeException("Unable to parse the " + string + "OTConfiguration.xml file " + throwable.getMessage());
        }
        assert (siteCharacteristics != null);
        this.observatoryName = siteCharacteristics.getObservatoryName();
        this.observatoryLongitude = Longitude.createLongitude();
        this.observatoryLongitude.setContent(siteCharacteristics.getObservatoryLongitude());
        this.observatoryLongitude.setUnitToDefault();
        this.observatoryLatitude = Latitude.createLatitude();
        this.observatoryLatitude.setContent(siteCharacteristics.getObservatoryLatitude());
        this.observatoryLatitude.setUnitToDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SiteCharacteristics getInstance() {
        if (siteCharacteristicsSingleton == null) {
            try {
                Class<SiteCharacteristics> clazz = SiteCharacteristics.class;
                synchronized (SiteCharacteristics.class) {
                    if (siteCharacteristicsSingleton == null) {
                        siteCharacteristicsSingleton = new SiteCharacteristics();
                    }
                    // ** MonitorExit[var0] (shouldn't be in output)
                }
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                Log.logger(SiteCharacteristics.class).log(Level.WARNING, "", (Throwable)invalidObsProgramParametersException);
            }
        }
        {
            return siteCharacteristicsSingleton;
        }
    }

    public static void refreshCharacteristics() {
        siteCharacteristicsSingleton = null;
        ChangeEvent changeEvent = new ChangeEvent(SiteCharacteristics.class);
        listeners.forEach(changeListener -> changeListener.stateChanged(changeEvent));
    }

    public Latitude getObsLatitude() {
        return this.observatoryLatitude;
    }

    public Longitude getObsLongitude() {
        return this.observatoryLongitude;
    }

    public String getObsName() {
        return this.observatoryName;
    }

    public static void addChangeListener(ChangeListener changeListener) {
        listeners.add(changeListener);
    }

    static {
        siteCharacteristicsSingleton = null;
        listeners = new ArrayList<ChangeListener>();
    }
}

