/*
 * Decompiled with CFR 0.152.
 */
package jsky.navigator;

import java.awt.Component;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import jsky.catalog.FieldDesc;
import jsky.catalog.QueryResult;
import jsky.catalog.TableQueryResult;
import jsky.catalog.gui.CatalogQueryTool;
import jsky.catalog.gui.TableDisplayTool;
import jsky.catalog.skycat.SkycatCatalog;
import jsky.catalog.skycat.SkycatConfigEntry;
import jsky.catalog.skycat.SkycatTable;
import jsky.image.gui.PickObjectStatistics;
import jsky.navigator.Navigator;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.SwingUtil;

public class NavigatorPickObjectSupport {
    private Navigator _navigator;

    public NavigatorPickObjectSupport(Navigator navigator) {
        this._navigator = navigator;
    }

    public void addToTable(PickObjectStatistics stats, boolean isUpdate) {
        TableQueryResult table = null;
        TableDisplayTool tableDisplayTool = null;
        JComponent resultComponent = this._navigator.getResultComponent();
        if (resultComponent instanceof TableDisplayTool) {
            tableDisplayTool = (TableDisplayTool)resultComponent;
            table = tableDisplayTool.getTableDisplay().getTableQueryResult();
        }
        if (table == null) {
            JFrame parent;
            table = this._makeTable(stats);
            SkycatCatalog cat = new SkycatCatalog((SkycatTable)table);
            this._navigator.setQueryResult((QueryResult)cat);
            JComponent queryComponent = this._navigator.getQueryComponent();
            if (queryComponent instanceof CatalogQueryTool) {
                ((CatalogQueryTool)queryComponent).search();
            }
            if ((parent = SwingUtil.getFrame((Component)this._navigator)) != null) {
                parent.setVisible(true);
            }
        } else {
            this._addRow(table, tableDisplayTool, stats, isUpdate);
        }
    }

    private TableQueryResult _makeTable(PickObjectStatistics stats) {
        Properties properties = new Properties();
        properties.setProperty("serv_type", "local");
        properties.setProperty("long_name", "Picked Objects");
        properties.setProperty("short_name", "PickedObjects");
        properties.setProperty("symbol", "{{FWHM_X} {FWHM_Y} {Angle}} {{plus} {green} {$FWHM_X/$FWHM_Y} {$Angle} {} {1}} {{($FWHM_X+$FWHM_Y)*0.5} {image}}");
        properties.setProperty("url", "none");
        SkycatConfigEntry configEntry = new SkycatConfigEntry(properties);
        FieldDesc[] fields = PickObjectStatistics.getFields();
        Vector<Vector> dataRows = new Vector<Vector>();
        dataRows.add(stats.getRow());
        SkycatTable table = new SkycatTable(configEntry, dataRows, fields);
        table.setProperties(properties);
        return table;
    }

    private void _addRow(TableQueryResult table, TableDisplayTool tableDisplayTool, PickObjectStatistics stats, boolean isUpdate) {
        if (!table.hasCoordinates()) {
            DialogUtil.error((String)"The current table does not support coordinates");
            return;
        }
        int numCols = table.getColumnCount();
        Vector v = stats.getRow();
        Vector rowVec = new Vector(numCols);
        int col = 0;
        while (col < numCols) {
            FieldDesc field = table.getColumnDesc(col);
            String name = field.getName();
            if (field.isId()) {
                rowVec.add(v.get(0));
            } else if (field.isRaMain()) {
                rowVec.add(stats.getCenterPos().getRA().toString());
            } else if (field.isDecMain()) {
                rowVec.add(stats.getCenterPos().getDec().toString());
            } else {
                Object o = null;
                int i = 0;
                while (i < PickObjectStatistics.NUM_FIELDS) {
                    if (name.equals(PickObjectStatistics.FIELD_NAMES[i])) {
                        o = v.get(i);
                        break;
                    }
                    ++i;
                }
                rowVec.add(o);
            }
            ++col;
        }
        if (isUpdate) {
            int rowIndex = tableDisplayTool.getRowCount() - 1;
            if (rowIndex >= 0) {
                tableDisplayTool.updateRow(rowIndex, rowVec);
            } else {
                tableDisplayTool.addRow(rowVec);
            }
        } else {
            tableDisplayTool.addRow(rowVec);
        }
        tableDisplayTool.replot();
    }
}

