/*
 * Decompiled with CFR 0.152.
 */
package jsky.interop;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jsky.catalog.FieldDesc;
import jsky.catalog.QueryResult;
import jsky.catalog.TableQueryResult;
import jsky.catalog.URLQueryResult;
import jsky.catalog.gui.QueryResultDisplay;
import jsky.interop.PlasticHelper;
import jsky.interop.SampHelper;
import jsky.util.Resources;
import jsky.util.gui.ClipboardHelper;
import jsky.util.gui.DialogUtil;

public class UrlTableCellRenderer
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor,
ActionListener {
    private static final Icon IMAGE_ICON = Resources.getIcon((String)"ImageDisplay18.gif");
    private static final Icon TABLE_ICON = Resources.getIcon((String)"Catalog18.gif");
    private static final Icon BROWSER_ICON = Resources.getIcon((String)"firefox18.gif");
    private static final Icon SEND_ICON = Resources.getIcon((String)"phone2_menu.gif");
    private static final Icon COPY_ICON = Resources.getIcon((String)"Copy16.gif");
    private static final String IMAGE_TOOLTIP = "Display the image at this URL";
    private static final String TABLE_TOOLTIP = "Display the table at this URL";
    private static final String BROWSER_TOOLTIP = "Display the URL link in the default web browser";
    private static final Color SEL_BG = (Color)UIManager.get("Table.selectionBackground");
    private JPanel _panel;
    private FieldDesc _fieldDesc;
    private TableQueryResult _tableQueryResult;
    private QueryResultDisplay _queryResultDisplay;
    private Object _value;
    private int _row;
    private JButton _defaultButton;
    private JButton _sendButton;
    private boolean _sendEnabled;
    private String _format;
    private URL _url;
    private Map _ucdMap;
    private AbstractAction _copyUrlAction = new AbstractAction("Copy URL", COPY_ICON){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (UrlTableCellRenderer.this._url != null) {
                ClipboardHelper.setClipboard((Object)UrlTableCellRenderer.this._url.toString());
            }
        }
    };

    public UrlTableCellRenderer(FieldDesc fieldDesc, TableQueryResult tableQueryResult, QueryResultDisplay queryResultDisplay) {
        this._panel = new JPanel();
        this._fieldDesc = fieldDesc;
        this._tableQueryResult = tableQueryResult;
        this._queryResultDisplay = queryResultDisplay;
        this._sendEnabled = SampHelper.getInstance() != null || PlasticHelper.getInstance() != null;
        this._makeLayout();
    }

    private void _makeLayout() {
        boolean isMacOsX = "Mac OS X".equals(UIManager.getLookAndFeel().getName());
        this._panel.setLayout(new FlowLayout(0, 11, isMacOsX ? -5 : 0));
        this._panel.setBackground(Color.white);
        this._defaultButton = new JButton();
        this._defaultButton.setBorder(null);
        this._defaultButton.setBorderPainted(false);
        this._defaultButton.setIcon(IMAGE_ICON);
        this._defaultButton.addActionListener(this);
        this._defaultButton.setBackground(Color.white);
        this._defaultButton.setRolloverEnabled(true);
        this._panel.add(this._defaultButton);
        this._sendButton = new JButton();
        if (this._sendEnabled) {
            this._sendButton.setBorder(null);
            this._sendButton.setBorderPainted(false);
            this._sendButton.setIcon(SEND_ICON);
            this._sendButton.setBackground(Color.white);
            this._sendButton.setRolloverEnabled(true);
            this._sendButton.setToolTipText("Send the URL to the selected SAMP/PLASTIC client");
            this._sendButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Component c = e.getComponent();
                    JPopupMenu menu = UrlTableCellRenderer.this._getSendPopupMenu();
                    if (menu != null) {
                        menu.show(c, 0, c.getHeight());
                    }
                }
            });
            this._panel.add(this._sendButton);
        }
    }

    private JPopupMenu _getSendPopupMenu() {
        if (this._format == null) {
            return null;
        }
        JPopupMenu menu = new JPopupMenu();
        SampHelper sh = SampHelper.getInstance();
        PlasticHelper ph = PlasticHelper.getInstance();
        if (this._format.startsWith("image/") || this._format.equalsIgnoreCase("application/fits")) {
            if (sh != null && ph != null) {
                JMenu sampMenu = new JMenu("SAMP");
                menu.add(sampMenu);
                sh.initImageMenu(sampMenu);
                JMenu plasticMenu = new JMenu("PLASTIC");
                menu.add(plasticMenu);
                ph.initImageMenu(plasticMenu);
            } else {
                if (sh != null) {
                    sh.initImageMenu(menu, this._url);
                }
                if (ph != null) {
                    ph.initImageMenu(menu, this._url);
                }
            }
        } else if (this._format.startsWith("spectrum/") || this._format.equalsIgnoreCase("text/xml;x-votable")) {
            if (sh != null && ph != null) {
                JMenu sampMenu = new JMenu("SAMP");
                menu.add(sampMenu);
                sh.initTableMenu(sampMenu, this._url, this._format, this._ucdMap);
                JMenu plasticMenu = new JMenu("PLASTIC");
                menu.add(plasticMenu);
                ph.initTableMenu(plasticMenu, this._url, this._format, this._ucdMap);
            } else {
                if (sh != null) {
                    sh.initTableMenu(menu, this._url, this._format, this._ucdMap);
                }
                if (ph != null) {
                    ph.initTableMenu(menu, this._url, this._format, this._ucdMap);
                }
            }
        }
        menu.add(this._copyUrlAction);
        return menu;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        try {
            URLQueryResult queryResult = this._fieldDesc.getLinkValue(this._tableQueryResult, this._value, this._row);
            this._queryResultDisplay.setQueryResult((QueryResult)queryResult);
        }
        catch (Exception e) {
            DialogUtil.error((Exception)e);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this._updateBgColor(isSelected);
        try {
            if (value instanceof String) {
                String urlStr = (String)value;
                this._updateDisplay(urlStr, row);
                return this._panel;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return table.getDefaultRenderer(Object.class).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this._row = row;
        this._value = value;
        this._updateBgColor(isSelected);
        try {
            if (value instanceof String) {
                String urlStr = (String)value;
                this._updateDisplay(urlStr, row);
                return this._panel;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return table.getDefaultEditor(Object.class).getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    private void setUrlToolTip() {
        if (this._url != null) {
            this._panel.setToolTipText("<html>Display the object, send or broadcast it to another application<br>URL: " + this._url.toString());
        }
    }

    private void _updateBgColor(boolean isSelected) {
        Color color = isSelected ? SEL_BG : Color.white;
        this._panel.setBackground(color);
        this._sendButton.setBackground(color);
        this._defaultButton.setBackground(color);
    }

    private Map _getUcdMap(int row) {
        HashMap<String, String> ucdMap = new HashMap<String, String>();
        int columnCount = this._tableQueryResult.getColumnCount();
        int col = 0;
        while (col < columnCount) {
            Object value;
            String ucd = this._tableQueryResult.getColumnDesc(col).getUCD();
            if (ucd != null && (value = this._tableQueryResult.getValueAt(row, col)) != null) {
                ucdMap.put(ucd, value.toString());
            }
            ++col;
        }
        return ucdMap;
    }

    private void _updateDisplay(String urlStr, int row) throws MalformedURLException {
        this._format = this._fieldDesc.getLinkFormat(this._tableQueryResult, row);
        this._ucdMap = this._getUcdMap(row);
        if (urlStr.startsWith("M=")) {
            urlStr = urlStr.substring(2);
            this._format = "text/html";
        }
        if (urlStr.startsWith("P=")) {
            urlStr = urlStr.substring(2);
            this._format = "image/fits";
        }
        this._url = new URL(urlStr);
        this.setUrlToolTip();
        this._defaultButton.setVisible(false);
        this._sendButton.setVisible(false);
        if (this._format != null) {
            if (this._format.startsWith("spectrum/") || this._format.equalsIgnoreCase("text/xml;x-votable") || this._format.equalsIgnoreCase("text/csv")) {
                this._defaultButton.setVisible(true);
                this._defaultButton.setIcon(TABLE_ICON);
                this._defaultButton.setToolTipText(TABLE_TOOLTIP);
                this._sendButton.setVisible(true);
            } else if (this._format.startsWith("image/") || this._format.equalsIgnoreCase("application/fits")) {
                this._defaultButton.setVisible(true);
                this._defaultButton.setIcon(IMAGE_ICON);
                this._defaultButton.setToolTipText(IMAGE_TOOLTIP);
                this._sendButton.setVisible(true);
            } else {
                this._defaultButton.setVisible(true);
                this._defaultButton.setIcon(BROWSER_ICON);
                this._defaultButton.setToolTipText(BROWSER_TOOLTIP);
                this._sendButton.setVisible(false);
            }
        } else {
            throw new RuntimeException();
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this._value;
    }
}

