/*
 * Decompiled with CFR 0.152.
 */
package jsky.interop;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.ListModel;
import jsky.image.gui.MainImageDisplay;
import jsky.util.Resources;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.gui.GuiHubConnector;
import org.astrogrid.samp.gui.IndividualCallActionManager;
import org.astrogrid.samp.gui.SubscribedClientListModel;

public class ImageSendActionManager
extends IndividualCallActionManager {
    private static final Sender[] SENDERS = new Sender[]{new Sender("image.load.fits")};
    private MainImageDisplay _imageDisplay;
    private URL _url;
    private int idCount_;

    public ImageSendActionManager(MainImageDisplay parent, GuiHubConnector connector) {
        this(parent, connector, null);
    }

    public ImageSendActionManager(MainImageDisplay parent, GuiHubConnector connector, URL url) {
        super((Component)parent, connector, (ListModel)new SubscribedClientListModel(connector, ImageSendActionManager.getSendMtypes()));
        this._imageDisplay = parent;
        this._url = url;
    }

    protected Map createMessage(Client client) throws Exception {
        Sender sender = ImageSendActionManager.getSender(client);
        if (sender != null) {
            URL url = this._url;
            if (url == null) {
                String fileName = this._imageDisplay.getFilename();
                url = this._imageDisplay.getURL();
                if (fileName != null) {
                    url = new File(fileName).toURI().toURL();
                }
            }
            String label = this.createId();
            return sender.createMessage(url, label);
        }
        return null;
    }

    private synchronized String createId() {
        return "jsky" + Integer.toString(System.identityHashCode((Object)this) & 0xFFFF, 16) + "-" + ++this.idCount_;
    }

    private static Sender getSender(Client client) {
        Subscriptions subs = client.getSubscriptions();
        Sender[] senderArray = SENDERS;
        int n = SENDERS.length;
        int n2 = 0;
        while (n2 < n) {
            Sender sender = senderArray[n2];
            if (subs.isSubscribed(sender.getMtype())) {
                return sender;
            }
            ++n2;
        }
        return null;
    }

    public JMenu createSendMenu() {
        JMenu menu = super.createSendMenu("Send Image to...");
        menu.setToolTipText("Send image to a single other registered client using SAMP");
        menu.setIcon(Resources.getIcon((String)"phone2.gif"));
        return menu;
    }

    private static String[] getSendMtypes() {
        String[] mtypes = new String[SENDERS.length];
        int i = 0;
        while (i < SENDERS.length) {
            mtypes[i] = SENDERS[i].getMtype();
            ++i;
        }
        return mtypes;
    }

    private static class Sender {
        private final String mtype_;

        Sender(String mtype) {
            this.mtype_ = mtype;
        }

        public String getMtype() {
            return this.mtype_;
        }

        public Message createMessage(URL url, String sampId) {
            return new Message(this.getMtype()).addParam("url", (Object)url.toString()).addParam("image-id", (Object)sampId);
        }

        public String toString() {
            return this.mtype_;
        }
    }
}

