/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import jsky.catalog.gui.CatalogNavigator;
import jsky.catalog.gui.CatalogNavigatorMenuBar;
import jsky.util.Storeable;
import jsky.util.gui.DialogUtil;

public class CatalogQueryItem
implements Action,
Serializable {
    private String _name;
    private Object _queryInfo;
    private Object _resultInfo;
    private transient AbstractAction _action;

    public CatalogQueryItem(String name, Object queryInfo, Object resultInfo) {
        this._name = name;
        this._queryInfo = queryInfo;
        this._resultInfo = resultInfo;
        this._initAction();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._initAction();
    }

    private void _initAction() {
        this._action = new AbstractAction(this._name){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CatalogNavigator navigator = CatalogNavigatorMenuBar.getCurrentCatalogNavigator();
                    JComponent queryComponent = navigator.getQueryComponent();
                    if (queryComponent instanceof Storeable && CatalogQueryItem.this._queryInfo != null && !((Storeable)queryComponent).restoreSettings(CatalogQueryItem.this._queryInfo)) {
                        return;
                    }
                    JComponent resultComponent = navigator.getResultComponent();
                    if (resultComponent instanceof Storeable && CatalogQueryItem.this._resultInfo != null) {
                        ((Storeable)resultComponent).restoreSettings(CatalogQueryItem.this._resultInfo);
                    }
                }
                catch (Exception e) {
                    DialogUtil.error((Exception)e);
                }
            }
        };
    }

    public String getName() {
        return this._name;
    }

    @Override
    public Object getValue(String key) {
        return this._action.getValue(key);
    }

    @Override
    public void putValue(String key, Object value) {
        this._action.putValue(key, value);
    }

    @Override
    public void setEnabled(boolean b) {
        this._action.setEnabled(b);
    }

    @Override
    public boolean isEnabled() {
        return this._action.isEnabled();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._action.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._action.removePropertyChangeListener(listener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this._action.actionPerformed(e);
    }
}

