/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.HTMLQueryResultHandler;
import jsky.catalog.QueryResult;
import jsky.catalog.TableQueryResult;
import jsky.catalog.URLQueryResult;
import jsky.catalog.astrocat.AstroCatConfig;
import jsky.catalog.gui.CatalogHistoryItem;
import jsky.catalog.gui.CatalogHistoryList;
import jsky.catalog.gui.CatalogNavigatorMenuBar;
import jsky.catalog.gui.CatalogQueryItem;
import jsky.catalog.gui.CatalogQueryList;
import jsky.catalog.gui.CatalogQueryTool;
import jsky.catalog.gui.CatalogTree;
import jsky.catalog.gui.CatalogUIHandler;
import jsky.catalog.gui.QueryResultDisplay;
import jsky.catalog.gui.TableDisplay;
import jsky.catalog.gui.TableDisplayTool;
import jsky.catalog.gui.TablePlotter;
import jsky.util.FileUtil;
import jsky.util.I18N;
import jsky.util.PrintableWithDialog;
import jsky.util.Resources;
import jsky.util.Saveable;
import jsky.util.SaveableAsHTML;
import jsky.util.SaveableWithDialog;
import jsky.util.Storeable;
import jsky.util.SwingWorker;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.GenericToolBarTarget;
import jsky.util.gui.ProgressException;
import jsky.util.gui.ProgressPanel;
import jsky.util.gui.SwingUtil;
import uk.ac.starlink.table.StarTable;

public abstract class CatalogNavigator
extends JPanel
implements QueryResultDisplay,
GenericToolBarTarget,
HTMLQueryResultHandler {
    private static final I18N _I18N = I18N.getInstance(CatalogNavigator.class);
    private boolean _autoQuery = false;
    private JPanel _queryPanel;
    private JPanel _resultPanel;
    private CatalogTree _catalogTree;
    private JComponent _queryComponent;
    private JComponent _resultComponent;
    private URL _origURL;
    private static JFileChooser _fileChooser;
    private static JFileChooser _saveFileChooser;
    private ProgressPanel _progressPanel;
    private EventListenerList _listenerList = new EventListenerList();
    private Stack<CatalogHistoryItem> _backStack = new Stack();
    private Stack<CatalogHistoryItem> _forwStack = new Stack();
    private boolean _noStack = false;
    private QueryResult _queryResult;
    private TablePlotter _plotter;
    private SwingWorker _worker;
    private Hashtable<JComponent, Catalog> _panelTreeNodeTable = new Hashtable(10);
    private CatalogHistoryList _historyList;
    private CatalogQueryList _queryList;
    private Hashtable<JComponent, JComponent> _queryResultComponentMap = new Hashtable();
    private Hashtable<String, JComponent> _queryComponentMap = new Hashtable();
    private JSplitPane _querySplitPane;
    private JSplitPane _resultSplitPane;
    private AbstractAction _openAction = new AbstractAction(_I18N.getString("open"), Resources.getIcon((String)"Open24.gif")){
        {
            this.putValue("ShortDescription", _I18N.getString("catalogOpenTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.open();
        }
    };
    private AbstractAction _openUrlAction = new AbstractAction(_I18N.getString("openURL")){
        {
            this.putValue("ShortDescription", _I18N.getString("openURLTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.openURL();
        }
    };
    private AbstractAction _clearAction = new AbstractAction(_I18N.getString("clear")){
        {
            this.putValue("ShortDescription", _I18N.getString("clearTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.clear();
        }
    };
    private AbstractAction _openActionOverride;
    private AbstractAction _saveAsAction = new AbstractAction(_I18N.getString("saveAs"), Resources.getIcon((String)"SaveAs24.gif")){
        {
            this.putValue("ShortDescription", _I18N.getString("saveAsTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.saveAs();
        }
    };
    private AbstractAction _saveWithImageAction = new AbstractAction(_I18N.getString("saveCatalogWithImage")){
        {
            this.putValue("ShortDescription", _I18N.getString("saveCatalogWithImageTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.saveWithImage();
        }
    };
    private AbstractAction _saveAsHTMLAction = new AbstractAction(_I18N.getString("saveAsHTML")){
        {
            this.putValue("ShortDescription", _I18N.getString("saveAsHTMLTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.saveAsHTML();
        }
    };
    private AbstractAction _printAction = new AbstractAction(String.valueOf(_I18N.getString("print")) + "...", Resources.getIcon((String)"Print24.gif")){
        {
            this.putValue("ShortDescription", _I18N.getString("printTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.print();
        }
    };
    private AbstractAction _backAction = new AbstractAction(_I18N.getString("back"), Resources.getIcon((String)"Back24.gif")){
        {
            this.putValue("ShortDescription", _I18N.getString("catalogBackTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.back();
        }
    };
    private AbstractAction _forwAction = new AbstractAction(_I18N.getString("forward"), Resources.getIcon((String)"Forward24.gif")){
        {
            this.putValue("ShortDescription", _I18N.getString("catalogForwardTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.forward();
        }
    };
    private AbstractAction _addRowAction = new AbstractAction(_I18N.getString("addRow")){
        {
            this.putValue("ShortDescription", _I18N.getString("addRowTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.addRow();
        }
    };
    private AbstractAction _deleteSelectedRowsAction = new AbstractAction(_I18N.getString("deleteSelectedRows")){
        {
            this.putValue("ShortDescription", _I18N.getString("deleteSelectedRowsTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.deleteSelectedRows();
        }
    };
    private AbstractAction _storeNewQueryAction = new AbstractAction(_I18N.getString("new")){
        {
            this.putValue("ShortDescription", _I18N.getString("newQueryTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.storeNewQuery();
        }
    };
    private AbstractAction _deleteAllQueryAction = new AbstractAction(_I18N.getString("all")){
        {
            this.putValue("ShortDescription", _I18N.getString("deleteAllQueryTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.clearQueryList();
        }
    };
    private AbstractAction _closeAction = new AbstractAction(_I18N.getString("close")){
        {
            this.putValue("ShortDescription", _I18N.getString("closeTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.close();
        }
    };
    private AbstractAction _exitAction = new AbstractAction(_I18N.getString("exit")){
        {
            this.putValue("ShortDescription", _I18N.getString("exitTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.exit();
        }
    };

    public static CatalogDirectory getCatalogDirectory(boolean load) {
        return AstroCatConfig.getConfigFile((boolean)load);
    }

    public static CatalogDirectory getCatalogDirectory() {
        return AstroCatConfig.getConfigFile();
    }

    public CatalogNavigator(CatalogTree catalogTree) {
        this.setLayout(new BorderLayout());
        this._catalogTree = catalogTree;
        catalogTree.setQueryResultDisplay(this);
        catalogTree.setHTMLQueryResultHandler(this);
        catalogTree.setPreferredSize(new Dimension(300, 0));
        catalogTree.getTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                CatalogNavigator.this._autoQuery = false;
            }
        });
        this._queryPanel = new JPanel();
        this._queryPanel.setLayout(new BorderLayout());
        this._resultPanel = new JPanel();
        this._resultPanel.setLayout(new BorderLayout());
        this._querySplitPane = new JSplitPane(1, catalogTree, this._queryPanel);
        this._querySplitPane.setOneTouchExpandable(false);
        this._querySplitPane.setDividerLocation(385);
        this._querySplitPane.setBorder(null);
        this._resultSplitPane = new JSplitPane(0, this._querySplitPane, this._resultPanel);
        this._resultSplitPane.setOneTouchExpandable(false);
        this._resultSplitPane.setDividerLocation(320);
        this._resultSplitPane.setBorder(null);
        this.add((Component)this._resultSplitPane, "Center");
        this._queryList = new CatalogQueryList();
        this._historyList = new CatalogHistoryList();
        this.setQueryComponent(new EmptyPanel());
        this.setResultComponent(new EmptyPanel());
    }

    public CatalogNavigator(CatalogTree catalogTree, TablePlotter plotter) {
        this(catalogTree);
        this._plotter = plotter;
    }

    public CatalogTree getCatalogTree() {
        return this._catalogTree;
    }

    protected JSplitPane getQuerySplitPane() {
        return this._querySplitPane;
    }

    public JSplitPane getResultSplitPane() {
        return this._resultSplitPane;
    }

    public void setAutoQuery(boolean b) {
        this._autoQuery = b;
    }

    public TablePlotter getPlotter() {
        return this._plotter;
    }

    public void setPlotter(TablePlotter tp) {
        this._plotter = tp;
    }

    public void setComponent(JComponent component) {
        if (component instanceof QueryResultDisplay) {
            this.setResultComponent(component);
        } else {
            this.setQueryComponent(component);
            if (component instanceof CatalogQueryTool && (this._autoQuery || ((CatalogQueryTool)component).getCatalog().isLocal())) {
                ((CatalogQueryTool)component).search();
            }
        }
    }

    public void setQueryComponent(JComponent component) {
        if (component == null || component == this._queryComponent) {
            return;
        }
        if (this._queryComponent != null) {
            this.addToHistory();
            this._queryPanel.remove(this._queryComponent);
            this._queryComponent = null;
        }
        this._queryComponent = component;
        Catalog cat = this._catalogTree.getSelectedCatalog();
        if (cat != null) {
            this._panelTreeNodeTable.put(this._queryComponent, cat);
        }
        this._queryPanel.add((Component)this._queryComponent, "Center");
        JComponent resultComp = this._queryResultComponentMap.get(this._queryComponent);
        if (resultComp == null) {
            this.setResultComponent(new EmptyPanel());
        } else {
            this.setResultComponent(resultComp);
        }
        this.update();
    }

    public JComponent getQueryComponent() {
        return this._queryComponent;
    }

    public void setResultComponent(JComponent component) {
        if (component == null || component == this._resultComponent) {
            return;
        }
        if (this._resultComponent != null) {
            this._resultPanel.remove(this._resultComponent);
            this._resultComponent = null;
        }
        this._resultComponent = component;
        if (this._queryComponent != null) {
            this._queryResultComponentMap.put(this._queryComponent, this._resultComponent);
        }
        this._resultPanel.add((Component)this._resultComponent, "Center");
        this.update();
        this._resultComponentChanged();
    }

    public JComponent getResultComponent() {
        return this._resultComponent;
    }

    protected void _resultComponentChanged() {
        this._saveAsAction.setEnabled(this._resultComponent instanceof Saveable);
        this._printAction.setEnabled(this._resultComponent instanceof PrintableWithDialog);
        boolean isTable = this._resultComponent instanceof TableDisplayTool;
        this._saveWithImageAction.setEnabled(isTable);
        this._deleteSelectedRowsAction.setEnabled(isTable);
        this._addRowAction.setEnabled(isTable);
        this.fireChange(new ChangeEvent(this));
    }

    public void addChangeListener(ChangeListener l) {
        this._listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this._listenerList.remove(ChangeListener.class, l);
    }

    protected void fireChange(ChangeEvent e) {
        Object[] listeners = this._listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ChangeListener.class) {
                ((ChangeListener)listeners[i + 1]).stateChanged(e);
            }
            i -= 2;
        }
    }

    protected void addToHistory() {
        if (this._queryComponent == null) {
            return;
        }
        CatalogHistoryItem historyItem = this.makeCatalogHistoryItem();
        if (historyItem == null) {
            return;
        }
        if (!this._noStack) {
            this._backStack.push(historyItem);
            this._backAction.setEnabled(true);
            if (this._forwStack.size() != 0) {
                this._cleanupHistoryStack(this._forwStack);
                this._forwStack.clear();
                this._forwAction.setEnabled(false);
            }
        }
        this._historyList.add(historyItem);
    }

    protected CatalogHistoryItem makeCatalogHistoryItem() {
        String s = this._queryComponent.getName();
        if (s != null) {
            return new CatalogHistoryItem(s, this._origURL, this._queryComponent);
        }
        return null;
    }

    public void addHistoryMenuItems(JMenu menu) {
        Iterator<CatalogHistoryItem> it = this._historyList.iterator();
        while (it.hasNext()) {
            menu.add(it.next());
        }
    }

    private void _cleanupHistoryStack(Stack stack) {
        this.unplot(stack);
    }

    protected void clearHistory() {
        this._backAction.setEnabled(false);
        this._backStack.clear();
        this._forwAction.setEnabled(false);
        this._forwStack.clear();
        this._historyList.clear();
    }

    public void setOrigURL(URL url) {
        this._origURL = url;
    }

    public URL getOrigURL() {
        return this._origURL;
    }

    protected void unplot(Stack stack) {
        int n = stack.size();
        int i = 0;
        while (i < n) {
            CatalogHistoryItem item = (CatalogHistoryItem)stack.get(i);
            JComponent resultComp = this._queryResultComponentMap.get(item.getQueryComponent());
            if (resultComp instanceof TableDisplayTool) {
                ((TableDisplayTool)resultComp).unplot();
            }
            ++i;
        }
    }

    public void unplot() {
        Enumeration<JComponent> e = this._queryResultComponentMap.elements();
        while (e.hasMoreElements()) {
            JComponent comp = e.nextElement();
            if (!(comp instanceof TableDisplayTool)) continue;
            ((TableDisplayTool)comp).unplot();
        }
    }

    protected void update() {
        this._queryPanel.revalidate();
        this._resultPanel.revalidate();
        JFrame parent = SwingUtil.getFrame((Component)this);
        if (parent != null) {
            parent.repaint();
        }
    }

    protected void updateTreeSelection() {
        if (this._queryComponent instanceof CatalogQueryTool) {
            this._catalogTree.setSelectedCatalog(((CatalogQueryTool)this._queryComponent).getCatalog(), true);
            this._updateTitle(((CatalogQueryTool)this._queryComponent).getCatalog());
        } else if (this._queryComponent instanceof TableDisplayTool) {
            this._catalogTree.setSelectedCatalog((Catalog)((TableDisplayTool)this._queryComponent).getTable(), true);
        }
    }

    public QueryResult getQueryResult() {
        return this._queryResult;
    }

    public void setQueryResult(QueryResult queryResult) {
        if (queryResult == null) {
            return;
        }
        if (this._worker != null) {
            DialogUtil.error((String)_I18N.getString("queryInProgress"));
            return;
        }
        this._queryResult = queryResult;
        boolean isLocal = true;
        if (queryResult instanceof URLQueryResult) {
            URLQueryResult uqr = (URLQueryResult)queryResult;
            URL url = uqr.getURL();
            isLocal = url.getProtocol().equals("file");
        } else if (queryResult instanceof Catalog) {
            isLocal = ((Catalog)queryResult).isLocal();
        }
        if (isLocal) {
            this.setComponent(this.makeQueryResultComponent(queryResult));
        } else {
            this.makeProgressPanel();
            this._worker = new SwingWorker(){

                public Object construct() {
                    try {
                        return CatalogNavigator.this.makeQueryResultComponent(CatalogNavigator.this._queryResult);
                    }
                    catch (Exception e) {
                        return e;
                    }
                }

                public void finished() {
                    CatalogNavigator.this._worker = null;
                    CatalogNavigator.this._progressPanel.stop();
                    Object o = this.getValue();
                    if (o instanceof Exception) {
                        DialogUtil.error((Exception)((Exception)o));
                    } else if (o instanceof JComponent) {
                        CatalogNavigator.this.setComponent((JComponent)o);
                    }
                }
            };
            this._worker.start();
        }
    }

    private void _updateTitle(Catalog catalog) {
        JFrame parent;
        String title = _I18N.getString("catalogNavigator");
        String s = catalog.getTitle();
        if (s != null && s.length() > 0) {
            title = String.valueOf(title) + " - " + s;
        }
        if ((parent = SwingUtil.getFrame((Component)this)) != null) {
            parent.setTitle(title);
        }
    }

    protected void makeProgressPanel() {
        if (this._progressPanel == null) {
            JFrame parent = SwingUtil.getFrame((Component)this);
            this._progressPanel = ProgressPanel.makeProgressPanel((String)_I18N.getString("accessingCatalogServer"), (Component)parent);
            this._progressPanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CatalogNavigator.this._worker != null) {
                        CatalogNavigator.this._worker.interrupt();
                        CatalogNavigator.this._worker = null;
                    }
                }
            });
        }
    }

    protected JComponent makeQueryResultComponent(QueryResult queryResult) {
        this._origURL = null;
        try {
            JComponent c;
            if (queryResult instanceof CatalogUIHandler && (c = ((CatalogUIHandler)queryResult).makeComponent((QueryResultDisplay)this)) != null) {
                return c;
            }
            if (queryResult instanceof CatalogDirectory) {
                return this.makeCatalogDirectoryComponent((CatalogDirectory)queryResult);
            }
            if (queryResult instanceof TableQueryResult) {
                return this.makeTableQueryResultComponent((TableQueryResult)queryResult);
            }
            if (queryResult instanceof Catalog) {
                return this.makeCatalogComponent((Catalog)queryResult);
            }
            if (queryResult instanceof URLQueryResult) {
                JComponent makeURLComponent = this.makeURLComponent((URLQueryResult)queryResult);
                return makeURLComponent;
            }
        }
        catch (Exception e) {
            if (this._progressPanel != null) {
                this._progressPanel.stop();
            }
            DialogUtil.error((Exception)e);
        }
        return new EmptyPanel();
    }

    protected JComponent makeCatalogDirectoryComponent(CatalogDirectory catalogDirectory) {
        int numCatalogs = catalogDirectory.getNumCatalogs();
        if (numCatalogs == 0) {
            return this.makeCatalogComponent((Catalog)catalogDirectory);
        }
        if (numCatalogs == 1) {
            return this.makeCatalogComponent(catalogDirectory.getCatalog(0));
        }
        return new EmptyPanel();
    }

    protected JComponent makeTableQueryResultComponent(TableQueryResult tableQueryResult) {
        TableDisplayTool tdt;
        if (this._resultComponent instanceof TableDisplayTool && (tdt = (TableDisplayTool)this._resultComponent).getTable().getName().equals(tableQueryResult.getName())) {
            tdt.setQueryResult((QueryResult)tableQueryResult);
            return tdt;
        }
        TableDisplayTool t = new TableDisplayTool(tableQueryResult, this, this._plotter);
        this.makeTablePopupMenu(t);
        return t;
    }

    protected void makeTablePopupMenu(TableDisplayTool t) {
        final JPopupMenu m = new JPopupMenu();
        m.add(this._addRowAction);
        m.add(this._deleteSelectedRowsAction);
        t.getTableDisplay().getTable().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    m.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    m.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    protected JComponent makeCatalogComponent(Catalog catalog) {
        if (catalog instanceof CatalogDirectory) {
            CatalogDirectory catalogDirectory = (CatalogDirectory)catalog;
            int numCatalogs = catalogDirectory.getNumCatalogs();
            if (numCatalogs == 1) {
                Catalog c = catalogDirectory.getCatalog(0);
                if (c instanceof TableQueryResult) {
                    return this.makeTableQueryResultComponent((TableQueryResult)c);
                }
                DialogUtil.error((String)(String.valueOf(_I18N.getString("subCatalogError")) + ": " + c));
                return new EmptyPanel();
            }
            if (numCatalogs > 1) {
                return this.makeTableQueryResultComponent(catalogDirectory.getCatalogList());
            }
        }
        if (catalog instanceof TableQueryResult) {
            return this.makeTableQueryResultComponent((TableQueryResult)catalog);
        }
        return this.makeCatalogQueryTool(catalog);
    }

    protected CatalogQueryTool makeCatalogQueryTool(Catalog catalog) {
        return new CatalogQueryTool(catalog, this);
    }

    protected JComponent makeURLComponent(URLQueryResult queryResult) throws IOException {
        try {
            URL url = queryResult.getURL();
            URLConnection connection = url.getProtocol().equals("file") ? url.openConnection() : this._progressPanel.openConnection(url);
            if (connection == null) {
                return this._queryComponent;
            }
            String format = queryResult.getFormat();
            String contentType = connection.getContentType();
            if (contentType == null) {
                contentType = "unknown";
            }
            return this.makeURLComponent(url, contentType, format);
        }
        catch (ProgressException url) {
        }
        catch (FileNotFoundException e) {
            DialogUtil.error((String)_I18N.getString("fileNotFound", new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            DialogUtil.error((Exception)e);
        }
        if (this._resultComponent != null) {
            return this._resultComponent;
        }
        return new EmptyPanel();
    }

    protected JComponent makeURLComponent(URL url, String contentType, String format) throws IOException {
        String filename = url.getFile();
        if (contentType.startsWith("text/plain")) {
            this.displayPlainText(url);
            return this._resultComponent;
        }
        if (contentType.startsWith("text/")) {
            this.displayHTMLPage(url);
            return this._resultComponent;
        }
        return this.makeUnknownURLComponent(url, contentType);
    }

    public void displayHTMLPage(URL url) {
        try {
            Desktop.getDesktop().browse(url.toURI());
        }
        catch (Exception e) {
            DialogUtil.error((Exception)e);
        }
    }

    public void displayPlainText(URL url) {
        try {
            String msg = FileUtil.getURL((URL)url);
            if (this._progressPanel != null) {
                this._progressPanel.stop();
            }
            if (msg.length() < 256) {
                DialogUtil.error((String)msg);
            } else {
                this.displayHTMLPage(url);
            }
        }
        catch (IOException e) {
            DialogUtil.error((Exception)e);
        }
    }

    protected JComponent makeUnknownURLComponent(URL url, String contentType) {
        if (this._resultComponent != null) {
            return this._resultComponent;
        }
        return new EmptyPanel();
    }

    public void open() {
        int option;
        if (this._openActionOverride != null) {
            this._openActionOverride.actionPerformed(null);
            return;
        }
        if (_fileChooser == null) {
            _fileChooser = this.makeFileChooser();
        }
        if ((option = _fileChooser.showOpenDialog(this)) == 0 && _fileChooser.getSelectedFile() != null) {
            this.open(_fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    protected JFileChooser makeFileChooser() {
        return new JFileChooser(new File("."));
    }

    public JFileChooser getFileChooser() {
        if (_fileChooser == null) {
            _fileChooser = this.makeFileChooser();
        }
        return _fileChooser;
    }

    protected JFileChooser makeSaveFileChooser() {
        return new JFileChooser(new File("."));
    }

    public void open(String fileOrUrl) {
        try {
            this.setQueryComponent(new EmptyPanel());
            URL url = FileUtil.makeURL(null, (String)fileOrUrl);
            URLQueryResult _queryResult = new URLQueryResult(url);
            this.setQueryResult((QueryResult)_queryResult);
        }
        catch (Exception e) {
            DialogUtil.error((Exception)e);
        }
    }

    public void exit() {
        System.exit(0);
    }

    public void close() {
        JFrame parent = SwingUtil.getFrame((Component)this);
        if (parent != null) {
            parent.setVisible(false);
        }
    }

    public void back() {
        Catalog cat;
        if (this._backStack.size() == 0) {
            return;
        }
        if (this._queryComponent != null) {
            this._queryPanel.remove(this._queryComponent);
            URL url = this._origURL;
            CatalogHistoryItem item = this.makeCatalogHistoryItem();
            this._origURL = url;
            if (item != null) {
                this._forwStack.push(item);
                this._forwAction.setEnabled(true);
            }
        }
        CatalogHistoryItem historyItem = this._backStack.pop();
        if (this._backStack.size() == 0) {
            this._backAction.setEnabled(false);
        }
        if (historyItem.getQueryComponent() != null && (cat = this._panelTreeNodeTable.get(historyItem.getQueryComponent())) != null) {
            this._catalogTree.setSelectedCatalog(cat, true);
        }
        CatalogNavigatorMenuBar.setCurrentCatalogNavigator(this);
        this._noStack = true;
        try {
            historyItem.actionPerformed(null);
        }
        catch (Exception e) {
            DialogUtil.error((Exception)e);
        }
        this._noStack = false;
        this.update();
    }

    public void forward() {
        Catalog cat;
        if (this._forwStack.size() == 0) {
            return;
        }
        if (this._queryComponent != null) {
            this._queryPanel.remove(this._queryComponent);
            URL url = this._origURL;
            CatalogHistoryItem item = this.makeCatalogHistoryItem();
            this._origURL = url;
            if (item != null) {
                this._backStack.push(item);
                this._backAction.setEnabled(true);
            }
        }
        CatalogHistoryItem historyItem = this._forwStack.pop();
        if (this._forwStack.size() == 0) {
            this._forwAction.setEnabled(false);
        }
        if (historyItem.getQueryComponent() != null && (cat = this._panelTreeNodeTable.get(historyItem.getQueryComponent())) != null) {
            this._catalogTree.setSelectedCatalog(cat, true);
        }
        CatalogNavigatorMenuBar.setCurrentCatalogNavigator(this);
        this._noStack = true;
        try {
            historyItem.actionPerformed(null);
        }
        catch (Exception e) {
            DialogUtil.error((Exception)e);
        }
        this._noStack = false;
        this.update();
    }

    public AbstractAction getOpenAction() {
        return this._openAction;
    }

    public AbstractAction getOpenUrlAction() {
        return this._openUrlAction;
    }

    public AbstractAction getClearAction() {
        return this._clearAction;
    }

    public void setOpenAction(AbstractAction openAction) {
        this._openActionOverride = openAction;
    }

    public AbstractAction getSaveAsAction() {
        return this._saveAsAction;
    }

    public AbstractAction getSaveAsHTMLAction() {
        return this._saveAsHTMLAction;
    }

    public AbstractAction getSaveWithImageAction() {
        return this._saveWithImageAction;
    }

    public AbstractAction getPrintAction() {
        return this._printAction;
    }

    public AbstractAction getBackAction() {
        return this._backAction;
    }

    public AbstractAction getForwAction() {
        return this._forwAction;
    }

    public AbstractAction getAddRowAction() {
        return this._addRowAction;
    }

    public AbstractAction getDeleteSelectedRowsAction() {
        return this._deleteSelectedRowsAction;
    }

    public AbstractAction getStoreNewQueryAction() {
        return this._storeNewQueryAction;
    }

    public AbstractAction getDeleteAllQueryAction() {
        return this._deleteAllQueryAction;
    }

    public AbstractAction getCloseAction() {
        return this._closeAction;
    }

    public AbstractAction getExitAction() {
        return this._exitAction;
    }

    public void openURL() {
        String urlStr = DialogUtil.input((String)(String.valueOf(_I18N.getString("enterURLDisplay")) + ":"));
        if (urlStr != null) {
            URL url;
            try {
                url = new URL(urlStr);
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
                return;
            }
            this.setQueryResult((QueryResult)new URLQueryResult(url));
        }
    }

    public void clear() {
        this.setQueryComponent(new EmptyPanel());
        this._origURL = null;
    }

    public void saveAs() {
        if (this._resultComponent instanceof SaveableWithDialog) {
            ((SaveableWithDialog)this._resultComponent).saveAs();
        } else {
            DialogUtil.error((String)_I18N.getString("saveNotSupportedForObjType"));
        }
    }

    public void saveAs(String filename) {
        if (this._resultComponent instanceof Saveable) {
            try {
                ((Saveable)this._resultComponent).saveAs(filename);
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        } else {
            DialogUtil.error((String)_I18N.getString("saveNotSupportedForObjType"));
        }
    }

    public void saveWithImage() {
    }

    public void saveAsHTML() {
        if (this._resultComponent instanceof SaveableAsHTML) {
            int option;
            if (_saveFileChooser == null) {
                _saveFileChooser = this.makeSaveFileChooser();
            }
            if ((option = _saveFileChooser.showSaveDialog(this)) == 0 && _saveFileChooser.getSelectedFile() != null) {
                this.saveAsHTML(_saveFileChooser.getSelectedFile().getAbsolutePath());
            }
        } else {
            DialogUtil.error((String)_I18N.getString("htmlOutputNotSupportedForObjType"));
        }
    }

    public void saveAsHTML(String filename) {
        if (this._resultComponent instanceof SaveableAsHTML) {
            try {
                ((SaveableAsHTML)this._resultComponent).saveAsHTML(filename);
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        } else {
            DialogUtil.error((String)_I18N.getString("htmlOutputNotSupportedForObjType"));
        }
    }

    public void print() {
        if (this._resultComponent instanceof PrintableWithDialog) {
            try {
                ((PrintableWithDialog)this._resultComponent).print();
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        } else {
            DialogUtil.error((String)_I18N.getString("printingNotSupportedForObjType"));
        }
    }

    public void addRow() {
        if (this._resultComponent instanceof TableDisplayTool) {
            ((TableDisplayTool)this._resultComponent).addRow();
        }
    }

    public void deleteSelectedRows() {
        if (this._resultComponent instanceof TableDisplayTool) {
            ((TableDisplayTool)this._resultComponent).deleteSelectedRows();
        }
    }

    public void setTableCellsEditable(boolean b) {
        if (this._resultComponent instanceof TableDisplayTool) {
            ((TableDisplayTool)this._resultComponent).setTableCellsEditable(b);
        }
    }

    protected ProgressPanel getProgressPanel() {
        return this._progressPanel;
    }

    protected Stack<CatalogHistoryItem> getBackStack() {
        return this._backStack;
    }

    protected Stack<CatalogHistoryItem> getForwStack() {
        return this._forwStack;
    }

    public void storeNewQuery() {
        String name = DialogUtil.input((Component)this, (String)_I18N.getString("enterNameForQuery"));
        if (name == null || name.length() == 0) {
            return;
        }
        this.storeQuery(name);
    }

    public void storeQuery(String name) {
        if (this._queryComponent instanceof Storeable) {
            try {
                Object queryInfo = ((Storeable)this._queryComponent).storeSettings();
                Object resultInfo = null;
                if (this._resultComponent instanceof Storeable) {
                    resultInfo = ((Storeable)this._resultComponent).storeSettings();
                }
                CatalogQueryItem item = new CatalogQueryItem(name, queryInfo, resultInfo);
                this._queryList.add(item);
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    }

    public void deleteQuery(String name) {
        this._queryList.remove(name);
    }

    public void clearQueryList() {
        this._queryList.clear();
    }

    /*
     * Unable to fully structure code
     */
    public void addQueryMenuItems(JMenu menu, ActionListener l) {
        block2: {
            it = this._queryList.iterator();
            if (l != null) ** GOTO lbl13
            while (it.hasNext()) {
                menu.add((CatalogQueryItem)it.next());
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                item = (CatalogQueryItem)it.next();
                menuItem = new JMenuItem(item.getName());
                menuItem.addActionListener(l);
                menu.add(menuItem);
lbl13:
                // 2 sources

                ** while (it.hasNext())
            }
        }
    }

    public StarTable getStarTable() {
        TableDisplayTool t;
        TableQueryResult tqr;
        JComponent c = this.getResultComponent();
        if (c instanceof TableDisplayTool && (tqr = (t = (TableDisplayTool)c).getTable()) != null) {
            return tqr.getStarTable();
        }
        return null;
    }

    public void registerTable(URL url, String tableId) {
        if (this._queryComponent != null) {
            if (tableId != null) {
                this._queryComponentMap.put(tableId, this._queryComponent);
            }
            if (url != null) {
                this._queryComponentMap.put(url.toString(), this._queryComponent);
            }
        }
    }

    public void selectTableRows(String tableId, URL url, int[] rows) {
        JComponent resultComp;
        JComponent queryComp = null;
        if (tableId != null) {
            queryComp = this._queryComponentMap.get(tableId);
        }
        if (queryComp == null && url != null) {
            queryComp = this._queryComponentMap.get(url.toString());
        }
        if (queryComp != null && (resultComp = this._queryResultComponentMap.get(queryComp)) instanceof TableDisplayTool) {
            TableDisplay tableDisplay = ((TableDisplayTool)resultComp).getTableDisplay();
            tableDisplay.getTable().clearSelection();
            int[] nArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                int row = nArray[n2];
                tableDisplay.selectRow(row);
                ++n2;
            }
            CatalogHistoryItem historyItem = this._historyList.getItemForQueryComponent(queryComp);
            if (historyItem != null) {
                historyItem.actionPerformed(null);
            }
        }
    }

    public class EmptyPanel
    extends JPanel
    implements QueryResultDisplay {
        public EmptyPanel() {
            if ("Mac OS X".equals(UIManager.getLookAndFeel().getName())) {
                this.setBorder(BorderFactory.createEtchedBorder());
            }
        }

        public void setQueryResult(QueryResult queryResult) {
            throw new RuntimeException(_I18N.getString("queryResultDisplayError"));
        }
    }
}

