/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableModel;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.astrocat.AstroCatConfig;
import jsky.catalog.gui.CatalogDirectoryChooserForm;
import jsky.catalog.vo.VoCatalogDirectory;
import jsky.util.SwingWorker;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.ProgressPanel;
import uk.ac.starlink.vo.RegistryQuery;

public class CatalogDirectoryChooser
extends CatalogDirectoryChooserForm {
    private static final String ROOT_URL = "http://registry.astrogrid.org/astrogrid-registry/services/RegistryQueryv1_0";
    private ProgressPanel _progressPanel;
    private EventListenerList _listenerList = new EventListenerList();

    public CatalogDirectoryChooser(Frame owner) {
        super(owner);
        try {
            this._update();
        }
        catch (Exception e) {
            DialogUtil.error((Exception)e);
        }
        this.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CatalogDirectoryChooser.this.setVisible(false);
            }
        });
        this.getOkButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CatalogDirectoryChooser.this._apply();
            }
        });
    }

    private void _update() throws MalformedURLException {
        URL rootUrl = new URL(ROOT_URL);
        if (this._progressPanel == null) {
            this._progressPanel = ProgressPanel.makeProgressPanel((String)("Updating list of available VO registries from: " + rootUrl.getHost()), (Component)this);
        }
        new SwingWorker(){

            public Object construct() {
                try {
                    AstroCatConfig.getConfigFile();
                    CatalogDirectoryChooser.this._progressPanel.start();
                    String[] stringArray = RegistryQuery.getSearchableRegistries((String)CatalogDirectoryChooser.ROOT_URL);
                    return stringArray;
                }
                catch (Exception e) {
                    Exception exception = e;
                    return exception;
                }
                finally {
                    CatalogDirectoryChooser.this._progressPanel.stop();
                }
            }

            public void finished() {
                Object o = this.getValue();
                if (o instanceof String[]) {
                    try {
                        CatalogDirectoryChooser.this._updateTableModel((String[])o);
                    }
                    catch (Exception e) {
                        DialogUtil.error((Exception)e);
                    }
                } else if (o instanceof Exception) {
                    DialogUtil.error((Exception)((Exception)o));
                }
            }
        }.start();
    }

    private void _updateTableModel(String[] urls) throws MalformedURLException, URISyntaxException {
        DefaultTableModel model = (DefaultTableModel)this.getTable().getModel();
        int numRows = model.getRowCount();
        int i = 0;
        while (i < numRows) {
            model.removeRow(i);
            ++i;
        }
        TreeSet<URI> set = new TreeSet<URI>();
        String[] stringArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            String url = stringArray[n2];
            set.add(new URI(url));
            ++n2;
        }
        set.add(new URI(ROOT_URL));
        AstroCatConfig config = AstroCatConfig.getConfigFile();
        HashMap<URI, String> map = new HashMap<URI, String>();
        for (Catalog cat : config.getCatalogs()) {
            if (!(cat instanceof VoCatalogDirectory)) continue;
            VoCatalogDirectory dir = (VoCatalogDirectory)cat;
            URI uri = dir.getURL().toURI();
            String name = dir.getName();
            if (name == null) {
                name = "";
            }
            map.put(uri, name);
            set.add(uri);
        }
        for (URI uri : set) {
            Vector<Object> row = new Vector<Object>(3);
            String name = (String)map.get(uri);
            row.add(name != null);
            row.add(name);
            row.add(uri.toString());
            model.addRow(row);
        }
    }

    private void _apply() {
        final TreeMap<String, String> map = new TreeMap<String, String>();
        DefaultTableModel model = (DefaultTableModel)this.getTable().getModel();
        int numRows = model.getRowCount();
        int row = 0;
        while (row < numRows) {
            if (((Boolean)model.getValueAt(row, 0)).booleanValue()) {
                String url = (String)model.getValueAt(row, 2);
                String name = (String)model.getValueAt(row, 1);
                if (name == null || name.length() == 0) {
                    name = url;
                }
                map.put(url, name);
            }
            ++row;
        }
        final AstroCatConfig config = AstroCatConfig.getConfigFile();
        for (Catalog cat : new ArrayList(config.getCatalogs())) {
            VoCatalogDirectory catDir;
            if (!(cat instanceof VoCatalogDirectory) || map.get((catDir = (VoCatalogDirectory)cat).getURL().toString()) != null) continue;
            config.removeCatalog(cat);
        }
        new SwingWorker(){

            public Object construct() {
                try {
                    for (String urlStr : map.keySet()) {
                        String name = (String)map.get(urlStr);
                        URL url = new URL(urlStr);
                        CatalogDirectory dir = CatalogDirectoryChooser.this._findDir(config.getCatalogs(), url);
                        if (dir != null) {
                            dir.setName(name);
                            continue;
                        }
                        config.addCatalog((Catalog)VoCatalogDirectory.getCatalogList((String)name, (URL)url));
                    }
                    return null;
                }
                catch (Exception e) {
                    return e;
                }
            }

            public void finished() {
                Object o = this.getValue();
                if (o instanceof Exception) {
                    DialogUtil.error((Exception)((Exception)o));
                } else {
                    CatalogDirectoryChooser.this.setVisible(false);
                    config.save();
                    CatalogDirectoryChooser.this._fireChangeEvent();
                }
            }
        }.start();
    }

    private CatalogDirectory _findDir(List<Catalog> list, URL url) {
        for (Catalog cat : list) {
            CatalogDirectory catDir;
            if (!(cat instanceof CatalogDirectory) || !url.equals((catDir = (CatalogDirectory)cat).getURL())) continue;
            return catDir;
        }
        return null;
    }

    public void addChangeListener(ChangeListener l) {
        this._listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this._listenerList.remove(ChangeListener.class, l);
    }

    private void _fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] listeners = this._listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ChangeListener.class) {
                ((ChangeListener)listeners[i + 1]).stateChanged(changeEvent);
            }
            i -= 2;
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CatalogDirectoryChooser chooser = new CatalogDirectoryChooser(null);
                chooser.setVisible(true);
            }
        });
    }
}

