/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.exolab.javasource.JAnnotatedElementHelper;
import org.exolab.javasource.JArrayType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JType;

public final class JMethodSignature
extends JAnnotatedElementHelper {
    private JModifiers _modifiers = null;
    private JType _returnType = null;
    private String _name = null;
    private final Map<String, JParameter> _params = new LinkedHashMap<String, JParameter>();
    private final JDocComment _jdc = new JDocComment();
    private final Vector<JClass> _exceptions = new Vector(1);

    public JMethodSignature(String name) {
        if (name == null || name.length() == 0) {
            String err = "The method name must not be null or zero-length";
            throw new IllegalArgumentException(err);
        }
        this._returnType = null;
        this._name = name;
        this._modifiers = new JModifiers();
    }

    public JMethodSignature(String name, JType returnType) {
        this(name);
        if (returnType == null) {
            String err = "The return type must not be null or zero-length";
            throw new IllegalArgumentException(err);
        }
        this._returnType = returnType;
    }

    public void addException(JClass exp) {
        if (exp == null) {
            return;
        }
        String expClassName = exp.getName();
        for (JClass jClass : this._exceptions) {
            if (!expClassName.equals(jClass.getName())) continue;
            return;
        }
        this._exceptions.add(exp);
    }

    public void addParameter(JParameter parameter) {
        if (parameter == null) {
            return;
        }
        String pName = parameter.getName();
        if (this._params.get(pName) != null) {
            String err = new StringBuilder(96).append("A parameter already exists for this method, ").append(this._name).append(", with the name: ").append(pName).toString();
            throw new IllegalArgumentException(err);
        }
        this._params.put(pName, parameter);
        this._jdc.addDescriptor(JDocDescriptor.createParamDesc(pName, null));
    }

    public JClass[] getExceptions() {
        return this._exceptions.toArray(new JClass[this._exceptions.size()]);
    }

    public JDocComment getJDocComment() {
        return this._jdc;
    }

    public JModifiers getModifiers() {
        return this._modifiers;
    }

    public String getName() {
        return this._name;
    }

    public JParameter getParameter(int index) {
        return this._params.get(index);
    }

    public synchronized JParameter[] getParameters() {
        return this._params.values().toArray(new JParameter[this._params.size()]);
    }

    public JType getReturnType() {
        return this._returnType;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setComment(String comment) {
        this._jdc.setComment(comment);
    }

    public void setModifiers(JModifiers modifiers) {
        this._modifiers = modifiers.copy();
        this._modifiers.setFinal(false);
    }

    protected String[] getParameterClassNames() {
        ArrayList<String> names = new ArrayList<String>(this._params.size());
        for (JParameter parameter : this._params.values()) {
            JType jType = parameter.getType();
            while (jType.isArray()) {
                jType = ((JArrayType)jType).getComponentType();
            }
            if (jType.isPrimitive()) continue;
            JClass jclass = (JClass)jType;
            names.add(jclass.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    public void print(JSourceWriter jsw) {
        this.print(jsw, true);
    }

    public void print(JSourceWriter jsw, boolean printJavaDoc) {
        if (printJavaDoc) {
            this._jdc.print(jsw);
        }
        this.printAnnotations(jsw);
        String modifiers = this._modifiers.toString();
        jsw.write(modifiers);
        if (!modifiers.isEmpty()) {
            jsw.write(32);
        }
        if (this._returnType != null) {
            jsw.write(this._returnType);
        } else {
            jsw.write("void");
        }
        jsw.write(32);
        jsw.write(this._name);
        jsw.write(40);
        int parameterCount = 0;
        for (JParameter jParameter : this._params.values()) {
            if (parameterCount > 0) {
                jsw.write(",");
            }
            jParameter.printAnnotations(jsw);
            String typeAndName = jParameter.toString();
            jsw.write(typeAndName);
            ++parameterCount;
        }
        jsw.write(")");
        if (!this._exceptions.isEmpty()) {
            jsw.write(" throws ");
            for (int i = 0; i < this._exceptions.size(); ++i) {
                if (i > 0) {
                    jsw.write(", ");
                }
                JClass jClass = this._exceptions.elementAt(i);
                jsw.write(jClass.getName());
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        if (this._returnType != null) {
            sb.append(this._returnType);
        } else {
            sb.append("void");
        }
        sb.append(' ');
        sb.append(this._name);
        sb.append('(');
        int i = 0;
        for (JParameter jParam : this._params.values()) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(jParam.getType().getName());
        }
        sb.append(") ");
        return sb.toString();
    }
}

