/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Base64Decoder;
import org.castor.core.util.HexDecoder;
import org.castor.xml.InternalContext;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.MapItem;
import org.exolab.castor.types.AnyNode;
import org.exolab.castor.util.DefaultObjectFactory;
import org.exolab.castor.util.ObjectFactory;
import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.CharactersProcessor;
import org.exolab.castor.xml.EndElementProcessor;
import org.exolab.castor.xml.IDResolver;
import org.exolab.castor.xml.IDResolverImpl;
import org.exolab.castor.xml.MarshalFramework;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.ReferenceInfo;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.StartElementProcessor;
import org.exolab.castor.xml.UnmarshalListener;
import org.exolab.castor.xml.UnmarshalState;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.descriptors.PrimitivesClassDescriptor;
import org.exolab.castor.xml.descriptors.StringClassDescriptor;
import org.exolab.castor.xml.parsing.AnyNodeUnmarshalHandler;
import org.exolab.castor.xml.parsing.AttributeSetBuilder;
import org.exolab.castor.xml.parsing.NamespaceHandling;
import org.exolab.castor.xml.parsing.StrictElementHandler;
import org.exolab.castor.xml.parsing.UnmarshalListenerDelegate;
import org.exolab.castor.xml.parsing.UnmarshalStateStack;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveObjectFactory;
import org.exolab.castor.xml.util.XMLFieldDescriptorImpl;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class UnmarshalHandler
extends MarshalFramework
implements ContentHandler,
DocumentHandler,
ErrorHandler {
    static final Log LOG = LogFactory.getLog(UnmarshalHandler.class);
    protected static ResourceBundle resourceBundle = ResourceBundle.getBundle("UnmarshalHandlerMessages", Locale.getDefault());
    private static final String ERROR_DID_NOT_FIND_CLASSDESCRIPTOR = "unable to find or create a ClassDescriptor for class: ";
    private static final String XML_PREFIX = "xml";
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_PREFIX = "xmlns:";
    private static final String XSI_TYPE = "type";
    static final String XML_SPACE = "space";
    static final String XML_SPACE_WITH_PREFIX = "xml:space";
    static final String PRESERVE = "preserve";
    private UnmarshalState _topState = null;
    private Class<?> _topClass = null;
    private Object _topObject = null;
    private boolean _clearCollections = false;
    private Locator _locator = null;
    private IDResolver _idResolver = null;
    private boolean _validate = true;
    private Hashtable<String, ReferenceInfo> _resolveTable = new Hashtable();
    private Map<Class<?>, String> _javaPackages = null;
    private ClassLoader _loader = null;
    private static final StringClassDescriptor STRING_DESCRIPTOR = new StringClassDescriptor();
    private AnyNode _node = null;
    private ObjectFactory _objectFactory = new DefaultObjectFactory();
    private boolean _reuseObjects = false;
    private boolean _strictAttributes = false;
    private boolean _wsPreserve = false;
    private StrictElementHandler _strictElementHandler = new StrictElementHandler();
    private UnmarshalStateStack _stateStack = new UnmarshalStateStack();
    private UnmarshalListenerDelegate _delegateUnmarshalListener = new UnmarshalListenerDelegate();
    private AnyNodeUnmarshalHandler _anyNodeHandler = null;
    private NamespaceHandling _namespaceHandling = new NamespaceHandling();
    private AttributeSetBuilder _attributeSetFactory = null;

    protected UnmarshalHandler() {
        this((Class<?>)null);
    }

    protected UnmarshalHandler(Class<?> topClass) {
        this(null, topClass);
    }

    protected UnmarshalHandler(InternalContext internalContext, Class<?> topClass) {
        super(internalContext);
        this._idResolver = new IDResolverImpl();
        this._javaPackages = new HashMap();
        this._topClass = topClass;
        this._anyNodeHandler = new AnyNodeUnmarshalHandler(this._namespaceHandling);
        this._attributeSetFactory = new AttributeSetBuilder(this._namespaceHandling);
    }

    public void addNamespaceToPackageMapping(String nsURI, String packageName) {
        this._namespaceHandling.addNamespaceToPackageMapping(nsURI, packageName);
    }

    public Object getCurrentObject() {
        UnmarshalState state;
        if (!this._stateStack.isEmpty() && (state = this._stateStack.getLastState()) != null) {
            return state.getObject();
        }
        return null;
    }

    public Object getObject() {
        if (this._topState != null) {
            return this._topState.getObject();
        }
        return null;
    }

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public void setClearCollections(boolean clear) {
        this._clearCollections = clear;
    }

    public void setDebug(boolean debug) {
    }

    public void setIDResolver(IDResolver idResolver) {
        ((IDResolverImpl)this._idResolver).setResolver(idResolver);
    }

    public void setIgnoreExtraAttributes(boolean ignoreExtraAtts) {
        this._strictAttributes = !ignoreExtraAtts;
    }

    public void setIgnoreExtraElements(boolean ignoreExtraElems) {
        this._strictElementHandler.setIgnoreExtraElements(ignoreExtraElems);
    }

    public void setLogWriter(PrintWriter printWriter) {
    }

    public void setReuseObjects(boolean reuse) {
        this._reuseObjects = reuse;
    }

    public void setRootObject(Object root) {
        this._topObject = root;
    }

    public void setUnmarshalListener(UnmarshalListener listener) {
        this._delegateUnmarshalListener.setUnmarshalListener(listener);
    }

    public void setUnmarshalListener(org.castor.xml.UnmarshalListener listener) {
        this._delegateUnmarshalListener.setUnmarshalListener(listener);
    }

    public void setValidation(boolean validate) {
        this._validate = validate;
    }

    public void setWhitespacePreserve(boolean preserve) {
        this._wsPreserve = preserve;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        new CharactersProcessor(this).compute(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String name) throws SAXException {
        new EndElementProcessor(this).compute(name);
    }

    byte[] decodeBinaryData(XMLFieldDescriptor descriptor, String binaryData) {
        byte[] decodedValue = descriptor.isMultivalued() && "hexBinary".equals(descriptor.getComponentType()) || "hexBinary".equals(descriptor.getSchemaType()) ? HexDecoder.decode(binaryData) : Base64Decoder.decode(binaryData);
        return decodedValue;
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (StringUtils.isEmpty((CharSequence)qName)) {
            String prefix;
            if (StringUtils.isEmpty((CharSequence)localName)) {
                String error = resourceBundle.getString("unmarshalHandler.error.localName.and.qName.null");
                throw new SAXException(error);
            }
            qName = localName;
            if (StringUtils.isNotEmpty((CharSequence)namespaceURI) && StringUtils.isEmpty((CharSequence)(prefix = this._namespaceHandling.getNamespacePrefix(namespaceURI)))) {
                qName = prefix + ":" + localName;
            }
        }
        this.endElement((String)qName);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this._anyNodeHandler.hasAnyUnmarshaller()) {
            this._anyNodeHandler.endPrefixMapping(prefix);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this._strictElementHandler.skipElement()) {
            return;
        }
        if (this._stateStack.isEmpty()) {
            return;
        }
        if (this._anyNodeHandler.hasAnyUnmarshaller()) {
            this._anyNodeHandler.ignorableWhitespace(ch, start, length);
        } else {
            UnmarshalState state = this._stateStack.getLastState();
            if (state.isWhitespacePreserving()) {
                if (state.getBuffer() == null) {
                    state.setBuffer(new StringBuffer());
                }
                state.getBuffer().append(ch, start, length);
            }
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public Locator getDocumentLocator() {
        return this._locator;
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    private void extractNamespaceInformation(Attributes attributes) {
        if (attributes == null || attributes.getLength() == 0) {
            return;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attributeName = attributes.getQName(i);
            if (StringUtils.isNotEmpty((CharSequence)attributeName)) {
                if (attributeName.equals(XMLNS)) {
                    this._namespaceHandling.addDefaultNamespace(attributes.getValue(i));
                    continue;
                }
                if (!attributeName.startsWith(XMLNS_PREFIX)) continue;
                String prefix = attributeName.substring(XMLNS_PREFIX.length());
                this._namespaceHandling.addNamespace(prefix, attributes.getValue(i));
                continue;
            }
            attributeName = attributes.getLocalName(i);
            if (!XMLNS.equals(attributeName)) continue;
            this._namespaceHandling.addDefaultNamespace(attributes.getValue(i));
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (LOG.isTraceEnabled()) {
            String trace = StringUtils.isNotEmpty((CharSequence)qName) ? MessageFormat.format(resourceBundle.getString("unmarshalHandler.log.trace.startElement"), qName) : MessageFormat.format(resourceBundle.getString("unmarshalHandler.log.trace.startElement"), localName);
            LOG.trace((Object)trace);
        }
        if (this._strictElementHandler.skipStartElement()) {
            return;
        }
        if (this._anyNodeHandler.hasAnyUnmarshaller()) {
            this._anyNodeHandler.startElement(namespaceURI, localName, qName, atts);
            return;
        }
        if (this._namespaceHandling.isNewNamespaceScopeNecessary()) {
            this._namespaceHandling.startNamespaceScope();
        } else {
            this._namespaceHandling.setNewNamespaceScopeNecessary(true);
        }
        this.extractNamespaceInformation(atts);
        Object tmpQName = null;
        if (StringUtils.isEmpty((CharSequence)localName)) {
            if (StringUtils.isEmpty((CharSequence)qName)) {
                String error = resourceBundle.getString("unmarshalHandler.error.localName.and.qName.null");
                throw new SAXException(error);
            }
            localName = qName;
            tmpQName = qName;
        } else if (StringUtils.isEmpty((CharSequence)qName)) {
            if (StringUtils.isEmpty((CharSequence)namespaceURI)) {
                tmpQName = localName;
            } else {
                String prefix = this._namespaceHandling.getNamespacePrefix(namespaceURI);
                if (StringUtils.isNotEmpty((CharSequence)prefix)) {
                    tmpQName = prefix + ":" + localName;
                }
            }
        } else {
            tmpQName = qName;
        }
        this._anyNodeHandler.preservePassedArguments((String)tmpQName, atts);
        int idx = localName.indexOf(58);
        if (idx >= 0) {
            String prefix = localName.substring(0, idx);
            localName = localName.substring(idx + 1);
            if (StringUtils.isEmpty((CharSequence)namespaceURI)) {
                namespaceURI = this._namespaceHandling.getNamespaceURI(prefix);
            }
        } else {
            String defaultNamespace = this._namespaceHandling.getDefaultNamespaceURI();
            if (defaultNamespace != null && !defaultNamespace.equals("http://castor.exolab.org")) {
                namespaceURI = defaultNamespace;
            }
            if (StringUtils.isEmpty((CharSequence)namespaceURI)) {
                namespaceURI = null;
            }
        }
        this.startElementProcessing(localName, namespaceURI, this._attributeSetFactory.getAttributeSet(atts));
    }

    @Override
    public void startElement(String name, AttributeList attList) throws SAXException {
        if (LOG.isTraceEnabled()) {
            String trace = MessageFormat.format(resourceBundle.getString("unmarshalHandler.log.trace.startElement"), name);
            LOG.trace((Object)trace);
        }
        if (this._strictElementHandler.skipStartElement()) {
            return;
        }
        if (this._anyNodeHandler.hasAnyUnmarshaller()) {
            this._anyNodeHandler.startElement(name, attList);
            return;
        }
        this._anyNodeHandler.preservePassedArguments(name, attList);
        String namespace = null;
        this._namespaceHandling.createNamespace();
        String prefix = "";
        int idx = name.indexOf(58);
        if (idx >= 0) {
            prefix = name.substring(0, idx);
            name = name.substring(idx + 1);
        }
        namespace = this._namespaceHandling.getNamespaceURI(prefix);
        this.startElementProcessing(name, namespace, this._attributeSetFactory.getAttributeSet(attList));
    }

    void startElementProcessing(String name, String namespace, AttributeSet atts) throws SAXException {
        new StartElementProcessor(this).compute(name, namespace, atts);
    }

    void processFirstElement(String name, String namespace, AttributeSet atts, String xmlSpace) throws SAXException {
        if (this._topClass == null && this._topObject != null) {
            this._topClass = this._topObject.getClass();
        }
        if (this.getInternalContext().getXMLClassDescriptorResolver() == null) {
            String message = resourceBundle.getString("unmarshalHandler.log.warn.class.descriptor.not.set");
            LOG.warn((Object)message);
            throw new IllegalStateException(message);
        }
        this._topState = new UnmarshalState();
        this._topState.setElementName(name);
        this._topState.setWhitespacePreserving(xmlSpace != null ? PRESERVE.equals(xmlSpace) : this._wsPreserve);
        XMLClassDescriptor classDesc = null;
        String instanceClassname = null;
        if (this._topClass == null) {
            instanceClassname = this.getInstanceType(atts, null);
            if (instanceClassname != null) {
                try {
                    this._topClass = this.loadClass(instanceClassname, null);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (this._topClass == null) {
                    classDesc = this.getClassDescriptor(instanceClassname);
                    if (classDesc != null) {
                        this._topClass = classDesc.getJavaClass();
                    }
                    if (this._topClass == null) {
                        String error = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.class.not.found"), instanceClassname);
                        throw new SAXException(error);
                    }
                }
            } else {
                classDesc = this.resolveByXMLName(name, namespace, null);
                if (classDesc == null && (classDesc = this.getClassDescriptor(name, this._loader)) == null) {
                    classDesc = this.getClassDescriptor(this.getJavaNaming().toJavaClassName(name));
                }
                if (classDesc != null) {
                    this._topClass = classDesc.getJavaClass();
                }
            }
            if (this._topClass == null) {
                String err = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.class.root.not.found"), name);
                throw new SAXException(err);
            }
        }
        XMLFieldDescriptorImpl fieldDesc = new XMLFieldDescriptorImpl(this._topClass, name, name, NodeType.Element);
        this._topState.setFieldDescriptor(fieldDesc);
        if (classDesc == null) {
            classDesc = this.getClassDescriptor(this._topClass);
        }
        if (classDesc == null && UnmarshalHandler.isPrimitive(this._topClass)) {
            classDesc = new PrimitivesClassDescriptor(this._topClass);
            fieldDesc.setIncremental(false);
            this._topState.setPrimitiveOrImmutable(true);
        }
        fieldDesc.setClassDescriptor(classDesc);
        if (classDesc == null) {
            if (!UnmarshalHandler.isPrimitive(this._topClass) && !Serializable.class.isAssignableFrom(this._topClass)) {
                throw new SAXException("The marshaller cannot unmarshal non primitive types that do not implement java.io.Serializable");
            }
            String err = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.create.class.descriptor"), this._topClass.getName());
            throw new SAXException(err);
        }
        this._topState.setClassDescriptor(classDesc);
        this._topState.setType(this._topClass);
        if (this._topObject == null && !this._topState.isPrimitiveOrImmutable()) {
            String topPackage = this.getJavaPackage(this._topClass);
            if ((instanceClassname = instanceClassname == null ? this.getInstanceType(atts, topPackage) : null) != null) {
                Class<?> instanceClass = null;
                try {
                    block31: {
                        XMLClassDescriptor xcd = this.getClassDescriptor(instanceClassname);
                        boolean loadClass = true;
                        if (xcd != null && (instanceClass = xcd.getJavaClass()) != null) {
                            boolean bl = loadClass = !instanceClassname.equals(instanceClass.getName());
                        }
                        if (loadClass) {
                            try {
                                instanceClass = this.loadClass(instanceClassname, null);
                            }
                            catch (ClassNotFoundException cnfe) {
                                if (xcd == null) break block31;
                                instanceClass = xcd.getJavaClass();
                            }
                        }
                    }
                    if (instanceClass == null) {
                        String error = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.class.not.found"), instanceClassname);
                        throw new SAXException(error);
                    }
                    if (!this._topClass.isAssignableFrom(instanceClass)) {
                        String err = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.not.subclass"), instanceClass, this._topClass);
                        throw new SAXException(err);
                    }
                }
                catch (Exception ex) {
                    String err = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.unable.instantiate"), instanceClassname);
                    throw new SAXException(err, ex);
                }
                Arguments args = this.processConstructorArgs(atts, classDesc);
                this._topState.setObject(this.createInstance(instanceClass, args));
            } else {
                Arguments args = this.processConstructorArgs(atts, classDesc);
                this._topState.setObject(this.createInstance(this._topClass, args));
            }
        } else {
            this._topState.setObject(this._topObject);
        }
        this._stateStack.pushState(this._topState);
        if (!this._topState.isPrimitiveOrImmutable()) {
            Object stateObject = this._topState.getObject();
            Object parentObject = this._topState.getParent() == null ? null : this._topState.getParent().getObject();
            this._delegateUnmarshalListener.initialized(stateObject, parentObject);
            this.processAttributes(atts, classDesc);
            this._delegateUnmarshalListener.attributesProcessed(stateObject, parentObject);
            this._namespaceHandling.processNamespaces(classDesc, this._stateStack.getLastState().getObject());
        }
        String pkg = this.getJavaPackage(this._topClass);
        if (this.getMappedPackage(namespace) == null) {
            this.addNamespaceToPackageMapping(namespace, pkg);
        }
    }

    boolean isValidating() {
        return this._validate;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (XML_PREFIX.equals(prefix) && "http://www.w3.org/XML/1998/namespace".equals(uri)) {
            return;
        }
        if (XMLNS.equals(prefix)) {
            return;
        }
        if (this._anyNodeHandler.hasAnyUnmarshaller()) {
            this._anyNodeHandler.startPrefixMapping(prefix, uri);
        } else if (this._namespaceHandling.isNewNamespaceScopeNecessary()) {
            this._namespaceHandling.stopNamespaceScope();
        }
        this._namespaceHandling.addNamespace(prefix, uri);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        String error = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.sax.exception"), exception.getMessage(), exception.getLineNumber(), exception.getColumnNumber());
        throw new SAXException(error, exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.error(exception);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.error(exception);
    }

    void addReference(String idRef, Object parent, XMLFieldDescriptor descriptor) {
        ReferenceInfo refInfo = new ReferenceInfo(idRef, parent, descriptor);
        refInfo.setNext(this._resolveTable.get(idRef));
        this._resolveTable.put(idRef, refInfo);
    }

    Object createInstance(Class<?> type, Arguments args) throws SAXException {
        Object instance = null;
        try {
            instance = args == null ? this._objectFactory.createInstance(type) : this._objectFactory.createInstance(type, args.getTypes(), args.getValues());
        }
        catch (Exception ex) {
            String error = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.unable.instantiate"), type.getName());
            throw new SAXException(error, ex);
        }
        return instance;
    }

    String getInstanceType(AttributeSet atts, String currentPackage) throws SAXException {
        if (atts == null) {
            return null;
        }
        String type = atts.getValue(XSI_TYPE, "http://www.w3.org/2001/XMLSchema-instance");
        if (type != null) {
            if (type.startsWith("java:")) {
                return type.substring("java:".length());
            }
            int idx = type.indexOf(58);
            String typeNamespaceURI = null;
            if (idx >= 0) {
                String prefix = type.substring(0, idx);
                type = type.substring(idx + 1);
                typeNamespaceURI = this._namespaceHandling.getNamespaceURI(prefix);
            }
            XMLClassDescriptor classDesc = null;
            try {
                classDesc = this.getInternalContext().getXMLClassDescriptorResolver().resolveByXMLName(type, typeNamespaceURI, this._loader);
                if (classDesc != null) {
                    return classDesc.getJavaClass().getName();
                }
                String className = this.getJavaNaming().toJavaClassName(type);
                Object adjClassName = className;
                String mappedPackage = this.getMappedPackage(typeNamespaceURI);
                if (mappedPackage != null && mappedPackage.length() > 0) {
                    adjClassName = mappedPackage + "." + className;
                }
                if ((classDesc = this.getInternalContext().getXMLClassDescriptorResolver().resolve((String)adjClassName, this._loader)) != null) {
                    return classDesc.getJavaClass().getName();
                }
                if (StringUtils.isNotEmpty((CharSequence)currentPackage)) {
                    adjClassName = currentPackage + "." + className;
                }
                if ((classDesc = this.getInternalContext().getXMLClassDescriptorResolver().resolve((String)adjClassName, this._loader)) != null) {
                    return classDesc.getJavaClass().getName();
                }
                classDesc = this.getInternalContext().getXMLClassDescriptorResolver().resolve(type, this._loader);
                if (classDesc != null) {
                    return classDesc.getJavaClass().getName();
                }
            }
            catch (ResolverException rx) {
                throw new SAXException(rx);
            }
        }
        return null;
    }

    private String getMappedPackage(String namespace) {
        return this._namespaceHandling.getMappedPackage(namespace);
    }

    void processAttributes(AttributeSet atts, XMLClassDescriptor classDesc) throws SAXException {
        Comparable<StringBuilder> fullAttributePath;
        XMLFieldDescriptor[] descriptors;
        if (atts == null || atts.getSize() == 0) {
            if (classDesc != null) {
                XMLFieldDescriptor[] descriptors2 = classDesc.getAttributeDescriptors();
                for (int i = 0; i < descriptors2.length; ++i) {
                    XMLFieldDescriptor descriptor = descriptors2[i];
                    if (descriptor == null || !descriptor.isRequired() || !this.isValidating() && !LOG.isDebugEnabled()) continue;
                    String errorMsg = this._locator != null ? MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.attribute.missing.location"), classDesc.getXMLName(), descriptor.getXMLName(), this._locator.getLineNumber(), this._locator.getColumnNumber()) : MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.attribute.missing"), classDesc.getXMLName(), descriptor.getXMLName());
                    if (this.isValidating()) {
                        throw new SAXException(errorMsg);
                    }
                    LOG.debug((Object)errorMsg);
                }
            }
            return;
        }
        UnmarshalState state = this._stateStack.getLastState();
        Object object = state.getObject();
        if (classDesc == null && (classDesc = state.getClassDescriptor()) == null) {
            this.processWrapperAttributes(atts);
            return;
        }
        boolean[] processedAtts = new boolean[atts.getSize()];
        for (XMLFieldDescriptor descriptor : descriptors = classDesc.getAttributeDescriptors()) {
            int index;
            String name = descriptor.getXMLName();
            String namespace = descriptor.getNameSpaceURI();
            String path = descriptor.getLocationPath();
            fullAttributePath = new StringBuilder();
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                fullAttributePath.append(path).append('/');
            }
            fullAttributePath.append(name);
            if (!name.equals(fullAttributePath.toString())) {
                index = atts.getIndex(name, namespace);
                if (index < 0) continue;
                processedAtts[index] = true;
                continue;
            }
            index = atts.getIndex(name, namespace);
            String attValue = null;
            if (index >= 0) {
                attValue = atts.getValue(index);
                processedAtts[index] = true;
            }
            try {
                this.processAttribute(name, namespace, attValue, descriptor, classDesc, object);
            }
            catch (IllegalStateException ise) {
                String error = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.unable.add.attribute"), name, state.getClassDescriptor().getJavaClass().getName(), ise);
                throw new SAXException(error, ise);
            }
        }
        for (int i = 0; i < processedAtts.length; ++i) {
            XMLFieldDescriptor descriptor;
            if (processedAtts[i]) continue;
            String namespace = atts.getNamespace(i);
            String name = atts.getName(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(namespace)) {
                if (!"nil".equals(name)) continue;
                String value = atts.getValue(i);
                state.setNil("true".equals(value));
                continue;
            }
            if (name.startsWith("xml:")) {
                if (!LOG.isDebugEnabled()) continue;
                String debugMsg = MessageFormat.format(resourceBundle.getString("unmarshalHandler.log.debug.ignore.extra.attribute"), name, state.getClassDescriptor().getJavaClass().getName());
                LOG.debug((Object)debugMsg);
                continue;
            }
            descriptor = classDesc.getFieldDescriptor(name, namespace, NodeType.Attribute);
            if (descriptor == null) {
                Object path = state.getElementName();
                Integer parentStateIndex = this._stateStack.getFirstParentStateIndex();
                while (parentStateIndex >= 0) {
                    String tmpPath;
                    fullAttributePath = parentStateIndex;
                    Integer n = parentStateIndex = Integer.valueOf(parentStateIndex - 1);
                    UnmarshalState targetState = this._stateStack.peekAtState((Integer)fullAttributePath);
                    if (targetState.isWrapper()) {
                        path = targetState.getElementName() + "/" + (String)path;
                        continue;
                    }
                    classDesc = targetState.getClassDescriptor();
                    descriptor = classDesc.getFieldDescriptor(name, namespace, NodeType.Attribute);
                    if (descriptor != null && ((String)path).equals(StringUtils.defaultString((String)(tmpPath = descriptor.getLocationPath())))) {
                        this._stateStack.resetParentState();
                        break;
                    }
                    path = targetState.getElementName() + "/" + (String)path;
                    descriptor = null;
                }
            }
            if (descriptor == null) {
                if (!this._strictAttributes) continue;
                String errorMsg = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.strict.attribute.error"), name, state.getElementName());
                throw new SAXException(errorMsg);
            }
            try {
                this.processAttribute(name, namespace, atts.getValue(i), descriptor, classDesc, object);
                continue;
            }
            catch (IllegalStateException ise) {
                String errorMsg = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.unable.add.attribute"), name, state.getClassDescriptor().getJavaClass().getName(), ise);
                throw new SAXException(errorMsg, ise);
            }
        }
    }

    void processWrapperAttributes(AttributeSet atts) throws SAXException {
        UnmarshalState state = this._stateStack.getLastState();
        for (int i = 0; i < atts.getSize(); ++i) {
            String name = atts.getName(i);
            String namespace = atts.getNamespace(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(namespace)) continue;
            XMLFieldDescriptor descriptor = null;
            XMLClassDescriptor classDesc = null;
            Object path = state.getElementName();
            UnmarshalState targetState = null;
            while (this._stateStack.hasAnotherParentState()) {
                targetState = this._stateStack.removeParentState();
                if (targetState.isWrapper()) {
                    path = targetState.getElementName() + "/" + (String)path;
                    continue;
                }
                classDesc = targetState.getClassDescriptor();
                XMLFieldDescriptor[] descriptors = classDesc.getAttributeDescriptors();
                boolean found = false;
                for (int a = 0; a < descriptors.length; ++a) {
                    String tmpPath;
                    descriptor = descriptors[a];
                    if (descriptor == null || !descriptor.matches(name) || !((String)path).equals(StringUtils.defaultString((String)(tmpPath = descriptor.getLocationPath())))) continue;
                    found = true;
                    break;
                }
                if (found) {
                    this._stateStack.resetParentState();
                    break;
                }
                path = targetState.getElementName() + "/" + (String)path;
                descriptor = null;
            }
            if (descriptor == null) continue;
            try {
                this.processAttribute(name, namespace, atts.getValue(i), descriptor, classDesc, targetState.getObject());
                continue;
            }
            catch (IllegalStateException ise) {
                String errorMsg = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.unable.add.attribute"), name, state.getClassDescriptor().getJavaClass().getName(), ise);
                throw new SAXException(errorMsg, ise);
            }
        }
    }

    private void processAttribute(String attName, String attNamespace, String attValue, XMLFieldDescriptor descriptor, XMLClassDescriptor classDesc, Object parent) throws SAXException {
        FieldHandler handler;
        while (descriptor.isContainer()) {
            handler = descriptor.getHandler();
            Object containerObject = handler.getValue(parent);
            if (containerObject == null) {
                containerObject = handler.newInstance(parent);
                handler.setValue(parent, containerObject);
            }
            ClassDescriptor containerClassDesc = ((XMLFieldDescriptorImpl)descriptor).getClassDescriptor();
            descriptor = ((XMLClassDescriptor)containerClassDesc).getFieldDescriptor(attName, attNamespace, NodeType.Attribute);
            parent = containerObject;
        }
        if (attValue == null) {
            if (descriptor.isRequired() && this.isValidating()) {
                String errorMsg = this._locator != null ? MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.attribute.missing.location"), classDesc.getXMLName(), attName, this._locator.getLineNumber(), this._locator.getColumnNumber()) : MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.attribute.missing"), classDesc.getXMLName(), attName);
                throw new SAXException(errorMsg);
            }
            return;
        }
        if (classDesc.getIdentity() == descriptor) {
            try {
                ((IDResolverImpl)this._idResolver).bind(attValue, parent, this.isValidating() && !this.getInternalContext().getLenientIdValidation());
            }
            catch (ValidationException e) {
                String errorMsg = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.duplicated.id"), attValue);
                throw new SAXException(errorMsg, e);
            }
            UnmarshalState state = this._stateStack.getLastState();
            state.setKey(attValue);
            this.resolveReferences(attValue, parent);
        } else if (descriptor.isReference()) {
            if (descriptor.isMultivalued()) {
                StringTokenizer st = new StringTokenizer(attValue);
                while (st.hasMoreTokens()) {
                    this.processIDREF(st.nextToken(), descriptor, parent);
                }
            } else {
                this.processIDREF(attValue, descriptor, parent);
            }
            return;
        }
        if (descriptor.isConstructorArgument()) {
            return;
        }
        handler = descriptor.getHandler();
        if (handler == null) {
            return;
        }
        Class type = descriptor.getFieldType();
        String valueType = descriptor.getSchemaType();
        boolean isPrimative = UnmarshalHandler.isPrimitive(type);
        boolean isQName = StringUtils.equals((CharSequence)valueType, (CharSequence)"QName");
        boolean isByteArray = false;
        if (type.isArray()) {
            boolean bl = isByteArray = type.getComponentType() == Byte.TYPE;
        }
        if (descriptor.isMultivalued()) {
            StringTokenizer attrValueTokenizer = new StringTokenizer(attValue);
            while (attrValueTokenizer.hasMoreTokens()) {
                attValue = attrValueTokenizer.nextToken();
                this.setAttributeValueOnObject(attValue, descriptor, parent, handler, type, isPrimative, isQName, isByteArray);
            }
        } else {
            this.setAttributeValueOnObject(attValue, descriptor, parent, handler, type, isPrimative, isQName, isByteArray);
        }
    }

    private void setAttributeValueOnObject(String attValue, XMLFieldDescriptor descriptor, Object parent, FieldHandler handler, Class<?> type, boolean isPrimitive, boolean isQName, boolean isByteArray) throws SAXException {
        Object value = attValue;
        if (isPrimitive) {
            value = this.toPrimitiveObject(type, attValue, descriptor);
        }
        if (isByteArray) {
            value = attValue == null ? (Object)new byte[0] : ("hexBinary".equals(descriptor.getComponentType()) ? (Object)HexDecoder.decode(attValue) : (Object)Base64Decoder.decode(attValue));
        }
        if (isQName) {
            value = this._namespaceHandling.resolveNamespace(value);
        }
        handler.setValue(parent, value);
    }

    Arguments processConstructorArgs(AttributeSet atts, XMLClassDescriptor classDesc) throws SAXException {
        XMLFieldDescriptor[] descriptors;
        if (classDesc == null) {
            return new Arguments();
        }
        int count = 0;
        for (XMLFieldDescriptor fieldDescriptor : descriptors = classDesc.getAttributeDescriptors()) {
            if (fieldDescriptor == null || !fieldDescriptor.isConstructorArgument()) continue;
            ++count;
        }
        Arguments args = new Arguments();
        if (count == 0) {
            return args;
        }
        args.setValues(new Object[count]);
        args.setTypes(new Class[count]);
        for (XMLFieldDescriptor descriptor : descriptors) {
            if (descriptor == null || !descriptor.isConstructorArgument()) continue;
            int argIndex = descriptor.getConstructorArgumentIndex();
            if (argIndex >= count) {
                String errorMsg = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.index.out.of.bound"), argIndex);
                throw new SAXException(errorMsg);
            }
            args.setType(argIndex, descriptor.getFieldType());
            String name = descriptor.getXMLName();
            String namespace = descriptor.getNameSpaceURI();
            int index = atts.getIndex(name, namespace);
            if (index >= 0) {
                Object value = atts.getValue(index);
                value = UnmarshalHandler.isPrimitive(args.getType(argIndex)) ? this.toPrimitiveObject(args.getType(argIndex), (String)value, descriptor) : this.convertToEnumObject(descriptor, value);
                String valueType = descriptor.getSchemaType();
                if (StringUtils.equals((CharSequence)valueType, (CharSequence)"QName")) {
                    value = this._namespaceHandling.resolveNamespace(value);
                }
                args.setValue(argIndex, value);
                continue;
            }
            if (UnmarshalHandler.isPrimitive(args.getType(argIndex))) {
                args.setValue(argIndex, this.toPrimitiveObject(args.getType(argIndex), null, descriptor));
                continue;
            }
            args.setValue(argIndex, null);
        }
        return args;
    }

    private Object convertToEnumObject(XMLFieldDescriptor descriptor, Object value) {
        Class fieldType = descriptor.getFieldType();
        try {
            Class<?> returnType;
            Method valueOfMethod = fieldType.getMethod("valueOf", String.class);
            if (valueOfMethod != null && Modifier.isStatic(valueOfMethod.getModifiers()) && (returnType = valueOfMethod.getReturnType()).isAssignableFrom(fieldType)) {
                Object enumObject;
                value = enumObject = valueOfMethod.invoke(null, value);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return value;
    }

    boolean processIDREF(String idRef, XMLFieldDescriptor descriptor, Object parent) {
        Object value = this._idResolver.resolve(idRef);
        if (value == null) {
            this.addReference(idRef, parent, descriptor);
        } else {
            FieldHandler handler = descriptor.getHandler();
            if (handler != null) {
                handler.setValue(parent, value);
            }
        }
        return value != null;
    }

    private XMLClassDescriptor getClassDescriptor(String className) throws SAXException {
        Class<?> type = null;
        try {
            type = this._loader != null ? this._loader.loadClass(className) : Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        return this.getClassDescriptor(type);
    }

    XMLClassDescriptor getClassDescriptor(Class<?> cls) throws SAXException {
        if (cls == null) {
            return null;
        }
        if (cls == String.class) {
            return STRING_DESCRIPTOR;
        }
        if (cls.isArray()) {
            return null;
        }
        if (UnmarshalHandler.isPrimitive(cls)) {
            return null;
        }
        XMLClassDescriptor classDesc = null;
        try {
            InternalContext ctx = this.getInternalContext();
            classDesc = (XMLClassDescriptor)ctx.getXMLClassDescriptorResolver().resolve(cls);
        }
        catch (ResolverException resolverException) {
            // empty catch block
        }
        if (classDesc != null) {
            return new MarshalFramework.InternalXMLClassDescriptor(this, classDesc);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(ERROR_DID_NOT_FIND_CLASSDESCRIPTOR + cls.getName()));
        }
        return classDesc;
    }

    XMLClassDescriptor getClassDescriptor(String className, ClassLoader loader) throws SAXException {
        XMLClassDescriptor classDesc = null;
        try {
            classDesc = this.getInternalContext().getXMLClassDescriptorResolver().resolve(className, loader);
        }
        catch (ResolverException rx) {
            throw new SAXException(rx);
        }
        if (classDesc != null) {
            return new MarshalFramework.InternalXMLClassDescriptor(this, classDesc);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(ERROR_DID_NOT_FIND_CLASSDESCRIPTOR + className));
        }
        return classDesc;
    }

    XMLClassDescriptor resolveByXMLName(String name, String namespace, ClassLoader loader) throws SAXException {
        try {
            return this.getInternalContext().getXMLClassDescriptorResolver().resolveByXMLName(name, namespace, loader);
        }
        catch (ResolverException rx) {
            throw new SAXException(rx);
        }
    }

    String getJavaPackage(Class<?> type) {
        if (type == null) {
            return null;
        }
        String pkg = this._javaPackages.get(type);
        if (pkg == null) {
            pkg = type.getName();
            int idx = pkg.lastIndexOf(46);
            pkg = idx > 0 ? pkg.substring(0, idx) : "";
            this._javaPackages.put(type, pkg);
        }
        return pkg;
    }

    String className(Class<?> type) {
        if (type.isArray()) {
            return this.className(type.getComponentType()) + "[]";
        }
        return type.getName();
    }

    static boolean isWhitespace(CharSequence sb) {
        block3: for (int i = 0; i < sb.length(); ++i) {
            char ch = sb.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    Class<?> loadClass(String className, ClassLoader loader) throws ClassNotFoundException {
        if (loader != null) {
            return loader.loadClass(className);
        }
        if (this._loader != null) {
            return this._loader.loadClass(className);
        }
        return Class.forName(className);
    }

    private void resolveReferences(String id, Object value) throws SAXException {
        if (id == null || value == null) {
            return;
        }
        if (this._resolveTable == null) {
            return;
        }
        for (ReferenceInfo refInfo = this._resolveTable.remove(id); refInfo != null; refInfo = refInfo.getNext()) {
            try {
                FieldHandler handler = refInfo.getDescriptor().getHandler();
                if (handler != null) {
                    handler.setValue(refInfo.getTarget(), value);
                }
                if (!(refInfo.getTarget() instanceof MapItem)) continue;
                this.resolveReferences(refInfo.getTarget().toString(), refInfo.getTarget());
                continue;
            }
            catch (IllegalStateException ise) {
                String errorMsg = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.resolving.idRef"), id, ise.toString());
                throw new SAXException(errorMsg, ise);
            }
        }
    }

    Object toPrimitiveObject(Class<?> type, String value, XMLFieldDescriptor fieldDesc) throws SAXException {
        try {
            return UnmarshalHandler.toPrimitiveObject(type, value);
        }
        catch (Exception ex) {
            UnmarshalState state = this._stateStack.getLastState();
            if (state != null && state.getObject() != null) {
                String errorMsg = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.unmarshal.field.of.class"), fieldDesc.getFieldName(), state.getObject().getClass().getName());
                throw new SAXException(errorMsg, ex);
            }
            String errorMsg = MessageFormat.format(resourceBundle.getString("unmarshalHandler.error.unmarshal.field"), fieldDesc.getFieldName());
            throw new SAXException(errorMsg, ex);
        }
    }

    public static Object toPrimitiveObject(Class<?> type, String value) {
        return PrimitiveObjectFactory.getInstance().getObject(type, value);
    }

    public ObjectFactory getObjectFactory() {
        return this._objectFactory;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this._objectFactory = objectFactory;
    }

    public UnmarshalStateStack getStateStack() {
        return this._stateStack;
    }

    public UnmarshalState getTopState() {
        return this._topState;
    }

    public StrictElementHandler getStrictElementHandler() {
        return this._strictElementHandler;
    }

    public NamespaceHandling getNamespaceHandling() {
        return this._namespaceHandling;
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public AnyNodeUnmarshalHandler getAnyNodeHandler() {
        return this._anyNodeHandler;
    }

    public UnmarshalListenerDelegate getDelegateUnmarshalListener() {
        return this._delegateUnmarshalListener;
    }

    public boolean isReuseObjects() {
        return this._reuseObjects;
    }

    public Hashtable<String, ReferenceInfo> getResolveTable() {
        return this._resolveTable;
    }

    public AnyNode getAnyNode() {
        return this._node;
    }

    public void setAnyNode(AnyNode node) {
        this._node = node;
    }

    public boolean isClearCollections() {
        return this._clearCollections;
    }

    public static class ArrayHandler {
        Class<?> _componentType = null;
        ArrayList<Object> _items = null;

        ArrayHandler(Class<?> componentType) {
            if (componentType == null) {
                String errMsg = resourceBundle.getString("unmarshalHandler.error.componentType.null");
                throw new IllegalArgumentException(errMsg);
            }
            this._componentType = componentType;
            this._items = new ArrayList();
        }

        public void addObject(Object obj) {
            if (obj == null) {
                return;
            }
            this._items.add(obj);
        }

        public Object getObject() {
            int size = this._items.size();
            Object array = Array.newInstance(this._componentType, size);
            for (int i = 0; i < size; ++i) {
                Array.set(array, i, this._items.get(i));
            }
            return array;
        }

        public Class<?> componentType() {
            return this._componentType;
        }
    }

    class Arguments {
        private Object[] _values = null;
        private Class<?>[] _types = null;

        Arguments() {
        }

        public int size() {
            if (this._values == null) {
                return 0;
            }
            return this._values.length;
        }

        public Class<?>[] getTypes() {
            return this._types;
        }

        public Object[] getValues() {
            return this._values;
        }

        public Class<?> getType(int index) {
            return this._types[index];
        }

        public void setValues(Object[] values) {
            this._values = values;
        }

        public void setValue(int index, Object value) {
            this._values[index] = value;
        }

        public void setTypes(Class<?>[] types) {
            this._types = types;
        }

        public void setType(int index, Class<?> type) {
            this._types[index] = type;
        }
    }
}

