/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.toolbox;

import diva.canvas.AbstractFigure;
import diva.canvas.CanvasUtilities;
import diva.canvas.interactor.ShapedFigure;
import diva.util.java2d.ShapeUtilities;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class BasicFigure
extends AbstractFigure
implements ShapedFigure {
    private boolean _centered = true;
    private float[] _dashArray = null;
    private Composite _composite = AlphaComposite.SrcOver;
    private float _lineWidth = 1.0f;
    private Shape _shape;
    private Paint _fillPaint;
    private Stroke _stroke;
    private Paint _strokePaint;
    private AffineTransform _transform = new AffineTransform();

    public BasicFigure(Shape shape) {
        this(shape, null, 1.0f);
    }

    public BasicFigure(Shape shape, int lineWidth) {
        this(shape, null, lineWidth);
    }

    public BasicFigure(Shape shape, float lineWidth) {
        this(shape, null, lineWidth);
    }

    public BasicFigure(Shape shape, Paint fill) {
        this(shape, fill, 1.0f);
    }

    public BasicFigure(Shape shape, Paint fill, float lineWidth) {
        this._shape = ShapeUtilities.cloneShape(shape);
        this._fillPaint = fill;
        this._stroke = ShapeUtilities.getStroke(lineWidth);
        this._strokePaint = Color.black;
    }

    public Rectangle2D getBounds() {
        if (this._stroke == null) {
            return this._shape.getBounds2D();
        }
        return ShapeUtilities.computeStrokedBounds(this._shape, this._stroke);
    }

    public Composite getComposite() {
        return this._composite;
    }

    public float[] getDashArray() {
        if (this._stroke instanceof BasicStroke) {
            return ((BasicStroke)this._stroke).getDashArray();
        }
        return null;
    }

    public Paint getFillPaint() {
        return this._fillPaint;
    }

    public float getLineWidth() {
        if (this._stroke instanceof BasicStroke) {
            return ((BasicStroke)this._stroke).getLineWidth();
        }
        return 1.0f;
    }

    public Point2D getOrigin() {
        if (this._centered) {
            return super.getOrigin();
        }
        Point2D.Double point = new Point2D.Double(0.0, 0.0);
        this._transform.transform(point, point);
        return point;
    }

    public Shape getShape() {
        return this._shape;
    }

    public Paint getStrokePaint() {
        return this._strokePaint;
    }

    public boolean hit(Rectangle2D r) {
        if (!this.isVisible()) {
            return false;
        }
        boolean hit = false;
        if (this._fillPaint != null) {
            hit = this._shape.intersects(r);
        }
        if (!hit && this._stroke != null && this._strokePaint != null) {
            hit = hit || ShapeUtilities.intersectsOutline(r, this._shape);
        }
        return hit;
    }

    public boolean isCentered() {
        return this._centered;
    }

    public void paint(Graphics2D g) {
        if (!this.isVisible()) {
            return;
        }
        if (this._fillPaint != null) {
            g.setPaint(this._fillPaint);
            g.setComposite(this._composite);
            g.fill(this._shape);
        }
        if (this._stroke != null && this._strokePaint != null) {
            g.setStroke(this._stroke);
            g.setPaint(this._strokePaint);
            g.draw(this._shape);
        }
    }

    public void setCentered(boolean centered) {
        this.repaint();
        Point2D point = this.getOrigin();
        this._centered = centered;
        CanvasUtilities.translateTo(this, point.getX(), point.getY());
    }

    public void setComposite(AlphaComposite c) {
        this._composite = c;
        this.repaint();
    }

    public void setDashArray(float[] dashArray) {
        this.repaint();
        this._dashArray = dashArray;
        this._stroke = this._stroke instanceof BasicStroke ? new BasicStroke(((BasicStroke)this._stroke).getLineWidth(), ((BasicStroke)this._stroke).getEndCap(), ((BasicStroke)this._stroke).getLineJoin(), ((BasicStroke)this._stroke).getMiterLimit(), dashArray, 0.0f) : new BasicStroke(this._lineWidth, 2, 0, 10.0f, dashArray, 0.0f);
        this.repaint();
    }

    public void setFillPaint(Paint p) {
        this.repaint();
        this._fillPaint = p;
        this.repaint();
    }

    public void setLineWidth(float lineWidth) {
        this.repaint();
        this._lineWidth = lineWidth;
        if (this._stroke instanceof BasicStroke) {
            this._stroke = new BasicStroke(lineWidth, ((BasicStroke)this._stroke).getEndCap(), ((BasicStroke)this._stroke).getLineJoin(), ((BasicStroke)this._stroke).getMiterLimit(), ((BasicStroke)this._stroke).getDashArray(), 0.0f);
        } else {
            new BasicStroke(lineWidth, 2, 0, 10.0f, this._dashArray, 0.0f);
        }
        this.repaint();
    }

    public void setPrototypeShape(Shape s) {
        this.repaint();
        this._shape = this._transform.createTransformedShape(s);
        this.repaint();
    }

    public void setShape(Shape s) {
        this.repaint();
        this._shape = s;
        this.repaint();
    }

    public void setStrokePaint(Paint p) {
        this._strokePaint = p;
        this.repaint();
    }

    public void setStroke(Stroke s) {
        this.repaint();
        this._stroke = s;
        this.repaint();
    }

    public void transform(AffineTransform at) {
        this.repaint();
        this._transform.preConcatenate(at);
        this._shape = ShapeUtilities.transformModify(this._shape, at);
        this.repaint();
    }
}

