/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.interactor;

import diva.canvas.CanvasUtilities;
import diva.canvas.DamageRegion;
import diva.canvas.Figure;
import diva.canvas.FigureDecorator;
import diva.canvas.event.MouseFilter;
import diva.canvas.interactor.BasicGrabHandleFactory;
import diva.canvas.interactor.DragInteractor;
import diva.canvas.interactor.GrabHandle;
import diva.canvas.interactor.GrabHandleFactory;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class Manipulator
extends FigureDecorator {
    private GrabHandleFactory _factory = new BasicGrabHandleFactory();
    private ArrayList _grabHandles = new ArrayList();
    private DragInteractor _handleInteractor = new DragInteractor();
    private boolean _repainting = false;

    public void addGrabHandle(GrabHandle gh) {
        this._grabHandles.add(gh);
    }

    public void clearGrabHandles() {
        this._grabHandles.clear();
    }

    public Rectangle2D getBounds() {
        Rectangle2D bounds = this.getChild().getBounds();
        if (this._grabHandles.size() > 0) {
            bounds = bounds.createUnion(CanvasUtilities.computeCompositeBounds(this._grabHandles.iterator()));
        }
        return bounds;
    }

    public GrabHandleFactory getGrabHandleFactory() {
        return this._factory;
    }

    public DragInteractor getHandleInteractor() {
        return this._handleInteractor;
    }

    public boolean isRepainting() {
        return this._repainting;
    }

    public void paint(Graphics2D g) {
        if (this.getChild() == null) {
            return;
        }
        this.getChild().paint(g);
        for (GrabHandle h : this._grabHandles) {
            h.paint(g);
        }
    }

    public Figure pick(Rectangle2D r) {
        if (this.getChild() == null) {
            return null;
        }
        for (GrabHandle h : this._grabHandles) {
            if (!h.intersects(r)) continue;
            return h;
        }
        if (this.getChild().hit(r)) {
            return this.getChild();
        }
        return null;
    }

    public void removeGrabHandle(GrabHandle gh) {
        this._grabHandles.remove(gh);
    }

    public void repaint(DamageRegion d) {
        if (this.isRepainting()) {
            return;
        }
        this.repaint();
    }

    public abstract void refresh();

    public void relocateGrabHandles() {
        Iterator i = this._grabHandles.iterator();
        while (i.hasNext()) {
            ((GrabHandle)i.next()).relocate();
        }
    }

    public void repaint() {
        DamageRegion d = DamageRegion.createDamageRegion(this.getTransformContext(), this.getBounds());
        this.refresh();
        this.relocateGrabHandles();
        d.extend(this.getBounds());
        if (this.getParent() != null) {
            this.getParent().repaint(d);
        }
    }

    public void repaintAlready() {
        DamageRegion d = DamageRegion.createDamageRegion(this.getTransformContext(), this.getBounds());
        this.relocateGrabHandles();
        d.extend(this.getBounds());
        if (this.getParent() != null) {
            this.getParent().repaint(d);
        }
    }

    public void setGrabHandleFactory(GrabHandleFactory factory) {
        this._factory = factory;
    }

    public void setHandleFilter(MouseFilter filter) {
        this._handleInteractor.setMouseFilter(filter);
    }

    public void setHandleInteractor(DragInteractor interactor) {
        this._handleInteractor = interactor;
    }

    public void setRepainting(boolean repainting) {
        this._repainting = repainting;
    }
}

