/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.event;

import java.awt.event.MouseEvent;

public class MouseFilter {
    public static final MouseFilter defaultFilter = new MouseFilter(1);
    public static final MouseFilter selectionFilter = new MouseFilter(1);
    public static final MouseFilter alternateSelectionFilter = new MouseFilter(1, 1);
    private int _buttonMask = 28;
    private int _modifierMask = 7;
    private int _modifierFlags = 0;
    private int _pressNumber = -1;

    public MouseFilter(int button) {
        if (button <= 3) {
            switch (button) {
                case 1: {
                    button = 16;
                    break;
                }
                case 2: {
                    button = 8;
                    break;
                }
                case 3: {
                    button = 4;
                }
            }
        }
        this._buttonMask = button;
    }

    public MouseFilter(int button, int modifiers) {
        this(button);
        this._modifierFlags = modifiers;
    }

    public MouseFilter(int button, int modifiers, int mask) {
        this(button);
        this._modifierFlags = modifiers;
        this._modifierMask = mask;
    }

    public MouseFilter(int button, int modifiers, int mask, int pressNumber) {
        this(button, modifiers, mask);
        this._pressNumber = pressNumber;
    }

    public boolean accept(MouseEvent event) {
        if (this._pressNumber != -1 && event.getClickCount() != this._pressNumber) {
            return false;
        }
        int m = event.getModifiers();
        boolean val = (m & this._buttonMask) != 0 && this._modifierFlags == (m & this._modifierMask);
        return val;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(super.toString() + "; Button " + MouseEvent.getMouseModifiersText(this._buttonMask) + "; Modifiers " + MouseEvent.getMouseModifiersText(this._modifierFlags) + "; Modifier mask " + MouseEvent.getMouseModifiersText(this._modifierMask) + "; Press Number " + this._pressNumber);
        return result.toString();
    }
}

