/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging.settings;

import com.cosylab.logging.engine.ExactFilter;
import com.cosylab.logging.engine.Filter;
import com.cosylab.logging.engine.InvalidFilterConstraintException;
import com.cosylab.logging.engine.MinMaxFilter;
import com.cosylab.logging.engine.log.LogTypeHelper;
import com.cosylab.logging.settings.FilterParameterException;
import com.cosylab.logging.settings.FilterParameterPanel;
import com.cosylab.logging.settings.LogTypeRenderer;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class FilterTypePanel
extends FilterParameterPanel
implements ItemListener {
    protected JCheckBox minimumCheck;
    protected JCheckBox maximumCheck;
    protected JCheckBox exactCheck;
    private JCheckBox notCheck;
    private JComboBox minimum;
    private JComboBox maximum;
    private JComboBox exact;
    public LogTypeRenderer rendererMin;
    private LogTypeRenderer rendererMax;
    private LogTypeRenderer rendererExact;
    ImageIcon[] icons;

    @Override
    public void createComponents() {
        this.rendererMin = new LogTypeRenderer();
        this.rendererMax = new LogTypeRenderer();
        this.rendererExact = new LogTypeRenderer();
        JPanel panelTop = new JPanel(new GridBagLayout());
        this.add((Component)panelTop, this.newConstraints(0, 4, 4, 4, 4));
        this.notCheck = new JCheckBox("Discard entries matching this filter");
        this.notCheck.setToolTipText("Keep/discard entries matching this filter");
        panelTop.add((Component)this.notCheck, this.newConstraints(0, 4, 4, 4, 4));
        this.minimumCheck = new JCheckBox("Minimum value");
        this.minimumCheck.addItemListener(this);
        panelTop.add((Component)this.minimumCheck, this.newConstraints(1, 4, 0, 0, 0));
        LogTypeHelper[] logTypes = LogTypeHelper.values();
        this.minimum = new JComboBox<LogTypeHelper>(logTypes);
        this.minimum.setSelectedIndex(0);
        this.minimum.setEditable(false);
        this.minimum.setMaximumRowCount(logTypes.length);
        this.minimum.setRenderer(this.rendererMin);
        panelTop.add((Component)this.minimum, this.newConstraints(2, 0, 0, 4, 0));
        this.maximumCheck = new JCheckBox("Maximum value");
        this.maximumCheck.addItemListener(this);
        panelTop.add((Component)this.maximumCheck, this.newConstraints(3, 4, 0, 0, 0));
        this.maximum = new JComboBox<LogTypeHelper>(logTypes);
        this.maximum.setSelectedIndex(0);
        this.maximum.setEditable(false);
        this.maximum.setMaximumRowCount(logTypes.length);
        this.maximum.setRenderer(this.rendererMax);
        panelTop.add((Component)this.maximum, this.newConstraints(4, 0, 0, 4, 0));
        JPanel panelBottom = new JPanel(new GridBagLayout());
        this.add((Component)panelBottom, this.newConstraints(1, 4, 4, 4, 4));
        this.exactCheck = new JCheckBox("Exact value");
        this.exactCheck.addItemListener(this);
        panelBottom.add((Component)this.exactCheck, this.newConstraints(0, 4, 0, 0, 0));
        this.exact = new JComboBox<LogTypeHelper>(logTypes);
        this.exact.setSelectedIndex(0);
        this.exact.setEditable(false);
        this.exact.setMaximumRowCount(logTypes.length);
        this.exact.setRenderer(this.rendererExact);
        panelBottom.add((Component)this.exact, this.newConstraints(1, 0, 0, 4, 0));
    }

    @Override
    public Filter getFilter() throws FilterParameterException {
        boolean bmin = this.minimumCheck.isSelected();
        boolean bmax = this.maximumCheck.isSelected();
        boolean bexact = this.exactCheck.isSelected();
        LogTypeHelper min = null;
        LogTypeHelper max = null;
        if (bexact) {
            try {
                return new ExactFilter(this.getFieldIndex(), this.isLethal(), (Comparable)((LogTypeHelper)this.exact.getSelectedItem()), this.notCheck.isSelected());
            }
            catch (InvalidFilterConstraintException e) {
                e.printStackTrace();
                throw new FilterParameterException(e.getMessage());
            }
        }
        if (bmin) {
            min = (LogTypeHelper)this.minimum.getSelectedItem();
        }
        if (bmax) {
            max = (LogTypeHelper)this.maximum.getSelectedItem();
        }
        if (min != null && max != null && min.compareTo((Enum)max) > -1) {
            throw new FilterParameterException("Minimum must be less than maximum");
        }
        try {
            return new MinMaxFilter(this.getFieldIndex(), this.isLethal(), (Comparable)min, (Comparable)max, this.notCheck.isSelected());
        }
        catch (InvalidFilterConstraintException e) {
            throw new FilterParameterException(e.getMessage());
        }
    }

    @Override
    public void setFilter(Filter f) {
        if (f == null) {
            return;
        }
        switch (f.getConstraint()) {
            case EXACT: {
                this.exactCheck.setSelected(true);
                this.exact.setSelectedIndex(((LogTypeHelper)((ExactFilter)f).getExact()).ordinal());
                break;
            }
            case MINIMUM: {
                this.minimumCheck.setSelected(true);
                this.minimum.setSelectedIndex(((LogTypeHelper)((MinMaxFilter)f).getMinimum()).ordinal());
                break;
            }
            case MAXIMUM: {
                this.maximumCheck.setSelected(true);
                this.maximum.setSelectedIndex(((LogTypeHelper)((MinMaxFilter)f).getMaximum()).ordinal());
                break;
            }
            case MINMAX: {
                this.minimumCheck.setSelected(true);
                this.minimum.setSelectedIndex(((LogTypeHelper)((MinMaxFilter)f).getMinimum()).ordinal());
                this.maximumCheck.setSelected(true);
                this.maximum.setSelectedIndex(((LogTypeHelper)((MinMaxFilter)f).getMaximum()).ordinal());
            }
        }
        this.notCheck.setSelected(f.notPolicyApplyed());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.exactCheck) {
                this.maximumCheck.setSelected(false);
                this.minimumCheck.setSelected(false);
            } else if (e.getSource() == this.minimumCheck || e.getSource() == this.maximumCheck) {
                this.exactCheck.setSelected(false);
            }
        }
    }
}

