/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging.search;

import com.cosylab.logging.LoggingClient;
import com.cosylab.logging.engine.log.LogField;
import com.cosylab.logging.search.SearchEngine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SearchDialog
extends JDialog {
    private JPanel jContentPane = null;
    private JPanel upperPanel = null;
    private JLabel findLbl = null;
    private JTextField findTF = null;
    private JPanel buttonPanel = null;
    private JButton findBtn = null;
    private JButton advancedBtn = null;
    private JButton doneBtn = null;
    private JPanel centerPanel = null;
    private JPanel optionPanel = null;
    private JPanel directionPanel = null;
    private JRadioButton forwardRB = null;
    private JRadioButton backwardRB = null;
    private JPanel searchTypePanel = null;
    private JCheckBox regExpCB = null;
    private JCheckBox caseSensitiveCB = null;
    private JPanel advancedPanel = null;
    private JPanel advBtnPanel = null;
    private JPanel findBtnPanel = null;
    private JPanel doneBtnPanel = null;
    private LoggingClient loggingClient;
    private JCheckBox[] columnToSearchIn = new JCheckBox[LogField.values().length];
    private JCheckBox additionalDataCB;
    private JCheckBox wholeWordCB = null;
    private SearchEngine searchEngine;

    public SearchDialog(LoggingClient mainWin) {
        this.loggingClient = mainWin;
        this.initialize();
        this.pack();
        this.searchEngine = new SearchEngine(mainWin.getLogEntryTable());
    }

    private void initialize() {
        this.setDefaultCloseOperation(1);
        this.setBounds(20, 35, 300, 200);
        this.setTitle("Find...");
        this.setContentPane(this.getJContentPane());
        this.initializeAdvancedPanel();
    }

    private void initializeAdvancedPanel() {
        this.advancedPanel.setLayout(new GridLayout(LogField.values().length + 1, 1, 5, 3));
        boolean[] visibeColsInMainWindow = this.loggingClient.getLogEntryTable().getVisibleColumns(true);
        for (int t = 0; t < LogField.values().length; ++t) {
            if (this.columnToSearchIn[t] == null) {
                this.columnToSearchIn[t] = new JCheckBox(LogField.values()[t].getName());
            }
            this.advancedPanel.add(this.columnToSearchIn[t]);
            this.columnToSearchIn[t].setVisible(true);
            this.columnToSearchIn[t].setSelected(visibeColsInMainWindow[t]);
            this.columnToSearchIn[t].setToolTipText("Search in " + LogField.values()[t].getName());
        }
        this.additionalDataCB = new JCheckBox("Additional data", false);
        this.advancedPanel.add(this.additionalDataCB);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            BorderLayout borderLayout4 = new BorderLayout();
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(borderLayout4);
            borderLayout4.setVgap(5);
            borderLayout4.setHgap(5);
            this.jContentPane.add((Component)this.getUpperPanel(), "North");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
            this.jContentPane.add((Component)this.getCenterPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getUpperPanel() {
        if (this.upperPanel == null) {
            this.findLbl = new JLabel();
            BorderLayout borderLayout1 = new BorderLayout();
            this.upperPanel = new JPanel();
            this.upperPanel.setLayout(borderLayout1);
            this.findLbl.setText("Find:");
            borderLayout1.setHgap(5);
            borderLayout1.setVgap(5);
            this.upperPanel.add((Component)this.findLbl, "West");
            this.upperPanel.add((Component)this.getFindTF(), "Center");
        }
        return this.upperPanel;
    }

    private JTextField getFindTF() {
        if (this.findTF == null) {
            this.findTF = new JTextField();
            this.findTF.setToolTipText("Insert here the string to find");
            this.findTF.setActionCommand(null);
            this.findTF.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand() != null && e.getActionCommand().length() > 0) {
                        SearchDialog.this.search();
                    }
                }
            });
        }
        return this.findTF;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new BorderLayout());
            this.buttonPanel.add((Component)this.getAdvBtnPanel(), "Center");
            this.buttonPanel.add((Component)this.getFindBtnPanel(), "West");
            this.buttonPanel.add((Component)this.getDoneBtnPanel(), "East");
        }
        return this.buttonPanel;
    }

    private JButton getFindBtn() {
        if (this.findBtn == null) {
            this.findBtn = new JButton();
            this.findBtn.setText("Find");
            this.findBtn.setToolTipText("Find the string");
            this.findBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchDialog.this.search();
                }
            });
        }
        return this.findBtn;
    }

    private JButton getAdvancedBtn() {
        if (this.advancedBtn == null) {
            this.advancedBtn = new JButton();
            this.advancedBtn.setText("Advanced >>");
            this.advancedBtn.setToolTipText("Switch to advanced/standard mode");
            this.advancedBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SearchDialog.this.advancedBtn.getText().compareTo("Advanced >>") == 0) {
                        SearchDialog.this.advancedBtn.setText("Standard <<");
                        SearchDialog.this.advancedPanel.setVisible(true);
                        SearchDialog.this.pack();
                    } else {
                        SearchDialog.this.advancedBtn.setText("Advanced >>");
                        SearchDialog.this.advancedPanel.setVisible(false);
                        SearchDialog.this.pack();
                    }
                }
            });
        }
        return this.advancedBtn;
    }

    private JButton getDoneBtn() {
        if (this.doneBtn == null) {
            this.doneBtn = new JButton();
            this.doneBtn.setText("Done");
            this.doneBtn.setToolTipText("Done");
            this.doneBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchDialog.this.setVisible(false);
                }
            });
        }
        return this.doneBtn;
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new BorderLayout());
            this.centerPanel.add((Component)this.getOptionPanel(), "North");
        }
        return this.centerPanel;
    }

    private JPanel getOptionPanel() {
        if (this.optionPanel == null) {
            this.optionPanel = new JPanel();
            this.optionPanel.setLayout(new BorderLayout());
            this.optionPanel.add((Component)this.getDirectionPanel(), "West");
            this.optionPanel.add((Component)this.getSearchTypePanel(), "East");
            this.optionPanel.add((Component)this.getAdvancedPanel(), "South");
        }
        return this.optionPanel;
    }

    private JPanel getDirectionPanel() {
        if (this.directionPanel == null) {
            GridLayout gridLayout2 = new GridLayout();
            this.directionPanel = new JPanel();
            this.directionPanel.setLayout(gridLayout2);
            this.directionPanel.setBorder(BorderFactory.createTitledBorder(null, "Direction", 0, 0, null, null));
            this.directionPanel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            gridLayout2.setRows(3);
            gridLayout2.setColumns(1);
            this.directionPanel.add((Component)this.getForwardRB(), null);
            this.directionPanel.add((Component)this.getBackwardRB(), null);
        }
        return this.directionPanel;
    }

    private JRadioButton getForwardRB() {
        if (this.forwardRB == null) {
            this.forwardRB = new JRadioButton();
            this.forwardRB.setText("Forward");
            this.forwardRB.setSelected(true);
            this.forwardRB.setToolTipText("Search forward");
            this.forwardRB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchDialog.this.backwardRB.setSelected(false);
                }
            });
        }
        return this.forwardRB;
    }

    private JRadioButton getBackwardRB() {
        if (this.backwardRB == null) {
            this.backwardRB = new JRadioButton();
            this.backwardRB.setText("Backward");
            this.backwardRB.setToolTipText("Search backward");
            this.backwardRB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchDialog.this.forwardRB.setSelected(false);
                }
            });
        }
        return this.backwardRB;
    }

    private JPanel getSearchTypePanel() {
        if (this.searchTypePanel == null) {
            GridLayout gridLayout3 = new GridLayout();
            this.searchTypePanel = new JPanel();
            this.searchTypePanel.setLayout(gridLayout3);
            this.searchTypePanel.setBorder(BorderFactory.createTitledBorder(null, "Options", 0, 0, null, null));
            gridLayout3.setRows(3);
            gridLayout3.setColumns(1);
            this.searchTypePanel.add((Component)this.getRegExpCB(), null);
            this.searchTypePanel.add((Component)this.getCaseSensitiveCB(), null);
            this.searchTypePanel.add((Component)this.getWholeWordCB(), null);
        }
        return this.searchTypePanel;
    }

    private JCheckBox getRegExpCB() {
        if (this.regExpCB == null) {
            this.regExpCB = new JCheckBox();
            this.regExpCB.setText("Regular expression");
            this.regExpCB.setToolTipText("Search a regular expression");
            this.regExpCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SearchDialog.this.wholeWordCB.setEnabled(!SearchDialog.this.regExpCB.isSelected());
                }
            });
        }
        return this.regExpCB;
    }

    private JCheckBox getCaseSensitiveCB() {
        if (this.caseSensitiveCB == null) {
            this.caseSensitiveCB = new JCheckBox();
            this.caseSensitiveCB.setText("Case sensitive");
            this.caseSensitiveCB.setToolTipText("Case sensitive");
        }
        return this.caseSensitiveCB;
    }

    private JPanel getAdvancedPanel() {
        if (this.advancedPanel == null) {
            this.advancedPanel = new JPanel();
            this.advancedPanel.setVisible(false);
            this.advancedPanel.setBorder(BorderFactory.createTitledBorder(null, "Search in these columns:", 0, 0, null, null));
        }
        return this.advancedPanel;
    }

    private JPanel getAdvBtnPanel() {
        if (this.advBtnPanel == null) {
            this.advBtnPanel = new JPanel();
            this.advBtnPanel.add((Component)this.getAdvancedBtn(), null);
        }
        return this.advBtnPanel;
    }

    private JPanel getFindBtnPanel() {
        if (this.findBtnPanel == null) {
            this.findBtnPanel = new JPanel();
            this.findBtnPanel.add((Component)this.getFindBtn(), null);
        }
        return this.findBtnPanel;
    }

    private JPanel getDoneBtnPanel() {
        if (this.doneBtnPanel == null) {
            this.doneBtnPanel = new JPanel();
            this.doneBtnPanel.add((Component)this.getDoneBtn(), null);
        }
        return this.doneBtnPanel;
    }

    private JCheckBox getWholeWordCB() {
        if (this.wholeWordCB == null) {
            this.wholeWordCB = new JCheckBox();
            this.wholeWordCB.setText("Whole Word");
            this.wholeWordCB.setToolTipText("Whole Word");
        }
        return this.wholeWordCB;
    }

    public void search() {
        if (this.loggingClient.getLogEntryTable().getRowCount() <= 0 || this.findTF.getText().length() <= 0) {
            JOptionPane.showMessageDialog(this, "Invalid search parameters or no logs in the main window", "Search error", 0);
            this.loggingClient.enableSearchNext(false);
            return;
        }
        this.loggingClient.enableSearchNext(true);
        int size = this.columnToSearchIn.length + 1;
        boolean[] cols = new boolean[size];
        for (int t = 0; t < size - 1; ++t) {
            cols[t] = this.columnToSearchIn[t].isSelected();
        }
        cols[size - 1] = this.additionalDataCB.isSelected();
        int row = -1;
        if (!this.regExpCB.isSelected()) {
            row = this.searchEngine.find(this.findTF.getText(), this.caseSensitiveCB.isSelected(), this.wholeWordCB.isSelected(), this.forwardRB.isSelected(), cols);
        } else {
            int flags = this.caseSensitiveCB.isSelected() ? 0 : 2;
            try {
                Pattern regexp = Pattern.compile(this.findTF.getText(), flags);
                row = this.searchEngine.find(regexp, this.forwardRB.isSelected(), cols);
            }
            catch (PatternSyntaxException pse) {
                System.err.println("Exception compiling the regular expression " + pse.getMessage());
                JOptionPane.showMessageDialog(this, this.findTF.getText() + " is not a valid regular expression", "Error compiling the regular expression", 0);
                this.loggingClient.enableSearchNext(false);
                return;
            }
        }
        if (row <= -1) {
            String msg = "<html>No log matching \"<I>" + this.findTF.getText() + "</I>\" found<BR>Search from ";
            msg = this.forwardRB.isSelected() ? msg + "beginning" : msg + "end";
            msg = msg + "?";
            int ret = JOptionPane.showConfirmDialog(this, msg, "No log found", 1);
            switch (ret) {
                case 0: {
                    row = this.forwardRB.isSelected() ? 0 : this.loggingClient.getLogEntryTable().getRowCount() - 1;
                    this.loggingClient.getLogEntryTable().changeSelection(row, 1, false, false);
                    this.search();
                    return;
                }
                case 1: {
                    return;
                }
                case 2: {
                    this.setVisible(false);
                    return;
                }
            }
            return;
        }
        this.loggingClient.getLogEntryTable().changeSelection(row, 1, false, false);
        this.loggingClient.getLogEntryTable().showColumn(row);
        this.loggingClient.showDetailedLogInfo();
    }

    @Override
    public void setVisible(boolean visible) {
        this.setLocationRelativeTo(this.loggingClient);
        this.pack();
        super.setVisible(visible);
        this.toFront();
    }
}

