/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.table.reduction;

import alma.acs.logging.table.reduction.Antennae;
import alma.acs.logging.table.reduction.ReductionRule;
import com.cosylab.logging.engine.log.ILogEntry;
import com.cosylab.logging.engine.log.LogEntry;
import com.cosylab.logging.engine.log.LogField;
import com.cosylab.logging.engine.log.LogTypeHelper;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class SourceAntennaRule
extends ReductionRule {
    private static final String reducedSource = "Several sources (see log details)";
    private static final String additionalDataName = "Source";
    private final boolean isReducible;
    private final Set<String> sourceObjects;
    private final String baseSourceMessage;
    private final String initialLogMessage;
    private final String initialAntenna;

    public SourceAntennaRule(ILogEntry initialLog) {
        super(initialLog);
        String src = initialLog.getField(LogField.SOURCEOBJECT) != null ? (String)initialLog.getField(LogField.SOURCEOBJECT) : "";
        StringBuilder source = new StringBuilder(src);
        this.initialAntenna = Antennae.matchAndReplaceAntenna(source, "\u0000\u0000\u0000\u0000");
        boolean bl = this.isReducible = this.initialAntenna != null;
        if (this.initialAntenna != null) {
            this.baseSourceMessage = source.toString();
            this.sourceObjects = new TreeSet<String>();
            this.sourceObjects.add(src);
            this.initialLogMessage = (String)initialLog.getField(LogField.LOGMESSAGE);
        } else {
            this.baseSourceMessage = null;
            this.sourceObjects = null;
            this.initialLogMessage = null;
        }
    }

    @Override
    public boolean isReducible() {
        return this.isReducible;
    }

    @Override
    public boolean applyRule(ILogEntry logToReduce) {
        if (!this.isReducible || logToReduce == null) {
            return false;
        }
        if (!this.initialLogMessage.equalsIgnoreCase((String)logToReduce.getField(LogField.LOGMESSAGE))) {
            return false;
        }
        String src = logToReduce.getField(LogField.SOURCEOBJECT) != null ? (String)logToReduce.getField(LogField.SOURCEOBJECT) : "";
        StringBuilder source = new StringBuilder(src);
        if (source.length() == 0) {
            return false;
        }
        String antenna = Antennae.matchAndReplaceAntenna(source, "\u0000\u0000\u0000\u0000");
        if (antenna == null || antenna.isEmpty()) {
            return false;
        }
        if (this.baseSourceMessage.equalsIgnoreCase(source.toString())) {
            this.sourceObjects.add(src);
            return true;
        }
        return false;
    }

    @Override
    public ILogEntry getReducedLog() {
        if (this.sourceObjects == null || this.sourceObjects.size() <= 1) {
            return this.initialLog;
        }
        Long milliseconds = (Long)this.initialLog.getField(LogField.TIMESTAMP);
        Integer entrytype = ((LogTypeHelper)this.initialLog.getField(LogField.ENTRYTYPE)).ordinal();
        String file = (String)this.initialLog.getField(LogField.FILE);
        Integer line = (Integer)this.initialLog.getField(LogField.LINE);
        String routine = (String)this.initialLog.getField(LogField.ROUTINE);
        String host = (String)this.initialLog.getField(LogField.HOST);
        String process = (String)this.initialLog.getField(LogField.PROCESS);
        String context = (String)this.initialLog.getField(LogField.CONTEXT);
        String thread = (String)this.initialLog.getField(LogField.THREAD);
        String logid = (String)this.initialLog.getField(LogField.LOGID);
        Integer priority = (Integer)this.initialLog.getField(LogField.PRIORITY);
        String uri = (String)this.initialLog.getField(LogField.URI);
        String stackid = (String)this.initialLog.getField(LogField.STACKID);
        Integer stacklevel = (Integer)this.initialLog.getField(LogField.STACKLEVEL);
        String logmessage = this.initialLogMessage;
        String srcObject = reducedSource;
        String audience = (String)this.initialLog.getField(LogField.AUDIENCE);
        String array = (String)this.initialLog.getField(LogField.ARRAY);
        String antenna = (String)this.initialLog.getField(LogField.ANTENNA);
        Vector<ILogEntry.AdditionalData> addDatas = this.initialLog.getAdditionalData();
        if (addDatas == null) {
            addDatas = new Vector<ILogEntry.AdditionalData>();
        }
        for (String ant : this.sourceObjects) {
            ILogEntry.AdditionalData ad = new ILogEntry.AdditionalData(additionalDataName, ant);
            addDatas.add(ad);
        }
        LogEntry ret = new LogEntry(milliseconds, entrytype, file, line, routine, host, process, context, thread, logid, priority, uri, stackid, stacklevel, logmessage, srcObject, audience, array, antenna, addDatas);
        return ret;
    }

    @Override
    public boolean isReducingLogs() {
        return this.sourceObjects.size() > 1;
    }
}

