/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.table;

import alma.acs.logging.table.LogTableDataModel;
import com.cosylab.logging.engine.Filter;
import com.cosylab.logging.engine.FiltersVector;
import com.cosylab.logging.engine.log.ILogEntry;
import com.cosylab.logging.engine.log.LogField;
import com.cosylab.logging.engine.log.LogTypeHelper;
import javax.swing.RowFilter;

public class LogTableRowFilter
extends RowFilter<LogTableDataModel, Integer> {
    private Filter[] filters = null;
    private LogTypeHelper logLevel = LogTypeHelper.TRACE;

    public LogTableRowFilter(FiltersVector filtersVector, LogTypeHelper logLevel) {
        this.buildTableFilters(filtersVector);
        this.logLevel = logLevel;
    }

    private void buildTableFilters(FiltersVector userFilters) {
        if (userFilters == null || userFilters.isEmpty()) {
            this.filters = null;
            return;
        }
        int[] activesIndexes = userFilters.getAppliedFiltersIndexes();
        if (activesIndexes != null && activesIndexes.length > 0) {
            this.filters = new Filter[activesIndexes.length];
            for (int t = 0; t < activesIndexes.length; ++t) {
                this.filters[t] = (Filter)userFilters.get(activesIndexes[t]);
            }
        }
    }

    @Override
    public boolean include(RowFilter.Entry<? extends LogTableDataModel, ? extends Integer> entry) {
        if (!this.checkLogLevel((LogTypeHelper)entry.getValue(LogField.ENTRYTYPE.ordinal() + 1))) {
            return false;
        }
        if (this.filters == null) {
            return true;
        }
        LogTableDataModel model = entry.getModel();
        ILogEntry log = model.getVisibleLogEntry(entry.getIdentifier());
        boolean ret = true;
        for (int t = 0; t < this.filters.length && ret; ++t) {
            ret = ret && this.filters[t].applyTo(log, false);
        }
        return ret;
    }

    private boolean checkLogLevel(LogTypeHelper level) {
        return level != null && level.ordinal() >= this.logLevel.ordinal();
    }
}

