/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.table;

import alma.acs.gui.util.threadsupport.EDTExecutor;
import alma.acs.logging.table.RowEntries;
import alma.acs.logging.table.reduction.LogProcessor;
import com.cosylab.logging.LoggingClient;
import com.cosylab.logging.client.cache.LogCache;
import com.cosylab.logging.client.cache.LogCacheException;
import com.cosylab.logging.engine.audience.Audience;
import com.cosylab.logging.engine.log.ILogEntry;
import com.cosylab.logging.engine.log.LogField;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class LogEntryTableModelBase
extends AbstractTableModel
implements Runnable {
    private volatile boolean terminateThread = false;
    private static final int UPDATE_INTERVAL = 2000;
    private static final int KEY_DELETION_INTERVAL = 60000;
    private final List<ILogEntry> rowsToAdd = Collections.synchronizedList(new Vector());
    private final LogProcessor logProcessor = new LogProcessor();
    protected LogCache allLogs;
    protected final RowEntries rows = new RowEntries();
    protected Thread tableUpdater;
    private final KeysDeleter keysDeleter = new KeysDeleter();
    private Thread keysDeleterThread = null;
    protected final LoggingClient loggingClient;
    private volatile boolean closed = false;
    private static final String htmlStartTAG = "<html>";
    private static final String htmlCloseTAG = "</html>";
    private static final String emptyString = "";
    private volatile int maxLog = 0;

    public LogEntryTableModelBase(LoggingClient client) throws Exception {
        if (client == null) {
            throw new IllegalArgumentException("Invalid null LoggingClient");
        }
        this.loggingClient = client;
        try {
            this.allLogs = new LogCache();
        }
        catch (LogCacheException lce) {
            System.err.println("Exception instantiating the cache: " + lce.getMessage());
            lce.printStackTrace(System.err);
            throw new Exception("Exception instantiating the cache: ", lce);
        }
    }

    public void start() {
        this.tableUpdater = new Thread((Runnable)this, "LogEntryTableModelBase.TableUpdaterThread");
        this.tableUpdater.setDaemon(true);
        this.tableUpdater.start();
        this.keysDeleterThread = new Thread((Runnable)this.keysDeleter, "LogEntryTableModelBase.KeysDeleter");
        this.keysDeleterThread.setDaemon(true);
        this.keysDeleterThread.start();
    }

    @Override
    public final int getColumnCount() {
        return LogField.values().length + 1;
    }

    public int numberOfUsedFiles() {
        return this.allLogs.getNumberOfCacheFiles();
    }

    public long usedDiskSpace() throws IOException {
        return this.allLogs.getFilesSize();
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 1: {
                try {
                    return new Date(this.allLogs.getLogTimestamp(this.rows.get(row)));
                }
                catch (Exception e) {
                    return null;
                }
            }
            case 2: {
                try {
                    return this.allLogs.getLogType(this.rows.get(row));
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        ILogEntry log = this.getVisibleLogEntry(row);
        if (log == null) {
            return null;
        }
        if (column == 0) {
            return log.hasDatas();
        }
        Object val = log.getField(LogField.values()[column - 1]);
        if (val == null || val.toString() == null || val.toString().isEmpty()) {
            return emptyString;
        }
        String ret = val.toString().replaceAll("<", "&lt;");
        ret = ret.replaceAll(">", "&gt;");
        ret = ret.replaceAll("\n", "<BR>");
        return htmlStartTAG + ret + htmlCloseTAG;
    }

    public ILogEntry getVisibleLogEntry(int row) {
        if (this.closed) {
            return null;
        }
        try {
            ILogEntry ret = this.allLogs.getLog(this.rows.get(row));
            return ret;
        }
        catch (LogCacheException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void clearAll() {
        EDTExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                LogEntryTableModelBase.this.rowsToAdd.clear();
                LogEntryTableModelBase.this.rows.clear();
                LogEntryTableModelBase.this.keysDeleter.invalidate();
                try {
                    LogEntryTableModelBase.this.allLogs.clear();
                }
                catch (Throwable t) {
                    System.err.println("Exception caught clearing the cache: " + t.getMessage());
                    t.printStackTrace(System.err);
                    JOptionPane.showInternalMessageDialog(LogEntryTableModelBase.this.loggingClient, "Error clearing the cache.", "Error clearing the cache", 0);
                }
                LogEntryTableModelBase.this.fireTableDataChanged();
            }
        });
    }

    public long totalLogNumber() {
        return this.rows.size();
    }

    public Calendar getTimeFrame() {
        return this.allLogs.getTimeFrame();
    }

    public Integer getLogKey(int index) {
        return this.rows.get(index);
    }

    public int findKeyPos(Integer key) {
        if (key == null) {
            throw new IllegalArgumentException("The key can't be null");
        }
        return this.rows.indexOf(key);
    }

    @Override
    public final String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return emptyString;
        }
        return --columnIndex >= 0 && columnIndex < LogField.values().length ? LogField.values()[columnIndex].getName() : emptyString;
    }

    @Override
    public final Class<?> getColumnClass(int column) {
        if (column == 0) {
            return Boolean.class;
        }
        int col = column - 1;
        if (col >= 0 && col < LogField.values().length) {
            return LogField.values()[col].getType();
        }
        return String.class;
    }

    public void replaceLog(final int pos, final ILogEntry newEntry) {
        EDTExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    LogEntryTableModelBase.this.allLogs.replaceLog(pos, newEntry);
                }
                catch (LogCacheException e) {
                    System.err.println("Error replacing log " + pos);
                    e.printStackTrace();
                }
            }
        });
    }

    public void close(boolean sync) {
        this.terminateThread = true;
        this.keysDeleter.close();
        this.closed = true;
        if (this.tableUpdater != null) {
            this.tableUpdater.interrupt();
            if (sync) {
                try {
                    this.tableUpdater.join(10000L);
                    if (this.tableUpdater.isAlive()) {
                        System.err.println("LogEntryTableModelBase.TableUpdater thread still alive!");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.clearAll();
        if (this.keysDeleterThread != null) {
            this.keysDeleterThread.interrupt();
            if (sync) {
                try {
                    this.keysDeleterThread.join(10000L);
                    if (this.keysDeleterThread.isAlive()) {
                        System.err.println("LogEntryTableModelBase.KeysDeleter thread still alive!");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void appendLog(ILogEntry log) {
        if (log == null) {
            throw new IllegalArgumentException("Can't append a null log to the table model");
        }
        if (!this.closed) {
            this.rowsToAdd.add(log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushLogs() {
        Vector<ILogEntry> temp;
        List<ILogEntry> list = this.rowsToAdd;
        synchronized (list) {
            if (this.rowsToAdd.isEmpty()) {
                return;
            }
            try {
                if (this.loggingClient.getEngine().getAudience().getInfo() == Audience.AudienceInfo.OPERATOR) {
                    this.logProcessor.reduce(this.rowsToAdd);
                }
            }
            catch (Throwable t) {
                System.err.println("Exception caught (" + t.getMessage() + ")while reducing logs: reduction disabled this time");
                t.printStackTrace(System.err);
            }
            temp = new Vector<ILogEntry>(this.rowsToAdd);
            this.rowsToAdd.clear();
        }
        try {
            EDTExecutor.instance().executeSync(new Runnable(){

                @Override
                public void run() {
                    for (int t = temp.size() - 1; t >= 0; --t) {
                        Integer key;
                        ILogEntry log = (ILogEntry)temp.get(t);
                        try {
                            key = LogEntryTableModelBase.this.allLogs.add(log);
                        }
                        catch (LogCacheException lce) {
                            System.err.println("Exception caught while inserting a new log entry in cache:");
                            System.err.println(lce.getLocalizedMessage());
                            lce.printStackTrace(System.err);
                            continue;
                        }
                        LogEntryTableModelBase.this.rows.add(key);
                    }
                    LogEntryTableModelBase.this.fireTableRowsInserted(0, temp.size() - 1);
                }
            });
        }
        catch (InvocationTargetException e) {
            System.out.println("!!! Exception: " + e.getMessage() + "; model size=" + this.rows.size());
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setMaxLog(int max) {
        if (max < 0) {
            throw new IllegalArgumentException("Impossible to set the max log to " + max);
        }
        this.maxLog = max;
    }

    private void removeExceedingLogs() {
        try {
            EDTExecutor.instance().executeSync(new Runnable(){

                @Override
                public void run() {
                    int sz = LogEntryTableModelBase.this.rows.size();
                    if (LogEntryTableModelBase.this.maxLog <= 0 || sz <= LogEntryTableModelBase.this.maxLog) {
                        return;
                    }
                    LogEntryTableModelBase.this.keysDeleter.scheduleForDeletion(LogEntryTableModelBase.this.rows.removeLastEntries(LogEntryTableModelBase.this.rows.size() - LogEntryTableModelBase.this.maxLog));
                    LogEntryTableModelBase.this.fireTableDataChanged();
                }
            });
        }
        catch (InvocationTargetException e) {
            System.out.println("!!! Exception: " + e.getMessage() + "; model size=" + this.rows.size());
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (!this.terminateThread) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                continue;
            }
            try {
                this.flushLogs();
            }
            catch (Throwable t) {
                System.err.println("Error in thread " + Thread.currentThread().getName() + ": " + t.getMessage());
                t.printStackTrace(System.err);
            }
            this.removeExceedingLogs();
        }
    }

    private class KeysDeleter
    implements Runnable {
        private volatile boolean closed = false;
        private final List<Integer> keysToDelete = Collections.synchronizedList(new ArrayList());

        private KeysDeleter() {
        }

        public void invalidate() {
            this.keysToDelete.clear();
        }

        public void scheduleForDeletion(Integer key) {
            if (key == null) {
                throw new IllegalArgumentException("Adding a null key is not allowed");
            }
            if (this.closed) {
                return;
            }
            this.keysToDelete.add(key);
        }

        public void scheduleForDeletion(List<Integer> keys) {
            if (keys == null) {
                throw new IllegalArgumentException("Adding a null key is not allowed");
            }
            if (this.closed) {
                return;
            }
            this.keysToDelete.addAll(keys);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.closed) {
                ArrayList<Integer> temp;
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException ie) {
                    continue;
                }
                if (this.keysToDelete.isEmpty()) continue;
                List<Integer> list = this.keysToDelete;
                synchronized (list) {
                    temp = new ArrayList<Integer>(this.keysToDelete);
                    this.keysToDelete.clear();
                }
                for (Integer keyToRemove : temp) {
                    try {
                        LogEntryTableModelBase.this.allLogs.deleteLog(keyToRemove);
                    }
                    catch (Throwable t) {
                        System.err.println("Error deleting a key from the cache of logs " + keyToRemove);
                        t.printStackTrace(System.err);
                    }
                }
                temp.clear();
            }
            this.keysToDelete.clear();
        }

        public void close() {
            this.closed = true;
        }
    }
}

