/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.io;

import com.cosylab.logging.LoggingClient;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class LoadSwitchesPanel
extends JPanel {
    private JCheckBox clearLogsCB = null;
    private JCheckBox disconnectCB = null;
    private LoggingClient loggingClient = null;

    public LoadSwitchesPanel(LoggingClient client) {
        if (client == null) {
            throw new IllegalArgumentException("Invalid null LoggingClient!");
        }
        this.loggingClient = client;
        this.initGUI();
    }

    private void initGUI() {
        this.clearLogsCB = new JCheckBox("Clear log table", true);
        this.disconnectCB = new JCheckBox("Disconnect", true);
        this.checkControlsState();
        this.setLayout(new FlowLayout(0));
        this.add(this.clearLogsCB);
        this.add(this.disconnectCB);
        TitledBorder border = BorderFactory.createTitledBorder("GUI setup");
        this.setBorder(border);
    }

    public void checkControlsState() {
        this.disconnectCB.setSelected(this.loggingClient.isConnected());
        this.disconnectCB.setEnabled(this.loggingClient.isConnected());
        this.clearLogsCB.setEnabled(this.loggingClient.getLCModel1().totalLogNumber() != 0L);
        this.clearLogsCB.setSelected(this.loggingClient.getLCModel1().totalLogNumber() != 0L);
    }

    public boolean clearLogs() {
        return this.clearLogsCB.isSelected();
    }

    public boolean disconnectEngine() {
        return this.disconnectCB.isSelected();
    }

    public void execute() {
        if (this.disconnectCB.isSelected()) {
            this.loggingClient.connect(false);
        }
        if (this.clearLogsCB.isSelected()) {
            this.loggingClient.getLCModel1().clearAll();
        }
    }
}

