/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import jsky.science.Quantity;
import jsky.science.UnitsNotSupportedException;

public class Wavelength
extends Quantity {
    public static final String DEFAULTUNITS_PROPERTY = "defaultWavelengthUnit".intern();
    public static final int E_METER = 0;
    public static final int E_ANGSTROM = -10;
    public static final int E_NANOMETER = -9;
    public static final int E_MICRON = -6;
    public static final int E_MILLIMETER = -3;
    public static final int E_CENTIMETER = -2;
    public static final int E_KILOMETER = 3;
    public static final int E_HERTZ = 0;
    public static final int E_KILOHERTZ = 3;
    public static final int E_MEGAHERTZ = 6;
    public static final int E_GIGAHERTZ = 9;
    public static final int E_EV = 0;
    public static final int E_KILOEV = -3;
    public static final int E_MEGAEV = -6;
    private static int[] fExponents = new int[]{-10, -9, -6, -3, -2, 0, 3, 0, 3, 6, 9, 0, -3, -6};
    public static final String ANGSTROM = "angstroms".intern();
    public static final String NANOMETER = "nanometers".intern();
    public static final String MICRON = "microns".intern();
    public static final String MILLIMETER = "millimeters".intern();
    public static final String CENTIMETER = "centimeters".intern();
    public static final String METER = "meters".intern();
    public static final String KILOMETER = "kilometers".intern();
    public static final String HERTZ = "hertz".intern();
    public static final String KILOHERTZ = "kilohertz".intern();
    public static final String MEGAHERTZ = "megahertz".intern();
    public static final String GIGAHERTZ = "gigahertz".intern();
    public static final String EV = "electron-volts".intern();
    public static final String KILOEV = "kiloelectron-volts".intern();
    public static final String MEGAEV = "megaelectron-volts".intern();
    public static final String ANGSTROMABBREV = "\u00c5".intern();
    public static final String NANOMETERABBREV = "nm".intern();
    public static final String MICRONABBREV = "\u00b5m".intern();
    public static final String MILLIMETERABBREV = "mm".intern();
    public static final String CENTIMETERABBREV = "cm".intern();
    public static final String METERABBREV = "m".intern();
    public static final String KILOMETERABBREV = "km".intern();
    public static final String HERTZABBREV = "Hz".intern();
    public static final String KILOHERTZABBREV = "KHz".intern();
    public static final String MEGAHERTZABBREV = "MHz".intern();
    public static final String GIGAHERTZABBREV = "GHz".intern();
    public static final String EVABBREV = "eV".intern();
    public static final String KILOEVABBREV = "KeV".intern();
    public static final String MEGAEVABBREV = "MeV".intern();
    public static final Wavelength MAX_VALUE;
    public static final Wavelength MIN_VALUE;
    private static final long serialVersionUID = 1L;

    public Wavelength() {
        this(0.0);
    }

    public Wavelength(double inValue) {
        this(inValue, null);
    }

    public Wavelength(double inValue, String inUnits) {
        if (inUnits == null) {
            inUnits = this.getDefaultUnits();
        }
        this.setValue(inValue, inUnits);
    }

    @Override
    public Quantity newInstance(double inValue) {
        return new Wavelength(inValue);
    }

    @Override
    public double getValue(String unitsName) {
        try {
            return Wavelength.convert(this.fValue, METER, unitsName);
        }
        catch (UnitsNotSupportedException e) {
            this.writeError(this, e.toString());
            return Double.NaN;
        }
    }

    @Override
    protected void setValue(double inValue, String unitsName) {
        try {
            this.fValue = Wavelength.convert(inValue, unitsName, METER);
        }
        catch (UnitsNotSupportedException e) {
            this.writeError(this, e.toString());
            this.fValue = Double.NaN;
        }
    }

    public static double convert(double inVal, String fromUnits, String toUnits) throws UnitsNotSupportedException {
        double outVal = Double.NaN;
        if (fromUnits.equalsIgnoreCase(METER)) {
            int index = Wavelength.getAllUnits(Wavelength.class).indexOf(toUnits);
            if (index < 0) {
                throw new UnitsNotSupportedException(toUnits);
            }
            outVal = toUnits.endsWith(HERTZ) ? 2.99792458E8 / inVal / Math.pow(10.0, fExponents[index]) : (toUnits.endsWith(EV) ? inVal / 1.23984282E-6 * Math.pow(10.0, fExponents[index]) : inVal / Math.pow(10.0, fExponents[index]));
        } else if (toUnits.equalsIgnoreCase(METER)) {
            int index = Wavelength.getAllUnits(Wavelength.class).indexOf(fromUnits);
            if (index < 0) {
                throw new UnitsNotSupportedException(fromUnits);
            }
            outVal = fromUnits.endsWith(HERTZ) ? inVal / 2.99792458E8 * Math.pow(10.0, fExponents[index]) : (fromUnits.endsWith(EV) ? 1.23984282E-6 / inVal / Math.pow(10.0, fExponents[index]) : inVal * Math.pow(10.0, fExponents[index]));
        } else {
            double tmpVal = Wavelength.convert(inVal, fromUnits, METER);
            outVal = Wavelength.convert(tmpVal, METER, toUnits);
        }
        return outVal;
    }

    public static void addDefaultUnitsChangeListener(PropertyChangeListener listener) {
        Quantity.addDefaultUnitsChangeListener(Wavelength.class, listener);
    }

    public static void removeDefaultUnitsChangeListener(PropertyChangeListener listener) {
        Quantity.removeDefaultUnitsChangeListener(Wavelength.class, listener);
    }

    static {
        ArrayList<String> unitNames = new ArrayList<String>();
        unitNames.add(ANGSTROM);
        unitNames.add(NANOMETER);
        unitNames.add(MICRON);
        unitNames.add(MILLIMETER);
        unitNames.add(CENTIMETER);
        unitNames.add(METER);
        unitNames.add(KILOMETER);
        unitNames.add(HERTZ);
        unitNames.add(KILOHERTZ);
        unitNames.add(MEGAHERTZ);
        unitNames.add(GIGAHERTZ);
        unitNames.add(EV);
        unitNames.add(KILOEV);
        unitNames.add(MEGAEV);
        ArrayList<String> unitAbbrev = new ArrayList<String>();
        unitAbbrev.add(ANGSTROMABBREV);
        unitAbbrev.add(NANOMETERABBREV);
        unitAbbrev.add(MICRONABBREV);
        unitAbbrev.add(MILLIMETERABBREV);
        unitAbbrev.add(CENTIMETERABBREV);
        unitAbbrev.add(METERABBREV);
        unitAbbrev.add(KILOMETERABBREV);
        unitAbbrev.add(HERTZABBREV);
        unitAbbrev.add(KILOHERTZABBREV);
        unitAbbrev.add(MEGAHERTZABBREV);
        unitAbbrev.add(GIGAHERTZABBREV);
        unitAbbrev.add(EVABBREV);
        unitAbbrev.add(KILOEVABBREV);
        unitAbbrev.add(MEGAEVABBREV);
        Quantity.initializeSubClass(Wavelength.class, unitNames, unitAbbrev, ANGSTROM, DEFAULTUNITS_PROPERTY);
        MAX_VALUE = new Wavelength(Double.MAX_VALUE, ANGSTROM);
        MIN_VALUE = new Wavelength(0.0, ANGSTROM);
    }
}

