/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Calendar;
import jsky.coords.wcscon;
import jsky.science.CoordinatesOffset;
import jsky.util.FormatUtilities;
import jsky.util.ListenerHandler;

public class Coordinates
implements Serializable {
    private double fRa;
    private double fDec;
    private int fEquinox;
    private double fEpoch;
    private static ListenerHandler sPropertyChangeListeners = new LocalPropertyChangeHandler();
    public static final String DEGREE = "Degree".intern();
    public static final String ARCSEC = "ArcSec".intern();
    public static final String RADIAN = "Radian".intern();
    private static final char SPACE_SEPARATOR = ' ';
    private static final char COLON_SEPARATOR = ':';
    private static final char HOUR_LETTER_SEPARATOR = 'h';
    private static final char MINUTE_LETTER_SEPARATOR = 'm';
    private static final char SECOND_LETTER_SEPARATOR = 's';
    private static final char DEGREE_LETTER_SEPARATOR = 'd';
    public static final int NUM_DECIMAL = 2;
    public static final int SPACE_SEPARATOR_STYLE = 0;
    public static final String SPACE_SEPARATOR_STYLE_LABEL = "## ## ##.##";
    public static final int COLON_SEPARATOR_STYLE = 1;
    public static final String COLON_SEPARATOR_STYLE_LABEL = "##:##:##.##";
    public static final int LETTER_SEPARATOR_STYLE = 2;
    public static final String LETTER_SEPARATOR_STYLE_LABEL = "##h##m##.##s";
    public static final int B1950_EQUINOX = 1;
    public static final String B1950_EQUINOX_LABEL = "B1950";
    public static final int J2000_EQUINOX = 2;
    public static final String J2000_EQUINOX_LABEL = "J2000";
    public static final String FORMATSTYLEPROPERTY = "FormatStyleProperty".intern();
    private static final long serialVersionUID = 1L;
    private static final String[] ALL_STYLE_LABELS = new String[]{"## ## ##.##", "##:##:##.##", "##h##m##.##s"};
    private static final String[] ALL_EQUINOX_LABELS = new String[]{"J2000", "B1950"};
    private static int sSeparatorStyle = 0;
    private static final int DEFAULT_EQUINOX = 2;

    public Coordinates() {
        this.fRa = 0.0;
        this.fDec = 0.0;
        this.fEquinox = 2;
        this.fEpoch = 2000.0;
    }

    public Coordinates(double ra, double dec) {
        this(ra, dec, 2);
    }

    public Coordinates(double ra, double dec, int equinox) {
        this.fRa = Coordinates.validateRa(ra);
        this.fDec = Coordinates.validateDec(dec);
        this.setEquinox(equinox);
    }

    public Coordinates(double ra, double dec, int equinox, double epoch) {
        this(ra, dec, equinox);
        this.setEpoch(epoch);
    }

    public Coordinates(Coordinates old) {
        this(old.getRa(), old.getDec(), old.getEquinox(), old.getEpoch());
    }

    public double getRa() {
        return this.fRa;
    }

    public double getDec() {
        return this.fDec;
    }

    public static double convert(double coord, String fromUnits, String toUnits) {
        if (!fromUnits.equals(DEGREE) && !toUnits.equals(DEGREE)) {
            double deg = Coordinates.convert(coord, fromUnits, DEGREE);
            return Coordinates.convert(deg, DEGREE, toUnits);
        }
        if (fromUnits.equals(DEGREE)) {
            if (toUnits.equals(ARCSEC)) {
                return coord * 3600.0;
            }
            if (toUnits.equals(DEGREE)) {
                return coord;
            }
            if (toUnits.equals(RADIAN)) {
                return coord / 180.0 * Math.PI;
            }
            Coordinates.writeError("Coordinates.convert", "Target units unsupported, " + toUnits);
            return Double.NaN;
        }
        if (fromUnits.equals(ARCSEC)) {
            return coord / 3600.0;
        }
        if (fromUnits.equals(DEGREE)) {
            return coord;
        }
        if (fromUnits.equals(RADIAN)) {
            return coord * 180.0 / Math.PI;
        }
        Coordinates.writeError("Coordinates.convert", "Source units unsupported, " + fromUnits);
        return Double.NaN;
    }

    protected static void writeError(Object source, Object message) {
        System.err.println("[ERROR] " + source + ": " + message);
    }

    public double getRa(String units) {
        return Coordinates.convert(this.fRa, DEGREE, units);
    }

    public double getDec(String units) {
        return Coordinates.convert(this.fDec, DEGREE, units);
    }

    public void setRa(double ra) {
        this.fRa = Coordinates.validateRa(ra);
    }

    public void setDec(double dec) {
        this.fDec = Coordinates.validateDec(dec);
    }

    public void setRa(double ra, String units) {
        this.fRa = Coordinates.validateRa(Coordinates.convert(ra, units, DEGREE));
    }

    public void setDec(double dec, String units) {
        this.fDec = Coordinates.validateDec(Coordinates.convert(dec, units, DEGREE));
    }

    public void setValue(double ra, double dec) {
        this.setRa(ra);
        this.setDec(dec);
    }

    public static final double validateRa(double ra, String units) {
        return Coordinates.convert(Coordinates.validateRa(Coordinates.convert(ra, units, DEGREE)), DEGREE, units);
    }

    public static final double validateRa(double ra) {
        double newRA = ra % 360.0;
        if (newRA < 0.0) {
            newRA += 360.0;
        }
        return newRA;
    }

    public static final double validateDec(double dec, String units) {
        return Coordinates.convert(Coordinates.validateDec(Coordinates.convert(dec, units, DEGREE)), DEGREE, units);
    }

    public static final double validateDec(double dec) {
        double newDec = dec % 360.0;
        if (newDec < 0.0) {
            newDec += 360.0;
        }
        if (newDec > 270.0) {
            newDec -= 360.0;
        } else if (newDec > 90.0) {
            newDec = 180.0 - newDec;
        }
        return newDec;
    }

    public double getEclipticLongitude() {
        double ra_rads = Coordinates.convert(this.fRa * 15.0, DEGREE, RADIAN);
        double dec_rads = Coordinates.convert(this.fDec, DEGREE, RADIAN);
        double beta = Coordinates.convert(this.getEclipticLatitude(), DEGREE, RADIAN);
        double lambda = Math.acos(Math.cos(dec_rads) * Math.cos(ra_rads) / Math.cos(beta));
        return Coordinates.convert(lambda, RADIAN, DEGREE);
    }

    public double getEclipticLatitude() {
        double ra_rads = Coordinates.convert(this.fRa * 15.0, DEGREE, RADIAN);
        double dec_rads = Coordinates.convert(this.fDec, DEGREE, RADIAN);
        double eps = this.getObliquityOfEcliptic();
        double lat = Math.asin(Math.sin(dec_rads) * Math.cos(eps) - Math.cos(dec_rads) * Math.sin(eps) * Math.sin(ra_rads));
        return Coordinates.convert(lat, RADIAN, DEGREE);
    }

    private double getObliquityOfEcliptic() {
        Calendar cal = Calendar.getInstance();
        cal.set(1900, 1, 1);
        long time1900 = cal.getTime().getTime();
        cal.set(2000, 1, 1);
        long oneCentury = cal.getTime().getTime() - time1900;
        switch (this.fEquinox) {
            case 1: {
                cal.set(1950, 1, 1);
                break;
            }
            case 2: {
                cal.set(2000, 1, 1);
            }
        }
        long timeTarget = cal.getTime().getTime();
        long centuriesSince1900 = (timeTarget - time1900) / oneCentury + 1L;
        double eps1900 = 23.452291666666667;
        double eps = eps1900 + (-46.845 * (double)centuriesSince1900 - 0.0059 * Math.pow(centuriesSince1900, 2.0) + 0.00181 * Math.pow(centuriesSince1900, 3.0)) / 3600.0;
        return eps;
    }

    public int getEquinox() {
        return this.fEquinox;
    }

    public void setEquinox(int equinox) {
        if (equinox != 2 && equinox != 1) {
            throw new IllegalArgumentException("Equinox must be either J2000 or B1950 constant");
        }
        this.fEquinox = equinox;
        this.fEpoch = Coordinates.equinoxIntToYear(this.fEquinox);
    }

    public double getEpoch() {
        return this.fEpoch;
    }

    public void setEpoch(double epoch) {
        this.fEpoch = epoch;
    }

    public static int getSeparatorStyle() {
        return sSeparatorStyle;
    }

    public static void setSeparatorStyle(int style) {
        if (sSeparatorStyle != style) {
            Class<Coordinates> thisClass = Coordinates.class;
            int oldStyle = sSeparatorStyle;
            sSeparatorStyle = style;
            PropertyChangeEvent evt = new PropertyChangeEvent(thisClass, FORMATSTYLEPROPERTY, new Integer(oldStyle), new Integer(sSeparatorStyle));
            Coordinates.fireSeparatorStyleChange(evt);
        }
    }

    public static int getDefaultEquinox() {
        return 2;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Coordinates) {
            Coordinates c = (Coordinates)obj;
            return this.fRa == c.getRa() && this.fDec == c.getDec() && this.fEquinox == c.getEquinox() && this.fEpoch == c.getEpoch();
        }
        return false;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.fRa);
        return (int)(bits ^= Double.doubleToLongBits(this.fDec) * 31L) ^ (int)(bits >> 32);
    }

    public void translate(double raArcsec, double decArcsec) {
        this.fRa += raArcsec / 3600.0;
        this.fDec += decArcsec / 3600.0;
        this.fRa = Coordinates.validateRa(this.fRa);
        this.fDec = Coordinates.validateDec(this.fDec);
    }

    public void translate(CoordinatesOffset offset) {
        this.fRa += offset.getRa();
        this.fDec += offset.getDec();
        this.fRa = Coordinates.validateRa(this.fRa);
        this.fDec = Coordinates.validateDec(this.fDec);
    }

    public void rotate(double angleRad, double ra, double dec) {
        double raNew = this.fRa * Math.cos(angleRad) - this.fDec * Math.sin(angleRad) + ra;
        double decNew = this.fRa * Math.sin(angleRad) + this.fDec * Math.cos(angleRad) + dec;
        this.fRa = raNew;
        this.fDec = decNew;
        this.fRa = Coordinates.validateRa(this.fRa);
        this.fDec = Coordinates.validateDec(this.fDec);
    }

    public Coordinates add(CoordinatesOffset offset) {
        return new Coordinates(this.fRa + offset.getRa(), this.fDec + offset.getDec(), this.fEquinox, this.fEpoch);
    }

    public CoordinatesOffset subtract(Coordinates c) {
        Coordinates c2 = c;
        if (c2.getEquinox() != this.fEquinox) {
            switch (this.fEquinox) {
                case 1: {
                    c2 = c2.toB1950();
                    break;
                }
                case 2: {
                    c2 = c2.toJ2000();
                }
            }
        }
        return new CoordinatesOffset(this.fRa - c2.fRa, this.fDec - c2.fDec);
    }

    public String toString() {
        return "RA: " + this.raToString() + ", DEC: " + this.decToString() + " (" + this.getEpoch() + ")";
    }

    public Coordinates toB1950() {
        switch (this.getEquinox()) {
            case 1: {
                return this;
            }
            case 2: {
                Point2D.Double out = wcscon.fk524((Point2D.Double)new Point2D.Double(this.getRa(), this.getDec()));
                return new Coordinates(out.x, out.y, 1);
            }
        }
        return null;
    }

    public Coordinates toJ2000() {
        switch (this.getEquinox()) {
            case 2: {
                return this;
            }
            case 1: {
                Point2D.Double out = wcscon.fk425((Point2D.Double)new Point2D.Double(this.getRa(), this.getDec()));
                return new Coordinates(out.x, out.y, 2);
            }
        }
        return null;
    }

    public String raToString() {
        return this.raToString(sSeparatorStyle);
    }

    public String raToString(int separatorStyle) {
        double a = this.fRa / 15.0;
        int hours = (int)a;
        double b = (a - (double)hours) * 60.0;
        int minutes = (int)b;
        double seconds = (b - (double)minutes) * 60.0;
        String secondsStr = FormatUtilities.formatDouble(seconds, 2);
        if (seconds > 59.999999 || secondsStr.startsWith("60.")) {
            seconds = 0.0;
            secondsStr = "0.00";
            ++minutes;
        }
        if (minutes > 59) {
            minutes = 0;
            ++hours;
        }
        if (hours > 23) {
            hours -= 24;
        }
        String hoursStr = "";
        hoursStr = hours >= 10 ? hoursStr + hours : "0" + hours;
        String minutesStr = "";
        minutesStr = minutes >= 10 ? minutesStr + minutes : "0" + minutes;
        switch (separatorStyle) {
            default: {
                return hoursStr + ' ' + minutesStr + ' ' + secondsStr;
            }
            case 1: {
                return hoursStr + ':' + minutesStr + ':' + secondsStr;
            }
            case 2: 
        }
        return hoursStr + 'h' + minutesStr + 'm' + secondsStr + 's';
    }

    public String decToString() {
        return this.decToString(sSeparatorStyle);
    }

    public String decToString(int separatorStyle) {
        char sign;
        double a = this.fDec;
        if (a < 0.0) {
            sign = '-';
            a = -a;
        } else {
            sign = '+';
        }
        int degrees = (int)a;
        double b = (a - (double)degrees) * 60.0;
        int minutes = (int)b;
        double seconds = (b - (double)minutes) * 60.0;
        String secondsStr = FormatUtilities.formatDouble(seconds, 2);
        if (seconds > 59.999999 || secondsStr.startsWith("60.")) {
            seconds = 0.0;
            secondsStr = "0.00";
            ++minutes;
        }
        if (minutes > 59) {
            minutes = 0;
            ++degrees;
        }
        String degreesStr = "";
        degreesStr = degrees >= 10 ? degreesStr + degrees : "0" + degrees;
        String minutesStr = "";
        minutesStr = minutes >= 10 ? minutesStr + minutes : "0" + minutes;
        switch (separatorStyle) {
            default: {
                return "" + sign + degreesStr + ' ' + minutesStr + ' ' + secondsStr;
            }
            case 1: {
                return "" + sign + degreesStr + ':' + minutesStr + ':' + secondsStr;
            }
            case 2: 
        }
        return "" + sign + degreesStr + 'd' + minutesStr + 'm' + secondsStr + 's';
    }

    public String equinoxToString() {
        return Coordinates.equinoxIntToString(this.getEquinox());
    }

    public String epochToString() {
        return String.valueOf(this.getEpoch());
    }

    public static Coordinates valueOf(String raInput, String decInput, int equinox) throws NumberFormatException, IllegalArgumentException {
        Coordinates c = Coordinates.valueOf(raInput, decInput);
        c.setEquinox(equinox);
        return c;
    }

    public static Coordinates valueOf(String raInput, String decInput) throws NumberFormatException, IllegalArgumentException {
        char sSep;
        char mSep;
        char dSep;
        if (raInput == null || decInput == null || raInput.length() == 0 || decInput.length() == 0) {
            throw new NumberFormatException();
        }
        switch (sSeparatorStyle) {
            default: {
                dSep = ' ';
                mSep = ' ';
                sSep = ' ';
                break;
            }
            case 1: {
                dSep = ':';
                mSep = ':';
                sSep = ':';
                break;
            }
            case 2: {
                dSep = 'h';
                mSep = 'm';
                sSep = 's';
            }
        }
        double ra = Coordinates.degreesFromString(raInput, dSep, mSep, sSep);
        if (raInput.indexOf(dSep) >= 0) {
            ra *= 15.0;
        }
        if ((ra = Coordinates.validateRa(ra)) < 0.0 || ra >= 360.0) {
            throw new IllegalArgumentException("Right-ascension must be between 0 and 360 degrees.");
        }
        if (dSep == 'h') {
            dSep = 'd';
        }
        double dec = Coordinates.degreesFromString(decInput, dSep, mSep, sSep);
        if ((dec = Coordinates.validateDec(dec)) < -90.0 || dec > 90.0) {
            throw new IllegalArgumentException("Declination must be between -90.0 and 90.0 degrees.");
        }
        return new Coordinates(ra, dec);
    }

    private static final double degreesFromString(String input, char dSep, char mSep, char sSep) throws NumberFormatException {
        String inString = input.trim();
        String temp = "";
        double degrees = 0.0;
        double sign = 0.0;
        double d = 0.0;
        double m = 0.0;
        double s = 0.0;
        if (inString.charAt(0) == '-') {
            sign = -1.0;
            inString = inString.substring(1);
        } else if (inString.charAt(0) == '+') {
            sign = 1.0;
            inString = inString.substring(1);
        } else {
            sign = 1.0;
        }
        if (inString.indexOf(dSep) == -1) {
            degrees = inString.indexOf(46) >= 0 ? Double.valueOf(inString) : (double)Integer.valueOf(inString).intValue();
        } else {
            temp = inString.substring(0, inString.indexOf(dSep));
            inString = inString.substring(inString.indexOf(dSep) + 1);
            d = Integer.valueOf(temp).intValue();
            if (inString.indexOf(mSep) == -1) {
                throw new NumberFormatException();
            }
            temp = inString.substring(0, inString.indexOf(mSep));
            if ((inString = inString.substring(inString.indexOf(mSep) + 1)).indexOf(sSep) != -1) {
                inString = inString.substring(0, inString.indexOf(sSep));
            }
            m = Integer.valueOf(temp).intValue();
            s = Double.valueOf(inString);
            degrees = sign * (d + m / 60.0 + s / 3600.0);
        }
        return degrees;
    }

    public static int separatorStyleStringToInt(String style) {
        if (style != null && style.length() > 1) {
            if (style.equals(SPACE_SEPARATOR_STYLE_LABEL)) {
                return 0;
            }
            if (style.equals(COLON_SEPARATOR_STYLE_LABEL)) {
                return 1;
            }
            if (style.equals(LETTER_SEPARATOR_STYLE_LABEL)) {
                return 2;
            }
        }
        return 0;
    }

    public static String separatorStyleIntToString(int style) {
        String s = "not defined";
        switch (style) {
            case 0: {
                s = SPACE_SEPARATOR_STYLE_LABEL;
                break;
            }
            case 1: {
                s = COLON_SEPARATOR_STYLE_LABEL;
                break;
            }
            case 2: {
                s = LETTER_SEPARATOR_STYLE_LABEL;
            }
        }
        return s;
    }

    public static String[] getAllSeparatorStyles() {
        return ALL_STYLE_LABELS;
    }

    public static int equinoxStringToInt(String equinox) {
        if (equinox != null && equinox.length() > 1) {
            if (equinox.equals(B1950_EQUINOX_LABEL)) {
                return 1;
            }
            if (equinox.equals(J2000_EQUINOX_LABEL)) {
                return 2;
            }
        }
        return 0;
    }

    public static String equinoxIntToString(int equinox) {
        String s = "not defined";
        switch (equinox) {
            case 1: {
                s = B1950_EQUINOX_LABEL;
                break;
            }
            case 2: {
                s = J2000_EQUINOX_LABEL;
            }
        }
        return s;
    }

    public static double equinoxIntToYear(int equinox) {
        double year = Double.NaN;
        switch (equinox) {
            case 1: {
                year = 1950.0;
                break;
            }
            case 2: {
                year = 2000.0;
            }
        }
        return year;
    }

    public static String[] getAllEquinoxes() {
        return ALL_EQUINOX_LABELS;
    }

    public static void addSeparatorStyleChangeListener(PropertyChangeListener listener) {
        sPropertyChangeListeners.addListener((Object)listener);
    }

    public static void removeSeparatorStyleChangeListener(PropertyChangeListener listener) {
        sPropertyChangeListeners.removeListener((Object)listener);
    }

    protected static void fireSeparatorStyleChange(PropertyChangeEvent evt) {
        sPropertyChangeListeners.sendEvent("", (Object)evt);
    }

    public static class LocalPropertyChangeHandler
    extends ListenerHandler {
        public void fireEvent(String eventkey, Object listener, Object event) {
            ((PropertyChangeListener)listener).propertyChange((PropertyChangeEvent)event);
        }
    }
}

