/*
 * Decompiled with CFR 0.152.
 */
package skyview.survey;

import java.io.File;
import java.util.Date;
import java.util.regex.Pattern;
import skyview.executive.Settings;
import skyview.survey.CachingImageFactory;
import skyview.survey.FitsImage;
import skyview.survey.Image;
import skyview.survey.ImageFactory;
import skyview.survey.Util;

class URLRetrieverFactory
implements ImageFactory {
    private static Pattern comma = Pattern.compile(",");
    private String subdir = null;

    URLRetrieverFactory() {
    }

    @Override
    public Image factory(String spell) {
        String[] tokens = comma.split(spell);
        String[] caches = Settings.getArray("Cache");
        if (caches.length == 0) {
            caches = new String[]{CachingImageFactory.DFT_CACHE};
        }
        String cache = caches[0];
        if (this.subdir != null) {
            cache = cache + this.subdir + File.separatorChar;
        }
        String file = cache + tokens[1];
        File dir = new File(cache);
        if (!dir.exists()) {
            try {
                dir.mkdirs();
            }
            catch (Exception e) {
                System.err.println("Error creating cache:" + caches[0]);
                throw new Error("Error, " + e + ", retrieving URL to file:" + tokens[0]);
            }
        }
        try {
            String tfile = file + new Date().getTime();
            Util.getURL(tokens[0], tfile);
            File f = new File(tfile);
            f.renameTo(new File(file));
            if (Settings.get("purgecache") != null) {
                Settings.add("_cachedfile", file);
            }
            return new FitsImage(file);
        }
        catch (Exception e) {
            throw new Error("Error, " + e + ",  retrieving URL to file:" + tokens[0]);
        }
    }

    void setSubdirectory(String dir) {
        this.subdir = dir;
    }
}

