/*
 * Decompiled with CFR 0.152.
 */
package skyview.survey;

import java.io.File;
import java.util.regex.Pattern;
import skyview.executive.Settings;
import skyview.geometry.CoordinateSystem;
import skyview.geometry.Projection;
import skyview.geometry.Scaler;
import skyview.geometry.WCS;
import skyview.survey.FitsImage;
import skyview.survey.Image;
import skyview.survey.ImageFactory;
import skyview.survey.ProxyImage;
import skyview.survey.SurveyException;
import skyview.survey.URLRetrieverFactory;

public class CachingImageFactory
implements ImageFactory {
    public static final String DFT_CACHE = "." + File.separator + "skycache" + File.separator;
    private static Pattern comma = Pattern.compile(",");

    @Override
    public Image factory(String spell) {
        Projection p;
        Scaler s;
        String test;
        String[] fields;
        String url;
        if (Settings.get("SpellSuffix") != null) {
            spell = spell + Settings.get("SpellSuffix");
        }
        if (Settings.get("SpellPrefix") != null) {
            spell = Settings.get("SpellPrefix") + spell;
        }
        String[] tokens = comma.split(spell);
        if (Settings.has("LocalURL") && (url = tokens[0]).startsWith((fields = Settings.getArray("LocalURL"))[0]) && new File(url = fields[1] + url.substring(fields[0].length())).exists()) {
            try {
                return new FitsImage(url);
            }
            catch (SurveyException s2) {
                // empty catch block
            }
        }
        String file = tokens[1];
        String cacheString = Settings.get("cache", DFT_CACHE);
        String[] caches = comma.split(cacheString);
        boolean appendSurvey = Settings.has("SaveBySurvey");
        String subdir = null;
        if (appendSurvey) {
            String[] dirs = Settings.getArray("shortname");
            if (dirs.length == 0) {
                appendSurvey = false;
            } else {
                subdir = dirs[0];
                subdir = subdir.replaceAll("[^a-zA-Z0-9\\-\\_\\+\\.]", "_");
            }
        }
        for (String cache : caches) {
            test = cache + file;
            if (!new File(test).exists()) continue;
            try {
                return new FitsImage(test);
            }
            catch (Exception e) {
                System.err.println("Unexpected exception reading cached image:" + test + " :: " + e);
                System.err.println("Trying to download the file.");
            }
        }
        if (appendSurvey) {
            for (String cache : caches) {
                test = cache + subdir + File.separatorChar + file;
                if (!new File(test).exists()) continue;
                try {
                    return new FitsImage(test);
                }
                catch (Exception e) {
                    System.err.println("Unexpected exception reading cached image:" + test + " :: " + e);
                    System.err.println("Trying to download the file.");
                }
            }
        }
        int nx = Integer.parseInt(tokens[6]);
        int ny = Integer.parseInt(tokens[7]);
        if (tokens.length == 10) {
            double dx = Math.toRadians(Double.parseDouble(tokens[8]));
            double dy = Math.toRadians(Double.parseDouble(tokens[9]));
            s = new Scaler(0.5 * (double)nx, 0.5 * (double)ny, -1.0 / dx, 0.0, 0.0, 1.0 / dy);
        } else {
            double m00 = Math.toRadians(Double.parseDouble(tokens[8]));
            double m01 = Math.toRadians(Double.parseDouble(tokens[9]));
            double m10 = Math.toRadians(Double.parseDouble(tokens[10]));
            double m11 = Math.toRadians(Double.parseDouble(tokens[11]));
            double det = m00 * m11 - m10 * m01;
            s = new Scaler(0.5 * (double)nx, 0.5 * (double)ny, m11 / det, -m01 / det, -m10 / det, m00 / det);
        }
        double crval1 = Math.toRadians(Double.parseDouble(tokens[2]));
        double crval2 = Math.toRadians(Double.parseDouble(tokens[3]));
        try {
            if (tokens[4].equalsIgnoreCase("Car") || tokens[4].equalsIgnoreCase("Ait") || tokens[4].equalsIgnoreCase("Csc")) {
                s = s.add(new Scaler(Double.parseDouble(tokens[2]) - 0.5 - 0.5 * (double)nx, Double.parseDouble(tokens[3]) - 0.5 - 0.5 * (double)ny, 1.0, 0.0, 0.0, 1.0));
                p = new Projection(tokens[4]);
            } else if (tokens[4].equalsIgnoreCase("Ncp")) {
                double[] xproj = new double[]{crval1, 1.5707963267948966};
                if (crval2 < 0.0) {
                    xproj[1] = -xproj[1];
                }
                double poleOffset = Math.sin(xproj[1] - crval2);
                p = new Projection("Sin", xproj);
                Scaler ncpScale = new Scaler(0.0, poleOffset, 1.0, 0.0, 0.0, 1.0);
                ncpScale = ncpScale.add(new Scaler(0.0, 0.0, 1.0, 0.0, 0.0, 1.0 / Math.sin(crval2)));
                s = ncpScale.add(s);
            } else {
                p = new Projection(tokens[4], new double[]{crval1, crval2});
            }
        }
        catch (Exception e) {
            throw new Error("Unexpected error building projection:" + e);
        }
        CoordinateSystem c = CoordinateSystem.factory(tokens[5]);
        try {
            WCS w = new WCS(c, p, s);
            URLRetrieverFactory fac = new URLRetrieverFactory();
            if (subdir != null) {
                fac.setSubdirectory(subdir);
            }
            ProxyImage pi = new ProxyImage(tokens[0] + "," + file, w, nx, ny, 1);
            pi.setFactory(fac);
            return pi;
        }
        catch (Exception e) {
            throw new Error("Unable to create proxy:" + e);
        }
    }
}

