/*
 * Decompiled with CFR 0.152.
 */
package skyview.process.expfinder;

import skyview.executive.Settings;
import skyview.geometry.Sampler;
import skyview.process.ExposureFinder;
import skyview.survey.FitsImage;
import skyview.survey.Image;

public class FitsKeyword
implements ExposureFinder {
    String expKey = "EXPOSURE";
    double exposure = -1.0;

    public FitsKeyword() {
        if (Settings.has("ExposureKeyword")) {
            this.expKey = Settings.get("ExposureKeyword");
        }
    }

    @Override
    public void setImage(Image input, Image output, Sampler samp) {
        try {
            this.exposure = ((FitsImage)input).getHeader().getDoubleValue(this.expKey, -1.0);
        }
        catch (Exception e) {
            System.err.println("  Error trying to get exposure from image:" + e);
        }
    }

    @Override
    public double getExposure(int pixel) {
        return this.exposure;
    }
}

