/*
 * Decompiled with CFR 0.152.
 */
package skyview.process.deedger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import skyview.geometry.DepthSampler;
import skyview.geometry.Sampler;
import skyview.process.Processor;
import skyview.survey.Image;

public class BoundaryMedian
implements Processor {
    double[][] deltas;
    ArrayList[][] shifts;
    int[][] counts;
    int totalCount;
    int nImage;
    Image[] inputs;
    Image output;
    int[] source;
    int nx;
    int ny;
    double[] offsets;

    @Override
    public String getName() {
        return "Boundary Median Deedger:";
    }

    @Override
    public String getDescription() {
        return "Hide borders between input images by matching medians of border pixels";
    }

    @Override
    public void process(Image[] inputs, Image output, int[] source, Sampler samp, DepthSampler dsamp) {
        if (output == null) {
            return;
        }
        Date dt = new Date();
        int nImage = inputs.length;
        this.deltas = new double[nImage][nImage];
        this.shifts = new ArrayList[nImage][nImage];
        for (int i = 0; i < nImage; ++i) {
            this.shifts[i] = new ArrayList[nImage];
        }
        this.counts = new int[nImage][nImage];
        this.nImage = nImage;
        this.source = source;
        this.inputs = inputs;
        this.output = output;
        this.ny = output.getHeight();
        this.nx = output.getWidth();
        this.deedge();
        Date dx = new Date();
    }

    private void deedge() {
        int i;
        int t1;
        int t0;
        int j;
        int i2;
        this.totalCount = 0;
        for (i2 = 0; i2 < this.ny - 1; ++i2) {
            for (j = 0; j < this.nx; ++j) {
                t0 = j + i2 * this.nx;
                t1 = t0 + this.nx;
                this.check(t0, t1);
            }
        }
        for (i2 = 0; i2 < this.ny; ++i2) {
            for (j = 0; j < this.nx - 1; ++j) {
                t0 = j + i2 * this.nx;
                t1 = t0 + 1;
                this.check(t0, t1);
            }
        }
        if (this.totalCount == 0) {
            return;
        }
        for (i2 = 0; i2 < this.nImage; ++i2) {
            for (j = i2 + 1; j < this.nImage; ++j) {
                if (this.shifts[i2][j] != null) {
                    ArrayList list = this.shifts[i2][j];
                    int cnt = list.size();
                    Collections.sort(list);
                    double median = cnt % 2 == 0 ? 0.5 * ((Double)list.get(cnt / 2 - 1) + (Double)list.get(cnt / 2)) : (Double)list.get(cnt / 2);
                    this.deltas[i2][j] = median;
                    this.deltas[j][i2] = -median;
                    continue;
                }
                this.deltas[i2][j] = 0.0;
                this.deltas[j][i2] = 0.0;
            }
        }
        int[] tc = new int[this.nImage];
        int offIm = 0;
        for (int i3 = 0; i3 < this.source.length; ++i3) {
            if (this.source[i3] > 0) {
                int n = this.source[i3];
                tc[n] = tc[n] + 1;
                continue;
            }
            ++offIm;
        }
        int maxInd = 0;
        for (i = 1; i < this.nImage; ++i) {
            if (tc[i] <= tc[maxInd]) continue;
            maxInd = i;
        }
        this.offsets = new double[this.nImage];
        Arrays.fill(this.offsets, Double.NaN);
        this.offsets[maxInd] = 0.0;
        while (true) {
            int maxI = -1;
            int maxJ = -1;
            int cCount = 0;
            for (int i4 = 0; i4 < this.nImage; ++i4) {
                if (Double.isNaN(this.offsets[i4])) continue;
                for (int j2 = 0; j2 < this.nImage; ++j2) {
                    if (!Double.isNaN(this.offsets[j2]) || this.counts[i4][j2] <= cCount) continue;
                    cCount = this.counts[i4][j2];
                    maxI = i4;
                    maxJ = j2;
                }
            }
            if (maxI < 0 || cCount < 10) break;
            this.offsets[maxJ] = this.offsets[maxI] - this.deltas[maxI][maxJ];
        }
        for (i = 0; i < this.nImage; ++i) {
            if (!Double.isNaN(this.offsets[i])) continue;
            this.offsets[i] = 0.0;
        }
        for (i = 0; i < this.nx * this.ny; ++i) {
            if (this.source[i] < 0) continue;
            double offset = this.offsets[this.source[i]];
            double oldVal = this.output.getData(i);
            this.output.setData(i, this.output.getData(i) + offset);
        }
    }

    private void check(int t0, int t1) {
        int s0 = this.source[t0];
        int s1 = this.source[t1];
        if (s0 >= 0 && s1 >= 0 && s0 != s1) {
            int smax;
            int smin;
            ++this.totalCount;
            double delta = this.output.getData(t1) - this.output.getData(t0);
            if (s0 < s1) {
                smin = s0;
                smax = s1;
            } else {
                smin = s1;
                smax = s0;
                delta = -delta;
            }
            if (this.shifts[smin][smax] == null) {
                this.shifts[smin][smax] = new ArrayList();
            }
            ArrayList list = this.shifts[smin][smax];
            list.add(delta);
            int[] nArray = this.counts[s0];
            int n = s1;
            nArray[n] = nArray[n] + 1;
            int[] nArray2 = this.counts[s1];
            int n2 = s0;
            nArray2[n2] = nArray2[n2] + 1;
        }
    }

    @Override
    public void updateHeader(Header h) {
        try {
            boolean first = true;
            if (this.offsets == null) {
                return;
            }
            for (int i = 0; i < this.nImage; ++i) {
                String cfile;
                if (this.offsets[i] == 0.0) continue;
                if (first) {
                    h.insertHistory("");
                    h.insertHistory("Edge adjustments applied (skyview.geometry.DeedgerList");
                    h.insertHistory("");
                    first = false;
                }
                if ((cfile = this.inputs[i].getName()).lastIndexOf(47) > 0) {
                    cfile = cfile.substring(cfile.lastIndexOf(47) + 1);
                }
                h.insertHistory("     Image " + cfile + " offset by " + this.offsets[i]);
            }
            if (!first) {
                h.insertHistory("");
            }
        }
        catch (FitsException e) {
            System.err.println("Error updating header:" + e);
        }
    }
}

