/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.projecter;

import skyview.geometry.Projecter;
import skyview.geometry.projecter.Car;
import skyview.geometry.projecter.Straddle;
import skyview.geometry.sampler.Clip;

class CarStraddle
extends Straddle {
    Projecter proj;
    Clip myClipper;
    boolean doClip;
    double clipXMin;
    double clipXMax;
    double clipYMin;
    double clipYMax;

    CarStraddle(Projecter input) {
        this.proj = input;
    }

    CarStraddle(Car inProj) {
        this((Projecter)inProj);
        this.doClip = true;
        this.clipXMin = -Math.PI;
        this.clipXMax = Math.PI;
        this.clipYMin = -1.5707963267948966;
        this.clipYMax = 1.5707963267948966;
    }

    @Override
    boolean straddle(double[][] vertices) {
        boolean pos = false;
        boolean neg = false;
        boolean both = false;
        int n = vertices[0].length;
        boolean debug = Math.abs(vertices[0][0]) > 3.12413936106985;
        for (int i = 0; i < n; ++i) {
            if (vertices[0][i] > 0.0) {
                if (neg) {
                    both = true;
                    break;
                }
                pos = true;
                continue;
            }
            if (!(vertices[0][i] < 0.0)) continue;
            if (pos) {
                both = true;
                break;
            }
            neg = true;
        }
        if (both) {
            double[][] tvert = new double[2][n];
            for (int i = 0; i < n; ++i) {
                if (vertices[0][i] >= 0.0) {
                    tvert[0][i] = vertices[0][i];
                    tvert[1][i] = vertices[1][i];
                    continue;
                }
                double[] shadow = this.proj.shadowPoint(vertices[0][i], vertices[1][i]);
                tvert[0][i] = shadow[0];
                tvert[1][i] = shadow[1];
            }
            double noStraddle = CarStraddle.testArea(vertices);
            double haveStraddle = CarStraddle.testArea(tvert);
            return haveStraddle < 0.9 * noStraddle;
        }
        return false;
    }

    static double testArea(double[][] inputs) {
        return Clip.convexArea(inputs[0].length, inputs[0], inputs[1]);
    }

    void fixShadow(double x, double y, double[] shadow) {
        if (x > 0.0 && shadow[0] > 0.0 || x < 0.0 && shadow[0] < 0.0) {
            shadow[0] = -shadow[0];
        }
    }

    @Override
    double[][][] straddleComponents(double[][] inputs) {
        int i;
        int n = inputs[0].length;
        double[][][] areas = new double[2][2][n];
        for (i = 0; i < n; ++i) {
            double x = inputs[0][i];
            double y = inputs[1][i];
            double[] shad = this.proj.shadowPoint(x, y);
            this.fixShadow(x, y, shad);
            if (x < 0.0) {
                areas[0][0][i] = shad[0];
                areas[0][1][i] = shad[1];
                areas[1][0][i] = x;
                areas[1][1][i] = y;
                continue;
            }
            areas[1][0][i] = shad[0];
            areas[1][1][i] = shad[1];
            areas[0][0][i] = x;
            areas[0][1][i] = y;
        }
        if (this.doClip) {
            if (this.myClipper == null) {
                this.myClipper = new Clip();
            }
            for (i = 0; i < areas.length; ++i) {
                double[] xi = areas[i][0];
                double[] yi = areas[i][1];
                double[] xo = new double[12];
                double[] yo = new double[12];
                int np = this.myClipper.rectClip(n, xi, yi, xo, yo, this.clipXMin, this.clipYMin, this.clipXMax, this.clipYMax);
                double[] xv = new double[np];
                double[] yv = new double[np];
                System.arraycopy(xo, 0, xv, 0, np);
                System.arraycopy(yo, 0, yv, 0, np);
                areas[i][0] = xv;
                areas[i][1] = yv;
            }
        }
        return areas;
    }
}

