/*
 * Decompiled with CFR 0.152.
 */
package skyview.executive;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import skyview.executive.Imager;
import skyview.executive.Settings;

public class Batch {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Batch processing requested but no file specified.  Use '-' for STDIN");
        }
        String[] xargs = new String[args.length - 1];
        System.arraycopy(args, 1, xargs, 0, xargs.length);
        Settings.addArgs(xargs);
        String file = args[0];
        BufferedReader in = file.equals("-") ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(file));
        Imager img = new Imager();
        int count = 0;
        String origOutput = Settings.get("output");
        while (true) {
            Settings.save();
            String line = in.readLine();
            if (line == null) break;
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            args = line.split(" ");
            for (int i = 0; i < args.length; ++i) {
                args[i] = args[i].trim();
            }
            try {
                Settings.addArgs(args);
                String currOutput = Settings.get("output");
                if (currOutput == null) {
                    Settings.put("output", "output" + count);
                } else if (currOutput.equals(origOutput)) {
                    Settings.put("output", origOutput + count);
                }
                img.run();
            }
            catch (Exception e) {
                System.err.println("Caught exception for line:" + line + "\n   " + e.getMessage());
            }
            img.clearImageCache();
            Settings.restore();
            ++count;
        }
    }
}

