/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.test;

import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.PaddingException;
import nom.tam.image.ImageTiler;
import nom.tam.util.BufferedFile;
import nom.tam.util.Cursor;
import org.junit.Assert;
import org.junit.Test;

public class PaddingTester {
    @Test
    public void test1() throws Exception {
        Fits f = new Fits();
        byte[][] bimg = new byte[20][20];
        for (int i = 0; i < 20; ++i) {
            for (int j = 0; j < 20; ++j) {
                bimg[i][j] = (byte)(i + j);
            }
        }
        BasicHDU hdu = Fits.makeHDU(bimg);
        Header hdr = hdu.getHeader();
        hdr.addValue("NEWKEY", "TESTVALUE", "Test keyword");
        BufferedFile bf = new BufferedFile("padding1.fits", "rw");
        hdr.write(bf);
        bf.writeArray(bimg);
        bf.flush();
        bf.close();
        f = new Fits("padding1.fits");
        try {
            f.read();
        }
        catch (PaddingException e) {
            Assert.assertEquals((String)"HDUCount", (Object)0, (Object)f.getNumberOfHDUs());
            f.addHDU(e.getTruncatedHDU());
            Assert.assertEquals((String)"HDUCount2", (Object)1, (Object)f.getNumberOfHDUs());
        }
        ImageHDU hdu0 = (ImageHDU)f.getHDU(0);
        byte[][] aa = (byte[][])hdu0.getKernel();
        int miss = 0;
        int match = 0;
        for (int i = 0; i < 20; ++i) {
            for (int j = 0; j < 20; ++j) {
                if (aa[i][j] != (byte)(i + j)) {
                    ++miss;
                    continue;
                }
                ++match;
            }
        }
        Assert.assertEquals((String)"PadMiss1:", (Object)miss, (Object)0);
        Assert.assertEquals((String)"PadMatch1:", (Object)match, (Object)400);
        Assert.assertEquals((String)"Update header:", (Object)hdu0.getHeader().getStringValue("NEWKEY"), (Object)"TESTVALUE");
        ImageTiler it = hdu0.getTiler();
        byte[] data = (byte[])it.getTile(new int[]{2, 2}, new int[]{2, 2});
        Assert.assertEquals((String)"tilet1:", (Object)data.length, (Object)4);
        Assert.assertEquals((String)"tilet2:", (Object)(data[0] + 0), (Object)4);
        Assert.assertEquals((String)"tilet3:", (Object)(data[1] + 0), (Object)5);
        Assert.assertEquals((String)"tilet4:", (Object)(data[2] + 0), (Object)5);
        Assert.assertEquals((String)"tilet5:", (Object)(data[3] + 0), (Object)6);
    }

    @Test
    public void test2() throws Exception {
        int i;
        Fits f = new Fits();
        byte[][] bimg = new byte[20][20];
        for (int i2 = 0; i2 < 20; ++i2) {
            for (int j = 0; j < 20; ++j) {
                bimg[i2][j] = (byte)(i2 + j);
            }
        }
        BasicHDU hdu = Fits.makeHDU(bimg);
        f.addHDU(hdu);
        BufferedFile bf = new BufferedFile("padding2.fits", "rw");
        f.write(bf);
        hdu.getHeader().setXtension("IMAGE");
        Cursor curs = hdu.getHeader().iterator();
        int cnt = 0;
        while (curs.hasNext()) {
            bf.write(((HeaderCard)curs.next()).toString().getBytes());
            ++cnt;
        }
        byte[] b = new byte[(36 - cnt) * 80];
        for (i = 0; i < b.length; ++i) {
            b[i] = 32;
        }
        bf.write(b);
        for (i = 0; i < 20; ++i) {
            for (int j = 0; j < 20; ++j) {
                bimg[i][j] = (byte)(2 * (i + j));
            }
        }
        bf.writeArray(bimg);
        bf.flush();
        bf.close();
        f = new Fits("padding2.fits");
        try {
            f.read();
        }
        catch (PaddingException e) {
            Assert.assertEquals((String)"HDUCount", (Object)1, (Object)f.getNumberOfHDUs());
            f.addHDU(e.getTruncatedHDU());
            Assert.assertEquals((String)"HDUCount2", (Object)2, (Object)f.getNumberOfHDUs());
        }
        ImageHDU hdu0 = (ImageHDU)f.getHDU(0);
        ImageHDU hdu1 = (ImageHDU)f.getHDU(1);
        byte[][] aa = (byte[][])hdu0.getKernel();
        byte[][] bb = (byte[][])hdu1.getKernel();
        int miss = 0;
        int match = 0;
        for (int i3 = 0; i3 < 20; ++i3) {
            for (int j = 0; j < 20; ++j) {
                if (bb[i3][j] != (byte)(2 * aa[i3][j])) {
                    ++miss;
                    continue;
                }
                ++match;
            }
        }
        Assert.assertEquals((String)"PadMiss2:", (Object)miss, (Object)0);
        Assert.assertEquals((String)"PadMatch2:", (Object)match, (Object)400);
    }
}

