/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.util.Tools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;

public class Memory
implements PlugIn {
    String s;
    int index1;
    int index2;
    File f;

    public void run(String arg) {
        this.changeMemoryAllocation();
    }

    void changeMemoryAllocation() {
        IJ.maxMemory();
        int max = (int)(this.getMemorySetting() / 0x100000L);
        if (max == 0) {
            this.showError();
            return;
        }
        GenericDialog gd = new GenericDialog("Memory");
        gd.addNumericField("Maximum Memory: ", max, 0, 4, "MB");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int max2 = (int)gd.getNextNumber();
        if (gd.invalidNumber()) {
            IJ.showMessage("Memory", "The number entered was invalid.");
            return;
        }
        if (max2 < 32 && IJ.isMacOSX()) {
            max2 = 32;
        }
        if (max2 < 8 && IJ.isWindows()) {
            max2 = 8;
        }
        if (max2 == max) {
            return;
        }
        if (max2 >= 1700 && !IJ.showMessageWithCancel("Memory", "Note: setting the memory limit to a value greater\nthan 1700MB may cause ImageJ to fail to start.")) {
            return;
        }
        try {
            String s2 = this.s.substring(0, this.index1) + max2 + this.s.substring(this.index2);
            FileOutputStream fos = new FileOutputStream(this.f);
            PrintWriter pw = new PrintWriter(fos);
            pw.print(s2);
            pw.close();
        }
        catch (IOException e) {
            String error = e.getMessage();
            if (error == null || error.equals("")) {
                error = "" + e;
            }
            String name = IJ.isMacOSX() ? "Info.plist" : "ImageJ.cfg";
            String msg = "Unable to update the file \"" + name + "\".\n" + " \n" + "\"" + error + "\"\n";
            IJ.showMessage("Memory", msg);
            return;
        }
        IJ.showMessage("Memory", "The new " + max2 + "MB limit will take effect after ImageJ is restarted.");
    }

    public long getMemorySetting() {
        if (IJ.getApplet() != null) {
            return 0L;
        }
        long max = 0L;
        max = IJ.isMacOSX() ? this.getMemorySetting("ImageJ.app/Contents/Info.plist") : this.getMemorySetting("ImageJ.cfg");
        return max;
    }

    void showError() {
        int max = (int)(this.maxMemory() / 0x100000L);
        String msg = "ImageJ is unable to change the memory limit. For \nmore information, refer to the installation notes. \n \n";
        if (max > 0) {
            msg = msg + "Current limit: " + max + "MB";
        }
        IJ.showMessage("Memory", msg);
    }

    long getMemorySetting(String file) {
        String path = Prefs.getHomeDir() + File.separator + file;
        this.f = new File(path);
        if (!this.f.exists()) {
            return 0L;
        }
        long max = 0L;
        try {
            int size = (int)this.f.length();
            byte[] buffer = new byte[size];
            FileInputStream in = new FileInputStream(this.f);
            in.read(buffer, 0, size);
            this.s = new String(buffer, 0, size, "ISO8859_1");
            in.close();
            this.index1 = this.s.indexOf("-mx");
            if (this.index1 == -1) {
                this.index1 = this.s.indexOf("-Xmx");
            }
            if (this.index1 == -1) {
                return 0L;
            }
            this.index1 = this.s.charAt(this.index1 + 1) == 'X' ? (this.index1 += 4) : (this.index1 += 3);
            this.index2 = this.index1;
            while (this.index2 < this.s.length() - 1 && Character.isDigit(this.s.charAt(++this.index2))) {
            }
            String s2 = this.s.substring(this.index1, this.index2);
            max = (long)Tools.parseDouble(s2, 0.0) * 1024L * 1024L;
        }
        catch (Exception e) {
            IJ.log("" + e);
            return 0L;
        }
        return max;
    }

    public long maxMemory() {
        long max = 0L;
        try {
            Runtime rt = Runtime.getRuntime();
            Class<?> c = rt.getClass();
            Method maxMemory = c.getDeclaredMethod("maxMemory", new Class[0]);
            Long l = (Long)maxMemory.invoke((Object)rt, new Object[0]);
            max = l;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return max;
    }
}

