/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.io.FileInfo;
import java.io.IOException;
import java.io.OutputStream;

public class ImageWriter {
    private FileInfo fi;
    private boolean showProgressBar = true;

    public ImageWriter(FileInfo fi) {
        this.fi = fi;
    }

    private void showProgress(double progress) {
        if (this.showProgressBar) {
            IJ.showProgress(progress);
        }
    }

    void write8BitImage(OutputStream out, byte[] pixels) throws IOException {
        int bytesWritten = 0;
        int size = this.fi.width * this.fi.height;
        int count = 8192;
        while (bytesWritten < size) {
            if (bytesWritten + count > size) {
                count = size - bytesWritten;
            }
            out.write(pixels, bytesWritten, count);
            this.showProgress((double)(bytesWritten += count) / (double)size);
        }
    }

    void write8BitStack(OutputStream out, Object[] stack) throws IOException {
        this.showProgressBar = false;
        for (int i = 0; i < this.fi.nImages; ++i) {
            IJ.showStatus("Writing: " + (i + 1) + "/" + this.fi.nImages);
            this.write8BitImage(out, (byte[])stack[i]);
            IJ.showProgress((double)(i + 1) / (double)this.fi.nImages);
        }
    }

    void write16BitImage(OutputStream out, short[] pixels) throws IOException {
        int bytesWritten = 0;
        int size = this.fi.width * this.fi.height * 2;
        int count = 8192;
        byte[] buffer = new byte[count];
        while (bytesWritten < size) {
            short value;
            int i;
            if (bytesWritten + count > size) {
                count = size - bytesWritten;
            }
            int j = bytesWritten / 2;
            if (this.fi.intelByteOrder) {
                for (i = 0; i < count; i += 2) {
                    value = pixels[j];
                    buffer[i] = (byte)value;
                    buffer[i + 1] = (byte)(value >>> 8);
                    ++j;
                }
            } else {
                for (i = 0; i < count; i += 2) {
                    value = pixels[j];
                    buffer[i] = (byte)(value >>> 8);
                    buffer[i + 1] = (byte)value;
                    ++j;
                }
            }
            out.write(buffer, 0, count);
            this.showProgress((double)(bytesWritten += count) / (double)size);
        }
    }

    void write16BitStack(OutputStream out, Object[] stack) throws IOException {
        this.showProgressBar = false;
        for (int i = 0; i < this.fi.nImages; ++i) {
            IJ.showStatus("Writing: " + (i + 1) + "/" + this.fi.nImages);
            this.write16BitImage(out, (short[])stack[i]);
            IJ.showProgress((double)(i + 1) / (double)this.fi.nImages);
        }
    }

    void writeFloatImage(OutputStream out, float[] pixels) throws IOException {
        int bytesWritten = 0;
        int size = this.fi.width * this.fi.height * 4;
        int count = 8192;
        byte[] buffer = new byte[count];
        boolean java2 = IJ.isJava2();
        while (bytesWritten < size) {
            int tmp;
            int i;
            if (bytesWritten + count > size) {
                count = size - bytesWritten;
            }
            int j = bytesWritten / 4;
            if (this.fi.intelByteOrder) {
                for (i = 0; i < count; i += 4) {
                    tmp = java2 ? Float.floatToRawIntBits(pixels[j]) : Float.floatToIntBits(pixels[j]);
                    buffer[i] = (byte)tmp;
                    buffer[i + 1] = (byte)(tmp >> 8);
                    buffer[i + 2] = (byte)(tmp >> 16);
                    buffer[i + 3] = (byte)(tmp >> 24);
                    ++j;
                }
            } else {
                for (i = 0; i < count; i += 4) {
                    tmp = java2 ? Float.floatToRawIntBits(pixels[j]) : Float.floatToIntBits(pixels[j]);
                    buffer[i] = (byte)(tmp >> 24);
                    buffer[i + 1] = (byte)(tmp >> 16);
                    buffer[i + 2] = (byte)(tmp >> 8);
                    buffer[i + 3] = (byte)tmp;
                    ++j;
                }
            }
            out.write(buffer, 0, count);
            this.showProgress((double)(bytesWritten += count) / (double)size);
        }
    }

    void writeFloatStack(OutputStream out, Object[] stack) throws IOException {
        this.showProgressBar = false;
        for (int i = 0; i < this.fi.nImages; ++i) {
            IJ.showStatus("Writing: " + (i + 1) + "/" + this.fi.nImages);
            this.writeFloatImage(out, (float[])stack[i]);
            IJ.showProgress((double)(i + 1) / (double)this.fi.nImages);
        }
    }

    void writeRGBImage(OutputStream out, int[] pixels) throws IOException {
        int bytesWritten = 0;
        int size = this.fi.width * this.fi.height * 3;
        int count = this.fi.width * 24;
        byte[] buffer = new byte[count];
        while (bytesWritten < size) {
            if (bytesWritten + count > size) {
                count = size - bytesWritten;
            }
            int j = bytesWritten / 3;
            for (int i = 0; i < count; i += 3) {
                buffer[i] = (byte)(pixels[j] >> 16);
                buffer[i + 1] = (byte)(pixels[j] >> 8);
                buffer[i + 2] = (byte)pixels[j];
                ++j;
            }
            out.write(buffer, 0, count);
            this.showProgress((double)(bytesWritten += count) / (double)size);
        }
    }

    void writeRGBStack(OutputStream out, Object[] stack) throws IOException {
        this.showProgressBar = false;
        for (int i = 0; i < this.fi.nImages; ++i) {
            IJ.showStatus("Writing: " + (i + 1) + "/" + this.fi.nImages);
            this.writeRGBImage(out, (int[])stack[i]);
            IJ.showProgress((double)(i + 1) / (double)this.fi.nImages);
        }
    }

    public void write(OutputStream out) throws IOException {
        if (this.fi.pixels == null) {
            throw new IOException("ImageWriter: fi.pixels==null");
        }
        if (this.fi.nImages > 1 && !(this.fi.pixels instanceof Object[])) {
            throw new IOException("ImageWriter: fi.pixels not a stack");
        }
        switch (this.fi.fileType) {
            case 0: 
            case 5: {
                if (this.fi.nImages > 1) {
                    this.write8BitStack(out, (Object[])this.fi.pixels);
                    break;
                }
                this.write8BitImage(out, (byte[])this.fi.pixels);
                break;
            }
            case 1: 
            case 2: {
                if (this.fi.nImages > 1) {
                    this.write16BitStack(out, (Object[])this.fi.pixels);
                    break;
                }
                this.write16BitImage(out, (short[])this.fi.pixels);
                break;
            }
            case 4: {
                if (this.fi.nImages > 1) {
                    this.writeFloatStack(out, (Object[])this.fi.pixels);
                    break;
                }
                this.writeFloatImage(out, (float[])this.fi.pixels);
                break;
            }
            case 6: {
                if (this.fi.nImages > 1) {
                    this.writeRGBStack(out, (Object[])this.fi.pixels);
                    break;
                }
                this.writeRGBImage(out, (int[])this.fi.pixels);
                break;
            }
        }
    }
}

