/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb.jdal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class XMLTreeNode
implements Serializable {
    public static final String ARRAY_TYPE = "_ArrayNode_";
    public static final String DYNAMIC_TYPE = "_DynamicNode_";
    public static final String MAP_TYPE = "_MapNode_";
    public static final String NORMAL_TYPE = "_NormalNode_";
    XMLTreeNode m_parent;
    LinkedHashMap<String, XMLTreeNode> m_subNodesMap;
    LinkedHashMap<String, XMLTreeNode> m_elementsMap;
    LinkedHashMap<String, String> m_fieldMap;
    String m_name;
    String m_nameSpace;
    String m_type;

    XMLTreeNode(XMLTreeNode pParent) {
        this.m_parent = pParent;
        this.m_subNodesMap = new LinkedHashMap();
        this.m_fieldMap = new LinkedHashMap();
        this.m_nameSpace = "";
        this.m_type = NORMAL_TYPE;
    }

    boolean isMapNode() {
        return this.m_type.equals(MAP_TYPE);
    }

    boolean isArrayNode() {
        return this.m_type.equals(ARRAY_TYPE);
    }

    boolean isDynamicNode() {
        return this.m_type.equals(DYNAMIC_TYPE);
    }

    boolean isNormalNode() {
        return this.m_type.equals(NORMAL_TYPE);
    }

    void setDynamicNode() {
        this.m_type = DYNAMIC_TYPE;
    }

    void setMapNode() {
        this.m_type = MAP_TYPE;
    }

    void setArrayNode() {
        this.m_type = ARRAY_TYPE;
    }

    void setNormalNode() {
        this.m_type = NORMAL_TYPE;
    }

    public void markNodesAsElements() {
        if (this.m_elementsMap == null) {
            this.m_elementsMap = new LinkedHashMap<String, XMLTreeNode>(this.m_subNodesMap);
        }
    }

    public String getAttributeNames() {
        StringBuffer retVal = new StringBuffer(128);
        Iterator<String> i = this.m_fieldMap.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next();
            if (key.startsWith(" xmlns") || key.startsWith("xmlns") || key.startsWith("xsi:") || key.equals("space")) continue;
            retVal.append(key);
            if (!i.hasNext()) continue;
            retVal.append(',');
        }
        return retVal.toString();
    }

    public String getElementNames() {
        if (this.m_elementsMap == null) {
            return this.getNodeNames();
        }
        StringBuffer retVal = new StringBuffer(128);
        Iterator<String> i = this.m_elementsMap.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next();
            retVal.append(key);
            if (!i.hasNext()) continue;
            retVal.append(",");
        }
        return retVal.toString();
    }

    public String getSubNodeNames() {
        if (this.m_elementsMap == null || this.m_subNodesMap.size() == 0 || this.m_elementsMap.size() == this.m_subNodesMap.size()) {
            return "";
        }
        LinkedHashMap<String, XMLTreeNode> diff = new LinkedHashMap<String, XMLTreeNode>(this.m_subNodesMap);
        for (String key : this.m_elementsMap.keySet()) {
            diff.remove(key);
        }
        StringBuffer retVal = new StringBuffer(128);
        Iterator<String> i = diff.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next();
            retVal.append(key);
            if (!i.hasNext()) continue;
            retVal.append(",");
        }
        return retVal.toString();
    }

    public String getNodeNames() {
        StringBuffer retVal = new StringBuffer(128);
        Iterator<String> i = this.m_subNodesMap.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next();
            retVal.append(key);
            if (!i.hasNext()) continue;
            retVal.append(",");
        }
        return retVal.toString();
    }

    public String getAttributeAndNodeNames() {
        String retVal = this.getAttributeNames();
        String elementNames = this.getNodeNames();
        if (elementNames.length() == 0) {
            return retVal;
        }
        if (retVal.length() > 0) {
            return retVal + "," + elementNames;
        }
        return elementNames;
    }

    public LinkedHashMap<String, String> getFieldMap() {
        return this.m_fieldMap;
    }

    public HashMap<String, XMLTreeNode> getNodesMap() {
        return this.m_subNodesMap;
    }

    public String getName() {
        return this.m_name;
    }

    public String getRawName() {
        if (this.isArrayNode() || this.isDynamicNode() || this.isMapNode()) {
            if (this.m_nameSpace.length() == 0) {
                return "e";
            }
            return this.m_nameSpace + ":e";
        }
        if (this.m_nameSpace.length() == 0) {
            return this.m_name;
        }
        return this.m_nameSpace + ":" + this.m_name;
    }

    public String toString(boolean withMapNames) {
        return this.toString(0, withMapNames);
    }

    public String toString(int indent, boolean withMapNames) {
        StringBuffer s = new StringBuffer(256);
        for (int i = 0; i < indent; ++i) {
            s.append("\t");
        }
        s.append("<" + this.m_nameSpace);
        if (!this.m_nameSpace.equals("")) {
            s.append(":");
        }
        if (this.isArrayNode() || this.isDynamicNode() || !withMapNames && this.isMapNode()) {
            s.append("e");
        } else {
            s.append(this.m_name);
        }
        for (String key : this.m_fieldMap.keySet()) {
            String value = this.m_fieldMap.get(key);
            s.append(" " + key + "=\"" + value + "\"");
        }
        Iterator<String> i = this.m_subNodesMap.keySet().iterator();
        if (!i.hasNext() || this.isArrayNode()) {
            s.append(" />");
        } else {
            s.append(">");
            while (i.hasNext()) {
                String key;
                s.append("\n");
                key = i.next();
                XMLTreeNode node = this.m_subNodesMap.get(key);
                s.append(node.toString(indent + 1, withMapNames));
            }
            s.append("\n");
            for (int j = 0; j < indent; ++j) {
                s.append("\t");
            }
            s.append("</" + this.m_nameSpace);
            if (!this.m_nameSpace.equals("")) {
                s.append(":");
            }
            if (this.isDynamicNode() || !withMapNames && this.isMapNode()) {
                s.append("e");
            } else {
                s.append(this.m_name);
            }
            s.append(">");
        }
        return s.toString();
    }
}

