/*
 * Decompiled with CFR 0.152.
 */
package alma.hibernate.util;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.type.StringType;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.ParameterizedType;

public class StringEnumUserType
implements EnhancedUserType,
ParameterizedType {
    private Class<Enum> enumClass;

    public void setParameterValues(Properties parameters) {
        String enumClassName = parameters.getProperty("enumClassName");
        try {
            this.enumClass = ReflectHelper.classForName((String)enumClassName);
            try {
                this.enumClass.getMethod("valueOfForEnum", String.class);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException e) {
                throw new HibernateException("Class '" + this.enumClass.getCanonicalName() + "' does not implement the valueOfForEnum(String), cannot proceed");
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("Enum class not found", (Throwable)cnfe);
        }
    }

    public Class returnedClass() {
        return this.enumClass;
    }

    public int[] sqlTypes() {
        return new int[]{StringType.INSTANCE.sqlType()};
    }

    public boolean isMutable() {
        return false;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object fromXMLString(String xmlValue) {
        try {
            return this.enumClass.getMethod("valueOfForEnum", String.class).invoke(this.enumClass, xmlValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HibernateException("Cannot invoke valueOfForEnum(String) in class '" + this.enumClass.getCanonicalName() + "'");
        }
    }

    public String objectToSQLString(Object value) {
        return "'" + value.toString() + "'";
    }

    public String toXMLString(Object value) {
        return value.toString();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor si, Object owner) throws HibernateException, SQLException {
        String name = rs.getString(names[0]);
        try {
            return rs.wasNull() ? null : this.enumClass.getMethod("valueOfForEnum", String.class).invoke(this.enumClass, name);
        }
        catch (Exception e) {
            throw new HibernateException("Cannot invoke valueOfForEnum(String) in class '" + this.enumClass.getCanonicalName() + "'");
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor si) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, StringType.INSTANCE.sqlType());
        } else {
            st.setString(index, value.toString());
        }
    }
}

