/*
 * Decompiled with CFR 0.152.
 */
package alma.hibernate.util;

import alma.hibernate.util.JdbcNativeExtractor;
import com.mchange.v2.c3p0.impl.C3P0ResultSetPeeker;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.UserType;

public class HibernateXmlType
implements UserType,
Serializable {
    private static final long serialVersionUID = -3359971984030700151L;
    private static final String COM_MCHANGE_V2_C3P0 = "com.mchange.v2.c3p0";
    private static final String ORACLE_JDBC = "oracle.jdbc";
    private static final String GET_STRING_VAL = "getStringVal";
    private static final String XML_TYPE = "oracle.xdb.XMLType";
    private static final int[] SQL_TYPES = new int[]{2007};

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor si, Object owner) throws HibernateException, SQLException {
        if (rs.getClass().getName().startsWith(COM_MCHANGE_V2_C3P0)) {
            rs = C3P0ResultSetPeeker.getInnerFrom(rs);
        }
        if (rs.getClass().getName().startsWith(ORACLE_JDBC)) {
            Object object;
            Object xmlType = null;
            try {
                Class<?> clazz = Class.forName(XML_TYPE);
                Method m = clazz.getMethod(GET_STRING_VAL, new Class[0]);
                xmlType = rs.getObject(names[0]);
                object = xmlType != null ? m.invoke(xmlType, new Object[0]) : null;
            }
            catch (Exception e) {
                try {
                    throw new SQLException("Failed to convert XMLTYPE String to Document for retrieval", e);
                }
                catch (Throwable throwable) {
                    this.close(xmlType);
                    throw throwable;
                }
            }
            this.close(xmlType);
            return object;
        }
        return this.nonOracleNullSafeGet(rs, names, si, owner);
    }

    private void close(Object xmlType) throws SQLException {
        if (xmlType != null) {
            try {
                Class<?> clazz = Class.forName(XML_TYPE);
                Method m = clazz.getMethod("close", new Class[0]);
                m.invoke(xmlType, new Object[0]);
            }
            catch (Exception e) {
                throw new SQLException("Error while closing XMLTYPE", e);
            }
        }
    }

    private Object nonOracleNullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        Reader reader = rs.getCharacterStream(names[0]);
        if (reader == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(4096);
        try {
            char[] charbuf = new char[4096];
            int i = reader.read(charbuf);
            while (i > 0) {
                result.append(charbuf, 0, i);
                i = reader.read(charbuf);
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        return result.toString();
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor si) throws HibernateException, SQLException {
        JdbcNativeExtractor extractor = new JdbcNativeExtractor();
        Connection connection = extractor.getNativeConnection(st.getConnection());
        if (connection.getClass().getName().startsWith(ORACLE_JDBC)) {
            Object xmlType = null;
            try {
                if (value != null) {
                    Class<?> clazz = Class.forName(XML_TYPE);
                    Constructor<?> con = clazz.getConstructor(Connection.class, String.class);
                    xmlType = con.newInstance(connection, (String)value);
                    st.setObject(index, xmlType);
                }
                st.setNull(index, 2007, "SYS.XMLTYPE");
            }
            catch (Exception e) {
                throw new SQLException("Failed to convert Document to XMLTYPE String for storage", e);
            }
            finally {
                this.close(xmlType);
            }
        } else {
            this.nonOracleNullSafeSet(st, value, index, si);
        }
    }

    private void nonOracleNullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (value != null) {
            String string = (String)value;
            StringReader reader = new StringReader(string);
            st.setCharacterStream(index, (Reader)reader, string.length());
        } else {
            st.setNull(index, this.sqlTypes()[0]);
        }
    }

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public Class<?> returnedClass() {
        return String.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == null && y == null) {
            return true;
        }
        if (x == null && y != null) {
            return false;
        }
        return x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        try {
            return (Serializable)value;
        }
        catch (Exception e) {
            throw new HibernateException("Could not disassemble Document to Serializable", (Throwable)e);
        }
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        try {
            return (String)((Object)cached);
        }
        catch (Exception e) {
            throw new HibernateException("Could not assemble String to Document", (Throwable)e);
        }
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

