/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.util;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;

public class AcsFileFinderForDirectories {
    public static final String SEARCHPATH_PROPERTYNAME = "acs.system.path";
    public static final String ACSDATA_PATH_PROPERTYNAME = "ACS.data";
    private final Logger logger;
    private final List<File> rootDirs;

    public AcsFileFinderForDirectories(Logger logger, boolean includeAcsdataDir) {
        this.logger = logger;
        String searchpath = System.getProperty(SEARCHPATH_PROPERTYNAME, "");
        if (searchpath.isEmpty()) {
            logger.warning("Property 'acs.system.path' is empty.");
        }
        ArrayList<String> rootDirNames = new ArrayList<String>(Arrays.asList(searchpath.split(File.pathSeparator + "+")));
        if (includeAcsdataDir) {
            String acsdataDirName = System.getProperty(ACSDATA_PATH_PROPERTYNAME, "");
            if (acsdataDirName.isEmpty()) {
                logger.warning("Property 'ACS.data' is empty.");
            }
            rootDirNames.add(acsdataDirName);
        }
        this.rootDirs = new ArrayList<File>();
        for (String rootDirName : rootDirNames) {
            if (rootDirName.trim().isEmpty()) continue;
            File rootDir = new File(rootDirName);
            if (rootDir.exists() && rootDir.isDirectory() && rootDir.canRead()) {
                this.rootDirs.add(rootDir);
                continue;
            }
            logger.fine("Dropping bad root dir '" + rootDirName + "'.");
        }
    }

    List<File> getRootDirs() {
        return new ArrayList<File>(this.rootDirs);
    }

    public File findFile(String relativePath, String fileName) {
        if (relativePath == null) {
            relativePath = "";
        }
        for (File rootDir : this.rootDirs) {
            File dir = new File(rootDir, relativePath);
            File file = new File(dir, fileName);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public List<File> findFiles(String relativePath, FilenameFilter filter) {
        if (relativePath == null) {
            relativePath = "";
        }
        LinkedHashMap<CallSite, File> foundFiles = new LinkedHashMap<CallSite, File>();
        for (File rootDir : this.rootDirs) {
            File[] matchedFiles;
            File dir = new File(rootDir, relativePath);
            if (!dir.exists()) continue;
            for (File matchedFile : matchedFiles = dir.listFiles(filter)) {
                String relativePathName = relativePath + File.separator + matchedFile.getName();
                if (foundFiles.containsKey(relativePathName)) continue;
                foundFiles.put((CallSite)((Object)relativePathName), matchedFile);
            }
        }
        return new ArrayList<File>(foundFiles.values());
    }
}

