/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.util.Arrays;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.task.ConsumerTask;
import uk.ac.starlink.ttools.task.InputTableSpec;
import uk.ac.starlink.ttools.task.TableMapper;
import uk.ac.starlink.ttools.task.TableMapping;
import uk.ac.starlink.ttools.task.TableProducer;

public abstract class MapperTask
extends ConsumerTask {
    private final TableMapper mapper_;

    public MapperTask(String purpose, ProcessingMode outMode, boolean useOutFilter, TableMapper mapper) {
        super(purpose, outMode, useOutFilter);
        this.mapper_ = mapper;
        this.getParameterList().addAll(Arrays.asList(mapper.getParameters()));
    }

    protected abstract InputTableSpec[] getInputSpecs(Environment var1) throws TaskException;

    protected TableProducer createProducer(Environment env) throws TaskException {
        final InputTableSpec[] inSpecs = this.getInputSpecs(env);
        final TableMapping mapping = this.mapper_.createMapping(env, inSpecs.length);
        return new TableProducer(){

            public StarTable getTable() throws IOException, TaskException {
                return mapping.mapTables(inSpecs);
            }
        };
    }

    public TableMapper getMapper() {
        return this.mapper_;
    }
}

