/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.util.Iterator;
import uk.ac.starlink.ttools.plot.BinnedData;

public class NormalisedBinnedData
implements BinnedData {
    private final BinnedData base_;
    private final double[] weightSums_;

    public NormalisedBinnedData(BinnedData base) {
        this.base_ = base;
        this.weightSums_ = new double[base.getSetCount()];
    }

    public void submitDatum(double value, double weight, boolean[] setFlags) {
        this.base_.submitDatum(value, weight, setFlags);
        for (int is = 0; is < setFlags.length; ++is) {
            if (!setFlags[is]) continue;
            int n = is;
            this.weightSums_[n] = this.weightSums_[n] + weight;
        }
    }

    public int getSetCount() {
        return this.base_.getSetCount();
    }

    public boolean isInteger() {
        return false;
    }

    public Iterator getBinIterator(boolean includeEmpty) {
        final Iterator baseIt = this.base_.getBinIterator(includeEmpty);
        return new Iterator(){

            public boolean hasNext() {
                return baseIt.hasNext();
            }

            public void remove() {
                baseIt.remove();
            }

            public Object next() {
                final BinnedData.Bin baseBin = (BinnedData.Bin)baseIt.next();
                return new BinnedData.Bin(){

                    public double getLowBound() {
                        return baseBin.getLowBound();
                    }

                    public double getHighBound() {
                        return baseBin.getHighBound();
                    }

                    public double getWeightedCount(int iset) {
                        double wsum = NormalisedBinnedData.this.weightSums_[iset];
                        return wsum == 0.0 ? 0.0 : baseBin.getWeightedCount(iset) / wsum;
                    }
                };
            }
        };
    }
}

