/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import uk.ac.starlink.ttools.func.Maths;

public class Fluxes {
    public static final double JOHNSON_AB_V = 0.044;
    public static final double JOHNSON_AB_B = 0.163;
    public static final double JOHNSON_AB_Bj = 0.139;
    public static final double JOHNSON_AB_R = -0.055;
    public static final double JOHNSON_AB_I = -0.309;
    public static final double JOHNSON_AB_g = 0.013;
    public static final double JOHNSON_AB_r = 0.226;
    public static final double JOHNSON_AB_i = 0.296;
    public static final double JOHNSON_AB_Rc = -0.117;
    public static final double JOHNSON_AB_Ic = -0.342;
    public static final double JOHNSON_AB_uPrime = 0.0;
    public static final double JOHNSON_AB_gPrime = 0.0;
    public static final double JOHNSON_AB_rPrime = 0.0;
    public static final double JOHNSON_AB_iPrime = 0.0;
    public static final double JOHNSON_AB_zPrime = 0.0;
    public static final double VEGA_AB_J = -0.91;
    public static final double VEGA_AB_H = -1.39;
    public static final double VEGA_AB_K = -1.85;

    private Fluxes() {
    }

    public static double abToJansky(double magAB) {
        return Math.pow(10.0, 23.0 - (magAB + 48.6) / 2.5);
    }

    public static double janskyToAb(double fluxJansky) {
        return 2.5 * (23.0 - Maths.log10(fluxJansky)) - 48.6;
    }

    public static double luminosityToFlux(double lumin, double dist) {
        return 0.25 * lumin / Math.PI / (dist * dist);
    }

    public static double fluxToLuminosity(double flux, double dist) {
        return Math.PI * 4 * dist * dist * flux;
    }
}

