/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.adapters;

import alma.acs.logging.AcsLogger;
import alma.acs.logging.ClientLogManager;
import alma.acs.logging.adapters.Log4jLogger;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.DefaultRepositorySelector;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RepositorySelector;
import org.apache.log4j.spi.RootLogger;
import org.apache.log4j.varia.NullAppender;

public class Log4jFactory
implements LoggerFactory {
    public static final String LASER_LOGGER_NAME_PREFIX = "laser";
    private final Map<String, Logger> loggerMap = new HashMap<String, Logger>();

    public static void enableAcsLogging() {
        System.setProperty("log4j.defaultInitOverride", "true");
        MyLog4jHierarchy h = new MyLog4jHierarchy();
        DefaultRepositorySelector repositorySelector = new DefaultRepositorySelector((LoggerRepository)h);
        LogManager.setRepositorySelector((RepositorySelector)repositorySelector, null);
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.removeAllAppenders();
        rootLogger.addAppender((Appender)new NullAppender());
        rootLogger.setLevel(Level.ALL);
    }

    public synchronized Logger makeNewLoggerInstance(String name) {
        Logger myLogger;
        StackTraceElement[] stackTrace;
        String loggerNameBase = "unknown";
        for (StackTraceElement stackTraceElement : stackTrace = new Exception().getStackTrace()) {
            if (!stackTraceElement.getClassName().contains("cern.laser.")) continue;
            loggerNameBase = LASER_LOGGER_NAME_PREFIX;
            break;
        }
        if ((myLogger = this.loggerMap.get(loggerNameBase)) == null) {
            AcsLogger delegate = ClientLogManager.getAcsLogManager().getLoggerForCorba(loggerNameBase, true);
            myLogger = new Log4jLogger(loggerNameBase, delegate);
            this.loggerMap.put(loggerNameBase, myLogger);
        }
        return myLogger;
    }

    private static class MyLog4jHierarchy
    extends Hierarchy {
        private final LoggerFactory myFactory = new Log4jFactory();

        public MyLog4jHierarchy() {
            super((Logger)new RootLogger(Level.DEBUG));
        }

        public Logger getLogger(String name) {
            return this.getLogger(name, this.myFactory);
        }
    }
}

