/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging;

import alma.acs.concurrent.DaemonThreadFactory;
import alma.acs.logging.LogRecordComparator;
import alma.acs.logging.RemoteLogDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class DispatchingLogQueue {
    private volatile PriorityBlockingQueue<LogRecord> queue;
    private final ReentrantLock flushLock;
    private final AtomicLong flushedLogCount = new AtomicLong(0L);
    private final ScheduledThreadPoolExecutor executor;
    private ScheduledFuture<?> flushScheduleFuture;
    private long lastFlushFinished;
    private int currentFlushPeriod = 0;
    private final AtomicBoolean outOfCapacity;
    private final AtomicBoolean scarceCapacity;
    private int preOverflowFlushPeriod = 0;
    private RemoteLogDispatcher remoteLogDispatcher;
    private int maxQueueSize;
    private final boolean DEBUG = Boolean.getBoolean("alma.acs.logging.verbose");
    private static boolean LOSSLESS = Boolean.getBoolean("alma.acs.logging.lossless");

    DispatchingLogQueue() {
        this.outOfCapacity = new AtomicBoolean(false);
        this.scarceCapacity = new AtomicBoolean(false);
        this.setMaxQueueSize(1000);
        this.flushLock = new ReentrantLock();
        this.queue = new PriorityBlockingQueue<LogRecord>(100, new LogRecordComparator());
        this.executor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new DaemonThreadFactory("LogDispatcher"));
        this.executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
    }

    int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    synchronized void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    synchronized boolean log(LogRecord logRecord) {
        int oldSize = this.queue.size();
        if (oldSize >= this.maxQueueSize) {
            boolean firstTimeOverflow;
            boolean bl = firstTimeOverflow = !this.outOfCapacity.getAndSet(true);
            if (firstTimeOverflow) {
                this.preOverflowFlushPeriod = this.currentFlushPeriod;
                this.setPeriodicFlushing(10000);
            }
            if (LOSSLESS) {
                do {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (this.queue.size() >= this.maxQueueSize);
            } else {
                if (this.DEBUG || firstTimeOverflow) {
                    System.out.println("log queue overflow: log record with message '" + logRecord.getMessage() + "' and possibly future log records will not be sent to the remote logging service.");
                }
                return false;
            }
        }
        if (this.outOfCapacity.getAndSet(false)) {
            this.setPeriodicFlushing(this.preOverflowFlushPeriod);
            this.preOverflowFlushPeriod = 0;
            System.out.println("log queue no longer overflowing.");
        }
        if (!LOSSLESS) {
            int filterThreshold = this.maxQueueSize * 7 / 10;
            if (oldSize >= filterThreshold) {
                boolean firstTimeScarce;
                boolean bl = firstTimeScarce = !this.scarceCapacity.getAndSet(true);
                if (logRecord.getLevel().intValue() < Level.INFO.intValue()) {
                    if (this.DEBUG || firstTimeScarce) {
                        System.out.println("looming log queue overflow (" + (oldSize + 1) + "/" + this.maxQueueSize + "): low-level log record with message '" + logRecord.getMessage() + "' and possibly other log records below INFO level will not be sent to the remote logging service.");
                    }
                    return false;
                }
            } else {
                this.scarceCapacity.set(false);
            }
        }
        this.queue.put(logRecord);
        if (this.DEBUG) {
            System.out.println("DispatchingLogQueue#log called with record msg = " + logRecord.getMessage());
        }
        this.flushIfEnoughRecords(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushAllAndWait() {
        if (this.DEBUG) {
            System.out.println("DispatchingLogQueue#flushAllAndWait() called");
        }
        if (!this.hasRemoteDispatcher()) {
            if (this.DEBUG) {
                System.out.println("ignoring call to DispatchingLogQueue#flushAllAndWait because the remote log service has not been supplied.");
            }
            return;
        }
        boolean flushSuccess = true;
        int initialQueueSize = this.realQueueSize();
        long targetFlushCount = this.flushedLogCount.get() + (long)initialQueueSize;
        while (this.flushedLogCount.get() < targetFlushCount) {
            Future<Boolean> future = this.flush();
            try {
                flushSuccess = future.get();
            }
            catch (Exception e) {
                flushSuccess = false;
                if (this.DEBUG) {
                    System.out.println("flushAll: exception occurred while waiting for flush thread. Will try again. " + e.toString());
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                if (!this.DEBUG) continue;
                System.out.println("DispatchingLogQueue#flushAllAndWait() called flush(), success = " + flushSuccess);
            }
        }
    }

    Future<Boolean> flush() {
        if (this.DEBUG) {
            System.out.println("DispatchingLogQueue#flush() called in thread " + Thread.currentThread().getName());
        }
        Callable<Boolean> cmd = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return new Boolean(DispatchingLogQueue.this.flush(false));
            }
        };
        ScheduledFuture<Boolean> future = this.executor.schedule(cmd, 0L, TimeUnit.NANOSECONDS);
        if (this.DEBUG) {
            System.out.println("Pending log flushes: " + this.pendingFlushes());
        }
        return future;
    }

    private void flushIfEnoughRecords(boolean conservative) {
        int numRecords = this.queue.size();
        if (this.DEBUG) {
            System.out.println("flushIfEnoughRecords(" + conservative + "): current queue size is " + numRecords + ", remote dispatcher available: " + this.hasRemoteDispatcher());
        }
        if (this.hasRemoteDispatcher() && numRecords > 0 && (numRecords % this.remoteLogDispatcher.getBufferSize() == 0 || !conservative && numRecords >= this.remoteLogDispatcher.getBufferSize())) {
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flush(boolean isScheduled) {
        if (this.DEBUG) {
            System.out.println("DispatchingLogQueue#flush(isScheduled=" + isScheduled + ") called in thread " + Thread.currentThread().getName());
        }
        boolean flushedSomeRecords = false;
        if (!this.hasRemoteDispatcher()) {
            System.out.println("failed to flush logging queue because remote logging service has not been made available.");
        } else {
            this.flushLock.lock();
            try {
                LogRecord[] logRecords;
                int bufferSize = this.remoteLogDispatcher.getBufferSize();
                int queueSize = this.queue.size();
                LogRecord[] allRecords = this.queue.toArray(new LogRecord[queueSize]);
                if (queueSize > bufferSize) {
                    logRecords = new LogRecord[bufferSize];
                    System.arraycopy(allRecords, 0, logRecords, 0, bufferSize);
                } else {
                    logRecords = new LogRecord[queueSize];
                    System.arraycopy(allRecords, 0, logRecords, 0, queueSize);
                }
                if (logRecords.length != 0) {
                    flushedSomeRecords = this.flushLogRecords(logRecords);
                    if (flushedSomeRecords) {
                        if (this.DEBUG) {
                            System.out.println("flushing was successful, will try again if there are enough records queued.");
                        }
                        this.flushIfEnoughRecords(false);
                    }
                } else if (this.DEBUG) {
                    System.out.println("flush(isScheduled=" + isScheduled + "): no log records found!");
                }
            }
            finally {
                this.flushLock.unlock();
            }
        }
        return flushedSomeRecords;
    }

    private boolean flushLogRecords(LogRecord[] logRecords) {
        if (this.DEBUG) {
            System.out.println("DispatchingLogQueue#flushLogRecords called in thread " + Thread.currentThread().getName());
        }
        boolean flushedSomeRecords = true;
        RemoteLogDispatcher.FailedLogRecords failures = this.remoteLogDispatcher.sendLogRecords(logRecords);
        ArrayList<LogRecord> allFailures = new ArrayList<LogRecord>();
        if (failures.hasSendFailures()) {
            List<LogRecord> sendFailures = failures.getSendFailures();
            allFailures.addAll(sendFailures);
            boolean bl = flushedSomeRecords = sendFailures.size() < logRecords.length;
            if (this.DEBUG) {
                System.out.println("flushLogRecords: had to add back " + sendFailures.size() + " send-failed log records to the queue.");
            }
        }
        if (failures.hasSerializationFailures()) {
            for (LogRecord logRecord : failures.getSerializationFailures()) {
                System.out.println("Failed to translate log record for sending remotely. Log message = " + logRecord.getMessage());
            }
            flushedSomeRecords = true;
        }
        for (LogRecord e : logRecords) {
            if (allFailures.contains(e)) continue;
            this.queue.remove(e);
            this.flushedLogCount.incrementAndGet();
        }
        this.lastFlushFinished = System.currentTimeMillis();
        return flushedSomeRecords;
    }

    boolean hasRemoteDispatcher() {
        return this.remoteLogDispatcher != null;
    }

    int recordQueueSize() {
        return this.queue.size();
    }

    int pendingFlushes() {
        BlockingQueue<Runnable> flushQueue = this.executor.getQueue();
        int size = flushQueue.size();
        if (this.flushesPeriodically()) {
            --size;
        }
        return size;
    }

    int realQueueSize() {
        this.flushLock.lock();
        try {
            int n = this.queue.size();
            return n;
        }
        finally {
            this.flushLock.unlock();
        }
    }

    boolean flushesPeriodically() {
        return this.flushScheduleFuture != null;
    }

    void setPeriodicFlushing(final int periodMillisec) {
        if (!this.hasRemoteDispatcher()) {
            System.out.println("DispatchingLogQueue#setPeriodicFlushing is ignored until setRemoteLogDispatcher() has been called!");
            return;
        }
        if (this.currentFlushPeriod == periodMillisec && this.flushesPeriodically()) {
            return;
        }
        this.currentFlushPeriod = periodMillisec;
        if (this.flushesPeriodically()) {
            this.flushScheduleFuture.cancel(false);
            this.flushScheduleFuture = null;
            if (this.DEBUG && periodMillisec == 0) {
                System.out.println("Stopping periodic log flushing.");
            }
        }
        if (periodMillisec > 0) {
            Runnable cmd = new Runnable(){

                @Override
                public void run() {
                    if (DispatchingLogQueue.this.queue.size() > 0) {
                        if (DispatchingLogQueue.this.lastFlushFinished <= System.currentTimeMillis() - (long)periodMillisec) {
                            try {
                                DispatchingLogQueue.this.flush(true);
                            }
                            catch (Throwable thr) {
                                System.out.println("Scheduled flushing of log buffer failed: " + thr.getMessage());
                            }
                        } else if (DispatchingLogQueue.this.DEBUG) {
                            System.out.println("Skipping a scheduled log flush because of another recent flush.");
                        }
                    } else if (DispatchingLogQueue.this.DEBUG) {
                        System.out.println("Skipping a scheduled log flush because log queue is empty.");
                    }
                }
            };
            this.flushScheduleFuture = this.executor.scheduleWithFixedDelay(cmd, periodMillisec, periodMillisec, TimeUnit.MILLISECONDS);
        }
    }

    void setRemoteLogDispatcher(RemoteLogDispatcher remoteLogDispatcher) {
        this.remoteLogDispatcher = remoteLogDispatcher;
    }

    void shutDown() {
        if (this.DEBUG) {
            System.out.println("DispatchingLogQueue#shutDown called");
        }
        if (!this.executor.isShutdown()) {
            this.executor.shutdown();
        }
    }
}

