/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.ToolTipManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

class IconBox
extends JComponent {
    private final List entryList_;
    private final ListDataListener modelListener_;
    private final Color enabledBg_;
    private final Color disabledBg_;
    private boolean vertical_;
    private boolean trailing_;
    private boolean reversed_;
    private int transSize_;
    private int gap_;
    private CellRenderer renderer_;
    private ListModel model_;
    private Dimension minSize_;
    private Dimension maxSize_;
    private Dimension prefSize_;
    private static final ListModel EMPTY_LIST_MODEL;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IconBox(int transSize) {
        this.transSize_ = transSize;
        this.setOpaque(true);
        this.disabledBg_ = null;
        this.enabledBg_ = Color.WHITE;
        this.setBackground(this.enabledBg_);
        this.modelListener_ = new ListDataListener(){

            public void contentsChanged(ListDataEvent evt) {
                int i0 = evt.getIndex0();
                int i1 = evt.getIndex1();
                if (0 <= i0 && i0 <= i1 && i1 <= IconBox.this.entryList_.size()) {
                    for (int i = i0; i <= i1; ++i) {
                        IconBox.this.entryList_.set(i, IconBox.this.createEntry(i));
                    }
                    IconBox.this.repaint();
                } else {
                    IconBox.this.refreshState();
                }
            }

            public void intervalAdded(ListDataEvent evt) {
                int i0 = evt.getIndex0();
                int i1 = evt.getIndex1();
                if (0 <= i0 && i0 <= i1 && i1 <= IconBox.this.model_.getSize()) {
                    for (int i = i0; i <= i1; ++i) {
                        IconBox.this.entryList_.add(i, IconBox.this.createEntry(i));
                    }
                    IconBox.this.repaint();
                } else {
                    IconBox.this.refreshState();
                }
            }

            public void intervalRemoved(ListDataEvent evt) {
                int i0 = evt.getIndex0();
                int i1 = evt.getIndex1();
                if (0 <= i0 && i0 <= i1 && i1 <= IconBox.this.entryList_.size()) {
                    for (int i = i1; i >= i0; --i) {
                        IconBox.this.entryList_.remove(i);
                    }
                    IconBox.this.repaint();
                } else {
                    IconBox.this.refreshState();
                }
            }
        };
        this.entryList_ = new ArrayList();
        this.gap_ = 4;
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setModel(EMPTY_LIST_MODEL);
        this.setRenderer(new DefaultRenderer());
    }

    public void setVertical(boolean vertical) {
        this.vertical_ = vertical;
        this.revalidate();
        this.repaint();
    }

    public boolean getVertical() {
        return this.vertical_;
    }

    public void setTrailing(boolean trailing) {
        this.trailing_ = trailing;
        this.repaint();
    }

    public boolean getTrailing() {
        return this.trailing_;
    }

    public void setReversed(boolean reversed) {
        this.reversed_ = reversed;
        this.repaint();
    }

    public boolean getReversed() {
        return this.reversed_;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setBackground(enabled ? this.enabledBg_ : this.disabledBg_);
    }

    private void refreshState() {
        this.entryList_.clear();
        int count = this.model_.getSize();
        for (int i = 0; i < count; ++i) {
            this.entryList_.add(this.createEntry(i));
        }
        this.repaint();
    }

    private Entry createEntry(int index) {
        Object value = this.model_.getElementAt(index);
        return new Entry(this.renderer_.getIcon(this, value, index), this.renderer_.getToolTipText(this, value, index));
    }

    public void setModel(ListModel model) {
        if (this.model_ != null) {
            this.model_.removeListDataListener(this.modelListener_);
        }
        this.model_ = model;
        if (this.model_ != null) {
            this.model_.addListDataListener(this.modelListener_);
        }
        this.refreshState();
    }

    public ListModel getModel() {
        return this.model_;
    }

    public void setTransverseSize(int transSize) {
        this.transSize_ = transSize;
        if (this.transSize_ != transSize) {
            this.repaint();
        }
    }

    public int getTransverseSize() {
        return this.transSize_;
    }

    public void setRenderer(CellRenderer renderer) {
        this.renderer_ = renderer;
        this.refreshState();
    }

    public CellRenderer getRenderer() {
        return this.renderer_;
    }

    public void setPreferredSize(Dimension prefSize) {
        this.prefSize_ = prefSize;
    }

    public Dimension getPreferredSize() {
        if (this.prefSize_ == null) {
            int leng = 0;
            Iterator it = this.entryList_.iterator();
            while (it.hasNext()) {
                Entry entry = (Entry)it.next();
                Icon icon = entry.icon_;
                leng += this.vertical_ ? icon.getIconHeight() : icon.getIconWidth();
                if (!it.hasNext()) continue;
                leng += this.gap_;
            }
            Dimension size = this.vertical_ ? new Dimension(this.transSize_, leng) : new Dimension(leng, this.transSize_);
            Insets insets = this.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            return size;
        }
        return this.prefSize_;
    }

    public void setMinimumSize(Dimension minSize) {
        this.minSize_ = minSize;
    }

    public Dimension getMinimumSize() {
        if (this.minSize_ == null) {
            Dimension size = this.vertical_ ? new Dimension(this.transSize_, 0) : new Dimension(0, this.transSize_);
            Insets insets = this.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            return size;
        }
        return this.minSize_;
    }

    public void setMaximumSize(Dimension maxSize) {
        this.maxSize_ = maxSize;
    }

    public Dimension getMaximumSize() {
        if (this.maxSize_ == null) {
            Dimension size = new Dimension(this.transSize_, this.transSize_);
            Insets insets = this.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            if (this.vertical_) {
                size.height = Integer.MAX_VALUE;
            } else {
                size.width = Integer.MAX_VALUE;
            }
            return size;
        }
        return this.maxSize_;
    }

    public int getIndexAt(Point point) {
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        ArrayList entryList = this.entryList_;
        if (this.reversed_) {
            entryList = new ArrayList(entryList);
            Collections.reverse(entryList);
        }
        int pLeng = this.trailing_ ? (this.vertical_ ? size.height - insets.bottom - point.y : size.width - insets.right - point.x) : (this.vertical_ ? point.y - insets.top : point.x - insets.left);
        int index = 0;
        Iterator it = entryList.iterator();
        while (it.hasNext()) {
            Icon icon = ((Entry)it.next()).icon_;
            int leng = this.gap_ + (this.vertical_ ? icon.getIconHeight() : icon.getIconWidth());
            if (pLeng < leng) {
                if (index < entryList.size()) {
                    return index;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return -1;
            }
            pLeng -= leng;
            ++index;
        }
        return -1;
    }

    protected void paintComponent(Graphics g) {
        int x;
        super.paintComponent(g);
        Dimension size = this.getSize();
        if (this.isOpaque()) {
            Color color = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, size.width, size.height);
            g.setColor(color);
        }
        Insets insets = this.getInsets();
        ArrayList entryList = this.entryList_;
        if (this.reversed_) {
            entryList = new ArrayList(entryList);
            Collections.reverse(entryList);
        }
        if (entryList.isEmpty()) {
            return;
        }
        int n = this.vertical_ ? insets.left : (x = this.trailing_ ? size.width - insets.right - ((Entry)entryList.get((int)0)).icon_.getIconWidth() : insets.left);
        int y = this.vertical_ ? (this.trailing_ ? size.height - insets.bottom - ((Entry)entryList.get((int)0)).icon_.getIconHeight() : insets.top) : insets.top;
        Iterator it = entryList.iterator();
        while (it.hasNext()) {
            int height;
            Icon icon = ((Entry)it.next()).icon_;
            int width = icon.getIconWidth();
            if (g.hitClip(x, y, width, height = icon.getIconHeight())) {
                icon.paintIcon(this, g, x, y);
            }
            if (this.vertical_) {
                y += (this.trailing_ ? -1 : 1) * (height + this.gap_);
                continue;
            }
            x += (this.trailing_ ? -1 : 1) * (width + this.gap_);
        }
    }

    public String getToolTipText(MouseEvent evt) {
        int index = this.getIndexAt(evt.getPoint());
        return index >= 0 ? ((Entry)this.entryList_.get((int)index)).tooltip_ : null;
    }

    private static ListModel createEmptyListModel() {
        return new AbstractListModel(){

            public int getSize() {
                return 0;
            }

            public Object getElementAt(int index) {
                return null;
            }
        };
    }

    static {
        $assertionsDisabled = !IconBox.class.desiredAssertionStatus();
        EMPTY_LIST_MODEL = IconBox.createEmptyListModel();
    }

    private class DefaultRenderer
    implements CellRenderer,
    Icon {
        private DefaultRenderer() {
        }

        public Icon getIcon(IconBox iconBox, Object value, int index) {
            return value instanceof Icon ? (Icon)value : this;
        }

        public String getToolTipText(IconBox iconBox, Object value, int index) {
            return value == null ? null : value.toString();
        }

        public int getIconWidth() {
            return IconBox.this.transSize_;
        }

        public int getIconHeight() {
            return IconBox.this.transSize_;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.drawOval(x, y, IconBox.this.transSize_, IconBox.this.transSize_);
        }
    }

    private static class Entry {
        final Icon icon_;
        final String tooltip_;

        Entry(Icon icon, String tooltip) {
            this.icon_ = icon;
            this.tooltip_ = tooltip;
        }
    }

    static interface CellRenderer {
        public Icon getIcon(IconBox var1, Object var2, int var3);

        public String getToolTipText(IconBox var1, Object var2, int var3);
    }
}

