/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.awt.GraphicsEnvironment;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import junit.framework.AssertionFailedError;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.util.StarEntityResolver;

public class TestCase
extends junit.framework.TestCase {
    private Random rand = new Random(23L);
    public static final short IGNORE_ATTRIBUTE_PRESENCE = 1;
    public static final short IGNORE_ATTRIBUTE_VALUE = 2;
    public static final short IGNORE_WHITESPACE = 4;
    public static final short IGNORE_COMMENTS = 8;
    private static DocumentBuilder docParser;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TestCase(String name) {
        super(name);
    }

    public void assertArrayEquals(String message, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        TestCase.assertEquals((String)this.combineMessages(message, "array component class mismatch"), (String)TestCase.getClassName(expected), (String)TestCase.getClassName(actual));
        Class<?> clazz = actual.getClass();
        Class<?> ctype = clazz.getComponentType();
        TestCase.assertNotNull((String)this.combineMessages(message, "not array objects"), ctype);
        int nel = Math.min(Array.getLength(actual), Array.getLength(expected));
        if (ctype == Boolean.TYPE) {
            for (int i = 0; i < nel; ++i) {
                boolean v1 = ((boolean[])expected)[i];
                boolean v2 = ((boolean[])actual)[i];
                if (v1 == v2) continue;
                TestCase.assertEquals((String)this.itemMismatchMessage(message, i), (boolean)v1, (boolean)v2);
            }
        } else if (ctype == Byte.TYPE) {
            for (int i = 0; i < nel; ++i) {
                byte v1 = ((byte[])expected)[i];
                byte v2 = ((byte[])actual)[i];
                if (v1 == v2) continue;
                TestCase.assertEquals((String)this.itemMismatchMessage(message, i), (byte)v1, (byte)v2);
            }
        } else if (ctype == Short.TYPE) {
            for (int i = 0; i < nel; ++i) {
                short v1 = ((short[])expected)[i];
                short v2 = ((short[])actual)[i];
                if (v1 == v2) continue;
                TestCase.assertEquals((String)this.itemMismatchMessage(message, i), (short)v1, (short)v2);
            }
        } else if (ctype == Integer.TYPE) {
            for (int i = 0; i < nel; ++i) {
                int v1 = ((int[])expected)[i];
                int v2 = ((int[])actual)[i];
                if (v1 == v2) continue;
                TestCase.assertEquals((String)this.itemMismatchMessage(message, i), (int)v1, (int)v2);
            }
        } else if (ctype == Long.TYPE) {
            for (int i = 0; i < nel; ++i) {
                long v1 = ((long[])expected)[i];
                long v2 = ((long[])actual)[i];
                if (v1 == v2) continue;
                TestCase.assertEquals((String)this.itemMismatchMessage(message, i), (long)v1, (long)v2);
            }
        } else if (ctype == Float.TYPE) {
            for (int i = 0; i < nel; ++i) {
                float v1 = ((float[])expected)[i];
                float v2 = ((float[])actual)[i];
                if (v1 == v2 || Float.isNaN(v1) && Float.isNaN(v2)) continue;
                TestCase.assertEquals((String)this.itemMismatchMessage(message, i), (float)v1, (float)v2, (float)0.0f);
            }
        } else if (ctype == Double.TYPE) {
            for (int i = 0; i < nel; ++i) {
                double v1 = ((double[])expected)[i];
                double v2 = ((double[])actual)[i];
                if (v1 == v2 || Double.isNaN(v1) && Double.isNaN(v2)) continue;
                TestCase.assertEquals((String)this.itemMismatchMessage(message, i), (double)v1, (double)v2, (double)0.0);
            }
        } else if (ctype == Character.TYPE) {
            for (int i = 0; i < nel; ++i) {
                char v1 = ((char[])expected)[i];
                char v2 = ((char[])actual)[i];
                if (v1 == v2) continue;
                TestCase.assertEquals((String)this.itemMismatchMessage(message, i), (double)v1, (double)v2, (double)0.0);
            }
        } else {
            for (int i = 0; i < nel; ++i) {
                Object v2;
                Object v1 = Array.get(expected, i);
                if (v1 == (v2 = Array.get(actual, i))) continue;
                TestCase.assertEquals((String)this.itemMismatchMessage(message, i), (Object)v1, (Object)v2);
            }
        }
        TestCase.assertEquals((String)this.combineMessages(message, "array length mismatch"), (int)Array.getLength(expected), (int)Array.getLength(actual));
    }

    public void assertArrayNotEquals(String message, Object expected, Object actual) {
        boolean equal;
        try {
            this.assertArrayEquals(message, expected, actual);
            equal = true;
        }
        catch (AssertionFailedError e) {
            equal = false;
        }
        TestCase.assertTrue((String)message, (!equal ? 1 : 0) != 0);
    }

    public void assertArrayEquals(Object expected, Object actual) {
        this.assertArrayEquals(null, expected, actual);
    }

    public void assertArrayNotEquals(Object expected, Object actual) {
        this.assertArrayNotEquals(null, expected, actual);
    }

    public void assertArrayEquals(String message, Object expected, Object actual, double delta) {
        if (expected == null && actual == null) {
            return;
        }
        TestCase.assertEquals((String)this.combineMessages(message, "array component class mismatch"), (String)TestCase.getClassName(expected), (String)TestCase.getClassName(actual));
        Class<?> clazz = actual.getClass();
        Class<?> ctype = clazz.getComponentType();
        TestCase.assertNotNull((String)this.combineMessages(message, "not array objects"), ctype);
        TestCase.assertEquals((String)this.combineMessages(message, "array length mismatch"), (int)Array.getLength(expected), (int)Array.getLength(actual));
        int nel = Array.getLength(actual);
        delta = Math.abs(delta);
        if (ctype == Byte.TYPE) {
            for (int i = 0; i < nel; ++i) {
                byte v1 = ((byte[])expected)[i];
                byte v2 = ((byte[])actual)[i];
                if (!((double)Math.abs(v1 - v2) > delta)) continue;
                TestCase.assertEquals((String)this.itemMismatchMessage(message, i), (byte)v1, (byte)v2);
            }
        } else if (ctype == Short.TYPE) {
            for (int i = 0; i < nel; ++i) {
                short v1 = ((short[])expected)[i];
                short v2 = ((short[])actual)[i];
                if (!((double)Math.abs(v1 - v2) > delta)) continue;
                TestCase.assertEquals((String)this.itemMismatchMessage(message, i), (short)v1, (short)v2);
            }
        } else if (ctype == Integer.TYPE) {
            for (int i = 0; i < nel; ++i) {
                int v1 = ((int[])expected)[i];
                int v2 = ((int[])actual)[i];
                if (!((double)Math.abs(v1 - v2) > delta)) continue;
                TestCase.assertEquals((String)this.itemMismatchMessage(message, i), (int)v1, (int)v2);
            }
        } else if (ctype == Long.TYPE) {
            for (int i = 0; i < nel; ++i) {
                long v1 = ((long[])expected)[i];
                long v2 = ((long[])actual)[i];
                if (!((double)Math.abs(v1 - v2) > delta)) continue;
                TestCase.assertEquals((String)this.itemMismatchMessage(message, i), (long)v1, (long)v2);
            }
        } else if (ctype == Float.TYPE) {
            for (int i = 0; i < nel; ++i) {
                boolean finite;
                float v1 = ((float[])expected)[i];
                float v2 = ((float[])actual)[i];
                boolean bl = finite = !Float.isInfinite(v1);
                if (!finite && v1 == v2 || finite && (double)Math.abs(v1 - v2) <= delta || Float.isNaN(v1) && Float.isNaN(v2)) continue;
                TestCase.assertEquals((String)this.itemMismatchMessage(message, i), (float)v1, (float)v2, (float)((float)delta));
            }
        } else if (ctype == Double.TYPE) {
            for (int i = 0; i < nel; ++i) {
                boolean finite;
                double v1 = ((double[])expected)[i];
                double v2 = ((double[])actual)[i];
                boolean bl = finite = !Double.isInfinite(v1);
                if (!finite && v1 == v2 || finite && Math.abs(v1 - v2) <= delta || Double.isNaN(v1) && Double.isNaN(v2)) continue;
                TestCase.assertEquals((String)this.itemMismatchMessage(message, i), (double)v1, (double)v2, (double)delta);
            }
        } else if (ctype == Character.TYPE) {
            for (int i = 0; i < nel; ++i) {
                char v1 = ((char[])expected)[i];
                char v2 = ((char[])actual)[i];
                if (!((double)Math.abs(v1 - v2) > delta)) continue;
                TestCase.assertEquals((String)this.itemMismatchMessage(message, i), (char)v1, (char)v2);
            }
        } else {
            throw new IllegalArgumentException("Non-numeric array " + ctype + "[] not permitted");
        }
    }

    public void assertArrayNotEquals(String message, Object expected, Object actual, double delta) {
        boolean equal;
        try {
            this.assertArrayEquals(message, expected, actual, delta);
            equal = true;
        }
        catch (AssertionFailedError e) {
            equal = false;
        }
        TestCase.assertTrue((String)message, (!equal ? 1 : 0) != 0);
    }

    public void assertArrayEquals(Object expected, Object actual, double delta) {
        this.assertArrayEquals(null, expected, actual, delta);
    }

    public void assertArrayNotEquals(Object expected, Object actual, double delta) {
        this.assertArrayNotEquals(null, expected, actual, delta);
    }

    public void assertEquals(String message, float expected, float actual) {
        TestCase.assertEquals((String)message, (float)expected, (float)actual, (float)0.0f);
    }

    public void assertEquals(float expected, float actual) {
        TestCase.assertEquals((float)expected, (float)actual, (float)0.0f);
    }

    public void assertEquals(String message, double expected, double actual) {
        TestCase.assertEquals((String)message, (double)expected, (double)actual, (double)0.0);
    }

    public void assertEquals(double expected, double actual) {
        TestCase.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    public void assertDOMEquals(URL url, Node actual) throws IOException, SAXException, ParserConfigurationException {
        this.assertDOMEquals(url.openStream(), actual, url.toString().replaceFirst(".*/", ".../") + ":", 0);
    }

    public void assertDOMEquals(URL url, Node actual, String context, int flags) throws IOException, SAXException, ParserConfigurationException {
        this.assertDOMEquals(url.openStream(), actual, context, flags);
    }

    public void assertDOMEquals(String s, Node n) throws IOException, SAXException, ParserConfigurationException {
        this.assertDOMEquals(s, n, "string:", 0);
    }

    public void assertDOMEquals(String expected, Node actual, String context, int flags) throws IOException, SAXException, ParserConfigurationException {
        ByteArrayInputStream bais = new ByteArrayInputStream(expected.getBytes());
        this.assertDOMEquals(bais, actual, context == null ? "string:" : context, flags);
    }

    public void assertDOMEquals(InputStream s, Node actual, String context, int flags) throws IOException, SAXException, ParserConfigurationException {
        if (docParser == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            docParser = factory.newDocumentBuilder();
        }
        Document doc = docParser.parse(s);
        this.assertDOMEquals(doc.getDocumentElement(), actual, context, flags);
    }

    public void assertDOMEquals(Node expected, Node actual) {
        this.assertDOMEquals(expected, actual, null, 0);
    }

    public void assertSourceEquals(Source expected, Source actual, String context, int flags) {
        Transformer trans;
        if (expected == null && actual == null) {
            return;
        }
        try {
            trans = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Unexpected configuration error", e);
        }
        DOMResult res1 = new DOMResult();
        DOMResult res2 = new DOMResult();
        try {
            trans.transform(expected, res1);
            trans.transform(actual, res2);
            this.assertDOMEquals(res1.getNode(), res2.getNode(), context, flags);
        }
        catch (TransformerException e) {
            throw (AssertionFailedError)new AssertionFailedError("At least one source could not be transformed").initCause((Throwable)e);
        }
    }

    public void assertDOMEquals(Node expected, Node actual, String context, int flags) {
        NamedNodeMap okatts;
        if (context == null) {
            context = "TOP:";
        }
        context = context + expected.getNodeName();
        TestCase.assertNotNull((String)context, (Object)expected);
        TestCase.assertNotNull((String)context, (Object)actual);
        if (expected.getNodeType() != actual.getNodeType()) {
            StringBuffer msg = new StringBuffer(context);
            msg.append(": expected ").append(DOMUtils.mapNodeType(expected.getNodeType())).append("='").append(expected.getNodeValue()).append("', got ").append(DOMUtils.mapNodeType(actual.getNodeType())).append("='").append(actual.getNodeValue()).append("'");
            TestCase.fail((String)msg.toString());
        }
        TestCase.assertEquals((String)(context + "(type)"), (short)expected.getNodeType(), (short)actual.getNodeType());
        String expectedNS = expected.getNamespaceURI();
        TestCase.assertEquals((String)(context + "(ns)"), (String)expectedNS, (String)actual.getNamespaceURI());
        if (expectedNS == null) {
            TestCase.assertEquals((String)(context + "(name)"), (String)expected.getNodeName(), (String)actual.getNodeName());
        } else {
            TestCase.assertEquals((String)(context + "(localName)"), (String)expected.getLocalName(), (String)actual.getLocalName());
        }
        TestCase.assertEquals((String)(context + "(value)"), (String)expected.getNodeValue(), (String)actual.getNodeValue());
        if ((flags & 1) == 0 && (okatts = expected.getAttributes()) != null) {
            NamedNodeMap testatts = actual.getAttributes();
            TestCase.assertNotNull((String)context, (Object)testatts);
            TestCase.assertEquals((String)(context + "(natts)"), (int)okatts.getLength(), (int)testatts.getLength());
            for (int i = 0; i < okatts.getLength(); ++i) {
                Attr okatt = (Attr)okatts.item(i);
                Attr testatt = (Attr)testatts.getNamedItem(okatt.getName());
                TestCase.assertNotNull((Object)testatt);
                if ((flags & 2) != 0) continue;
                TestCase.assertEquals((String)(context + '@' + okatt.getName()), (String)okatt.getValue(), (String)testatt.getValue());
            }
        }
        Node okkid = this.nextIncludedNode(expected.getFirstChild(), flags);
        Node testkid = this.nextIncludedNode(actual.getFirstChild(), flags);
        int kidno = 1;
        while (okkid != null) {
            TestCase.assertNotNull((String)(context + " too few kid elements"), (Object)testkid);
            this.assertDOMEquals(okkid, testkid, context + "/[" + Integer.toString(kidno) + ']', flags);
            okkid = this.nextIncludedNode(okkid.getNextSibling(), flags);
            testkid = this.nextIncludedNode(testkid.getNextSibling(), flags);
            ++kidno;
        }
        TestCase.assertNull((String)(context + " extra kids: " + testkid), (Object)testkid);
    }

    private Node nextIncludedNode(Node n, int flags) {
        if (flags == 0) {
            return n;
        }
        while (n != null) {
            boolean veto = false;
            switch (n.getNodeType()) {
                case 3: {
                    if ((flags & 4) == 0 || n.getNodeValue().trim().length() != 0) break;
                    veto = true;
                    break;
                }
                case 8: {
                    if ((flags & 8) == 0) break;
                    veto = true;
                    break;
                }
            }
            if (!veto) {
                return n;
            }
            n = n.getNextSibling();
        }
        if (!$assertionsDisabled && n != null) {
            throw new AssertionError();
        }
        return null;
    }

    public void assertValidXML(String message, InputSource isrc) throws IOException, SAXException {
        SAXParser parser;
        String prefix = message == null ? "" : message + ": ";
        try {
            SAXParserFactory sfact = SAXParserFactory.newInstance();
            sfact.setValidating(true);
            parser = sfact.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(prefix + "Unexpected failure to get " + "validating SAX parser", e);
        }
        TestCase.assertTrue((String)"Check parser is validating", (boolean)parser.isValidating());
        final StarEntityResolver resolver = StarEntityResolver.getInstance();
        DefaultHandler handler = new DefaultHandler(){

            public void warning(SAXParseException e) throws SAXException {
                this.rethrow(e);
            }

            public void error(SAXParseException e) throws SAXException {
                this.rethrow(e);
            }

            public void fatalError(SAXParseException e) throws SAXException {
                this.rethrow(e);
            }

            private void rethrow(SAXParseException e) throws SAXException {
                StringBuffer sbuf = new StringBuffer();
                sbuf.append("Parse error").append(e.getMessage());
                String sysid = e.getSystemId();
                if (sysid != null && sysid.length() > 0) {
                    sbuf.append(" in " + sysid);
                }
                sbuf.append(" at line " + e.getLineNumber());
                sbuf.append(" column " + e.getColumnNumber());
                throw new SAXException(sbuf.toString(), e);
            }

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                try {
                    return resolver.resolveEntity(publicId, systemId);
                }
                catch (IOException e) {
                    throw new SAXException(e.getMessage(), e);
                }
            }
        };
        parser.parse(isrc, handler);
    }

    public void assertValidXML(InputSource isrc) throws IOException, SAXException {
        this.assertValidXML(null, isrc);
    }

    public void fillRandom(Object array, double min, double max) {
        Class<?> clazz = array.getClass().getComponentType();
        int size = Array.getLength(array);
        if (clazz == Byte.TYPE) {
            min = Math.max(min, -128.0);
            max = Math.min(max, 127.0);
            double range = max - min;
            byte[] arr = (byte[])array;
            for (int i = 0; i < size; ++i) {
                arr[i] = (byte)(min + this.rand.nextDouble() * range);
            }
        } else if (clazz == Short.TYPE) {
            min = Math.max(min, -32768.0);
            max = Math.min(max, 32767.0);
            double range = max - min;
            short[] arr = (short[])array;
            for (int i = 0; i < size; ++i) {
                arr[i] = (short)(min + this.rand.nextDouble() * range);
            }
        } else if (clazz == Integer.TYPE) {
            min = Math.max(min, -2.147483648E9);
            max = Math.min(max, 2.147483647E9);
            double range = max - min;
            int[] arr = (int[])array;
            for (int i = 0; i < size; ++i) {
                arr[i] = (int)(min + this.rand.nextDouble() * range);
            }
        } else if (clazz == Long.TYPE) {
            min = Math.max(min, -9.223372036854776E18);
            max = Math.min(max, 9.223372036854776E18);
            double range = max - min;
            long[] arr = (long[])array;
            for (int i = 0; i < size; ++i) {
                arr[i] = (long)(min + this.rand.nextDouble() * range);
            }
        } else if (clazz == Float.TYPE) {
            min = Math.max(min, -3.4028234663852886E38);
            max = Math.min(max, 3.4028234663852886E38);
            double range = max - min;
            float[] arr = (float[])array;
            for (int i = 0; i < size; ++i) {
                arr[i] = (float)(min + this.rand.nextDouble() * range);
            }
        } else if (clazz == Double.TYPE) {
            double range = max - min;
            double[] arr = (double[])array;
            for (int i = 0; i < size; ++i) {
                arr[i] = min + this.rand.nextDouble() * range;
            }
        } else {
            throw new IllegalArgumentException("Unsupported array type or not an array " + TestCase.getClassName(array));
        }
    }

    public void fillRandom(Object array, int min, int max) {
        this.fillRandom(array, (double)min, (double)max + 0.99);
    }

    public void fillCycle(Object array, int min, int max) {
        Class<?> clazz = array.getClass().getComponentType();
        int size = Array.getLength(array);
        if (clazz == Byte.TYPE) {
            byte[] arr = (byte[])array;
            byte val = (byte)min;
            for (int i = 0; i < size; ++i) {
                byte by = val;
                val = (byte)(val + 1);
                arr[i] = by;
                if (val <= max) continue;
                val = (byte)min;
            }
        } else if (clazz == Short.TYPE) {
            short[] arr = (short[])array;
            short val = (short)min;
            for (int i = 0; i < size; ++i) {
                short s = val;
                val = (short)(val + 1);
                arr[i] = s;
                if (val <= max) continue;
                val = (short)min;
            }
        } else if (clazz == Integer.TYPE) {
            int[] arr = (int[])array;
            int val = min;
            for (int i = 0; i < size; ++i) {
                arr[i] = val++;
                if (val <= max) continue;
                val = min;
            }
        } else if (clazz == Long.TYPE) {
            long[] arr = (long[])array;
            long val = min;
            for (int i = 0; i < size; ++i) {
                if (++val <= (long)max) continue;
                val = min;
            }
        } else if (clazz == Float.TYPE) {
            float[] arr = (float[])array;
            float val = min;
            for (int i = 0; i < size; ++i) {
                if (!((val += 1.0f) > (float)max)) continue;
                val = min;
            }
        } else if (clazz == Double.TYPE) {
            double[] arr = (double[])array;
            double val = min;
            for (int i = 0; i < size; ++i) {
                if (!((val += 1.0) > (double)max)) continue;
                val = min;
            }
        } else {
            throw new IllegalArgumentException("Unsupported array type or not an array " + TestCase.getClassName(array));
        }
    }

    public void fillCycle(Object destArray, Object sourceArray) {
        Class<?> clazz = destArray.getClass();
        if (!clazz.isArray() || !clazz.equals(sourceArray.getClass())) {
            throw new IllegalArgumentException();
        }
        int nsrc = Array.getLength(sourceArray);
        int ndst = Array.getLength(destArray);
        for (int start = 0; start < ndst; start += nsrc) {
            System.arraycopy(sourceArray, 0, destArray, start, Math.min(nsrc, ndst - start));
        }
    }

    public static boolean isHeadless() {
        if (GraphicsEnvironment.isHeadless()) {
            return true;
        }
        try {
            GraphicsEnvironment.getLocalGraphicsEnvironment();
        }
        catch (Throwable e) {
            return true;
        }
        return false;
    }

    private static String getClassName(Object o) {
        return o == null ? "(null)" : o.getClass().getName();
    }

    private String combineMessages(String msg, String detail) {
        return msg != null ? msg + " - " + detail : detail;
    }

    private String itemMismatchMessage(String msg, int ix) {
        return this.combineMessages(msg, "element [" + ix + "] mismatch");
    }

    static {
        $assertionsDisabled = !TestCase.class.desiredAssertionStatus();
    }
}

