/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.io.IOException;
import java.io.InputStream;
import uk.ac.starlink.util.FastPipedOutputStream;

class FastPipedInputStream
extends InputStream {
    byte[] buffer;
    boolean closed = false;
    int readLaps = 0;
    int readPosition = 0;
    FastPipedOutputStream source;
    int writeLaps = 0;
    int writePosition = 0;

    FastPipedInputStream() throws IOException {
        this(null);
    }

    public FastPipedInputStream(FastPipedOutputStream source) throws IOException {
        this(source, 65536);
    }

    public FastPipedInputStream(FastPipedOutputStream source, int bufferSize) throws IOException {
        if (source != null) {
            this.connect(source);
        }
        this.buffer = new byte[bufferSize];
    }

    public int available() throws IOException {
        return this.writePosition > this.readPosition ? this.writePosition - this.readPosition : (this.writePosition < this.readPosition ? this.buffer.length - this.readPosition + 1 + this.writePosition : (this.writeLaps > this.readLaps ? this.buffer.length : 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.source == null) {
            throw new IOException("Unconnected pipe");
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            this.closed = true;
            this.buffer.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void connect(FastPipedOutputStream source) throws IOException {
        if (this.source != null) {
            throw new IOException("Pipe already connected");
        }
        this.source = source;
        source.sink = this;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public void mark(int readLimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        return this.read(b, 0, 1) == -1 ? -1 : 0xFF & b[0];
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.source == null) {
            throw new IOException("Unconnected pipe");
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            if (this.writePosition == this.readPosition && this.writeLaps == this.readLaps) {
                if (this.closed) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return -1;
                }
                try {
                    this.buffer.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException(e.getMessage());
                }
                return this.read(b, off, len);
            }
            int amount = Math.min(len, (this.writePosition > this.readPosition ? this.writePosition : this.buffer.length) - this.readPosition);
            System.arraycopy(this.buffer, this.readPosition, b, off, amount);
            this.readPosition += amount;
            if (this.readPosition == this.buffer.length) {
                this.readPosition = 0;
                ++this.readLaps;
            }
            if (amount < len) {
                int second = this.read(b, off + amount, len - amount);
                int n = second == -1 ? amount : amount + second;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return n;
            }
            this.buffer.notifyAll();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return amount;
        }
    }
}

