/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class AsciiFileParser {
    protected boolean fixed = false;
    protected int nFields = 0;
    protected ArrayList rowList = new ArrayList();
    protected char singleComment = (char)35;
    protected char inlineComment = (char)33;
    protected String delims = null;

    public AsciiFileParser() {
    }

    public AsciiFileParser(boolean fixed) {
        this.setFixed(fixed);
    }

    public AsciiFileParser(File file) {
        this.parse(file);
    }

    public AsciiFileParser(File file, boolean fixed) {
        this.setFixed(fixed);
        this.parse(file);
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void parse(File file) {
        this.rowList.clear();
        this.decode(file);
    }

    public int getNFields() {
        return this.nFields;
    }

    public int getNFields(int row) {
        if (this.rowList.size() > row) {
            return ((String[])this.rowList.get(row)).length;
        }
        return 0;
    }

    public int getNRows() {
        return this.rowList.size();
    }

    public String[] getRow(int row) {
        if (this.rowList.size() > row) {
            return (String[])this.rowList.get(row);
        }
        return null;
    }

    public String getStringField(int row, int column) {
        String[] line = this.getRow(row);
        if (line != null && column < line.length) {
            return line[column];
        }
        return null;
    }

    public int getIntegerField(int row, int column) {
        String value = this.getStringField(row, column);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    public double getDoubleField(int row, int column) {
        String value = this.getStringField(row, column);
        if (value != null) {
            return Double.parseDouble(value);
        }
        return 0.0;
    }

    public boolean getBooleanField(int row, int column) {
        String value = this.getStringField(row, column);
        return value.charAt(0) == 't' || value.charAt(0) == 'T';
    }

    public void setSingleCommentChar(char singleComment) {
        this.singleComment = singleComment;
    }

    public char getSingleCommentChar() {
        return this.singleComment;
    }

    public void setInlineCommentChar(char inlineComment) {
        this.inlineComment = inlineComment;
    }

    public char getInlineCommentChar() {
        return this.inlineComment;
    }

    public void setDelimeters(String delims) {
        this.delims = delims;
    }

    public String getDelimeters() {
        return this.delims;
    }

    protected void decode(File file) {
        if (!file.exists() && file.canRead() && file.isFile()) {
            return;
        }
        FileInputStream f = null;
        BufferedReader r = null;
        try {
            f = new FileInputStream(file);
            r = new BufferedReader(new InputStreamReader(f));
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String raw = null;
        Object clean = null;
        int nlines = 0;
        boolean nwords = false;
        int trail = 0;
        int count = 0;
        this.nFields = 4096;
        StringTokenizer st = null;
        String[] items = null;
        try {
            while ((raw = r.readLine()) != null) {
                if (raw.length() == 0 || raw.charAt(0) == this.singleComment) continue;
                trail = raw.indexOf(this.inlineComment);
                if (trail != -1) {
                    raw = raw.substring(0, trail - 1);
                }
                st = this.delims == null ? new StringTokenizer(raw) : new StringTokenizer(raw, this.delims);
                count = st.countTokens();
                if (this.fixed && nlines != 0 && count != this.nFields) {
                    System.err.println("File contains incorrect number of fields (line '" + raw + "') -- ignored");
                    continue;
                }
                this.nFields = this.fixed ? count : Math.min(this.nFields, count);
                items = new String[count];
                for (int i = 0; i < count; ++i) {
                    items[i] = st.nextToken();
                }
                this.rowList.add(items);
                ++nlines;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            r.close();
            f.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

