/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.basic;

import diva.graph.modular.BasicModularGraphModel;
import diva.graph.modular.CompositeNode;
import diva.graph.modular.Edge;
import diva.graph.modular.Graph;
import diva.graph.modular.Node;
import diva.util.ArrayIterator;
import diva.util.BasicPropertyContainer;
import diva.util.IteratorAdapter;
import diva.util.SemanticObjectContainer;
import java.util.ArrayList;
import java.util.Iterator;

public class BasicGraphModel
extends BasicModularGraphModel {
    public BasicGraphModel() {
        super(new BasicCompositeNode((Object)null));
    }

    public CompositeNode createComposite(Object semanticObject) {
        return new BasicCompositeNode(semanticObject);
    }

    public Edge createEdge(Object semanticObject) {
        return new BasicEdge(semanticObject);
    }

    public Node createNode(Object semanticObject) {
        return new BasicNode(semanticObject);
    }

    private static class BasicEdge
    extends Intermediate
    implements Edge {
        private boolean _directed = true;
        private Node _head = null;
        private Node _tail = null;
        private double _weight = 1.0;

        public BasicEdge(Object userObject) {
            this(userObject, null, null);
        }

        public BasicEdge(Object userObject, Node tail, Node head) {
            this.setSemanticObject(userObject);
            this.setTail(tail);
            this.setHead(head);
        }

        public boolean acceptHead(Node head) {
            return true;
        }

        public boolean acceptTail(Node tail) {
            return true;
        }

        public Node getHead() {
            return this._head;
        }

        public Node getTail() {
            return this._tail;
        }

        public double getWeight() {
            return this._weight;
        }

        public boolean isDirected() {
            return this._directed;
        }

        public void setDirected(boolean val) {
            this._directed = val;
        }

        public void setHead(Node n) {
            if (this._head != null) {
                ((BasicNode)this._head).removeInEdge(this);
            }
            this._head = n;
            if (this._head != null) {
                ((BasicNode)this._head).addInEdge(this);
            }
        }

        public void setTail(Node n) {
            if (this._tail != null) {
                ((BasicNode)this._tail).removeOutEdge(this);
            }
            this._tail = n;
            if (this._tail != null) {
                ((BasicNode)this._tail).addOutEdge(this);
            }
        }

        public void setWeight(double weight) {
            this._weight = weight;
        }

        public String toString() {
            Object o = this.getSemanticObject();
            return "Edge[" + o + "]";
        }
    }

    private static class BasicCompositeNode
    extends BasicNode
    implements CompositeNode {
        private ArrayList _nodes = new ArrayList();

        public BasicCompositeNode(Object userObject) {
            super(userObject);
        }

        public void add(Node n) {
            this._nodes.add(n);
        }

        public boolean contains(Node n) {
            return this._nodes.contains(n);
        }

        public int getNodeCount() {
            return this._nodes.size();
        }

        public Node getNode(int i) {
            return (Node)this._nodes.get(i);
        }

        public int getIndex(Node n) {
            return this._nodes.indexOf(n);
        }

        public Iterator nodes() {
            return this._nodes.iterator();
        }

        public void remove(Node n) {
            this._nodes.remove(n);
        }

        public String toString() {
            Object o = this.getSemanticObject();
            return "CompositeNode[" + o + "]";
        }
    }

    private static class BasicNode
    extends Intermediate
    implements Node {
        private ArrayList _in = new ArrayList();
        private ArrayList _out = new ArrayList();
        private CompositeNode _parent = null;

        public BasicNode(Object userObject) {
            this.setSemanticObject(userObject);
        }

        public void addInEdge(Edge e) {
            this._in.add(e);
        }

        public void addOutEdge(Edge e) {
            this._out.add(e);
        }

        public Graph getParent() {
            return this._parent;
        }

        public Iterator inEdges() {
            return new ArrayIterator(this._in.toArray());
        }

        public Iterator inNodes() {
            return new IteratorAdapter(){
                Iterator edges;
                {
                    this.edges = BasicNode.this.inEdges();
                }

                public boolean hasNext() {
                    return this.edges.hasNext();
                }

                public Object next() {
                    return ((Edge)this.edges.next()).getTail();
                }
            };
        }

        public Iterator outEdges() {
            return new ArrayIterator(this._out.toArray());
        }

        public Iterator outNodes() {
            return new IteratorAdapter(){
                Iterator edges;
                {
                    this.edges = BasicNode.this.outEdges();
                }

                public boolean hasNext() {
                    return this.edges.hasNext();
                }

                public Object next() {
                    return ((Edge)this.edges.next()).getHead();
                }
            };
        }

        public void removeInEdge(Edge e) {
            this._in.remove(e);
        }

        public void removeOutEdge(Edge e) {
            this._out.remove(e);
        }

        public void setParent(Graph parent) {
            if (this._parent != null) {
                ((BasicCompositeNode)this._parent).remove(this);
            }
            this._parent = (BasicCompositeNode)parent;
            if (this._parent != null) {
                ((BasicCompositeNode)this._parent).add(this);
            }
        }

        public String toString() {
            Object o = this.getSemanticObject();
            return "BasicNode[" + o + "]";
        }
    }

    private static abstract class Intermediate
    extends BasicPropertyContainer
    implements SemanticObjectContainer {
        private Object _semanticObject = null;

        private Intermediate() {
        }

        public Object getSemanticObject() {
            return this._semanticObject;
        }

        public void setSemanticObject(Object o) {
            this._semanticObject = o;
        }
    }
}

